/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.common.client.gui.element;

import com.minelittlepony.common.client.gui.IField;
import com.minelittlepony.common.client.gui.Tooltip;
import com.minelittlepony.common.client.gui.element.Button;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSlider<T>
extends Button
implements IField<T, AbstractSlider<T>> {
    private float min;
    private float max;
    private float value;
    @NotNull
    private IField.IChangeCallback<T> action = IField.IChangeCallback::none;
    @Nullable
    private Function<AbstractSlider<T>, class_2561> textFunc;
    @Nullable
    private Function<AbstractSlider<T>, Tooltip> tooltipFunc;

    public AbstractSlider(int x, int y, float min, float max, T value) {
        super(x, y);
        this.min = min;
        this.max = max;
        this.value = AbstractSlider.convertFromRange(this.valueToFloat(value), min, max);
    }

    protected abstract float valueToFloat(T var1);

    protected abstract T floatToValue(float var1);

    @Override
    public AbstractSlider<T> onChange(@NotNull IField.IChangeCallback<T> action) {
        this.action = action;
        return this;
    }

    public AbstractSlider<T> setTextFormat(@NotNull Function<AbstractSlider<T>, class_2561> formatter) {
        this.textFunc = formatter;
        this.getStyle().setText(formatter.apply(this));
        return this;
    }

    public AbstractSlider<T> setTooltipFormat(@NotNull Function<AbstractSlider<T>, Tooltip> formatter) {
        this.tooltipFunc = formatter;
        this.getStyle().setTooltip(formatter.apply(this));
        return this;
    }

    @Override
    public AbstractSlider<T> setValue(T value) {
        this.setClampedValue(AbstractSlider.convertFromRange(this.valueToFloat(value), this.min, this.max));
        return this;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.field_22763 && this.field_22764 && (keyCode == 263 || keyCode == 262)) {
            this.method_25354(class_310.method_1551().method_1483());
            float step = (this.max - this.min) / 4.0f;
            if (keyCode == 263) {
                step *= -1.0f;
            }
            this.setClampedValue(this.value + step);
            this.method_25306();
            return true;
        }
        return false;
    }

    protected void setClampedValue(float value) {
        if ((value = class_3532.method_15363((float)value, (float)0.0f, (float)1.0f)) != this.value) {
            float initial = this.value;
            this.value = value;
            this.value = AbstractSlider.convertFromRange(this.valueToFloat(this.action.perform(this.getValue())), this.min, this.max);
            if (this.value != initial) {
                if (this.textFunc != null) {
                    this.getStyle().setText(this.textFunc.apply(this));
                }
                if (this.tooltipFunc != null) {
                    this.getStyle().setTooltip(this.tooltipFunc.apply(this));
                }
            }
        }
    }

    private void onChange(double mouseX) {
        this.setClampedValue((float)(mouseX - (double)(this.method_46426() + 4)) / (float)(this.method_25368() - 8));
    }

    @Override
    public T getValue() {
        return this.floatToValue(AbstractSlider.convertToRange(this.value, this.min, this.max));
    }

    public void method_25348(double mouseX, double mouseY) {
        super.method_25348(mouseX, mouseY);
        this.onChange(mouseX);
    }

    protected void method_25349(double mouseX, double mouseY, double mouseDX, double mouseDY) {
        this.onChange(mouseX);
    }

    @Override
    protected void renderBackground(class_332 context, class_310 mc, int mouseX, int mouseY) {
        int i = super.method_49602();
        int sliderX = this.method_46426() + (int)(this.value * (float)(this.method_25368() - 8));
        this.renderButtonBlit(context, sliderX, this.method_46427(), i, 8, 20);
    }

    protected int method_49602() {
        return 46;
    }

    static float convertFromRange(float value, float min, float max) {
        return (class_3532.method_15363((float)value, (float)min, (float)max) - min) / (max - min);
    }

    static float convertToRange(float value, float min, float max) {
        return class_3532.method_15363((float)(min + value * (max - min)), (float)min, (float)max);
    }
}

