/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.connector.service.hacks;

import cpw.mods.cl.ModuleClassLoader;
import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.api.IModuleLayerManager;
import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.sinytra.connector.service.hacks.ModuleLayerMigrator;

public class ServiceProviderInheritanceWorkaround {
    private static final MethodHandle LAYER_BIND_TO_LOADER = (MethodHandle)LamdbaExceptionUtils.uncheck(() -> ModuleLayerMigrator.TRUSTED_LOOKUP.findSpecial(ModuleLayer.class, "bindToLoader", MethodType.methodType(Void.TYPE, ClassLoader.class), ModuleLayer.class));

    public static void apply() {
        Launcher.INSTANCE.findLayerManager().flatMap(manager -> manager.getLayer(IModuleLayerManager.Layer.GAME)).ifPresent(moduleLayer -> ServiceProviderInheritanceWorkaround.applyToLoader((ModuleClassLoader)moduleLayer.modules().iterator().next().getClassLoader(), moduleLayer.parents()));
    }

    private static void bindToLayer(ModuleClassLoader classLoader, ModuleLayer layer) {
        try {
            LAYER_BIND_TO_LOADER.invokeExact(layer, (ClassLoader)classLoader);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static void applyToLoader(ModuleClassLoader classLoader, List<ModuleLayer> parentLayers) {
        HashSet visitedLayers = new HashSet();
        parentLayers.forEach(p -> ServiceProviderInheritanceWorkaround.forLayerAndParents(p, visitedLayers, l -> ServiceProviderInheritanceWorkaround.bindToLayer(classLoader, l)));
    }

    private static void forLayerAndParents(ModuleLayer layer, Set<ModuleLayer> visited, Consumer<ModuleLayer> operation) {
        if (visited.contains(layer)) {
            return;
        }
        visited.add(layer);
        operation.accept(layer);
        if (layer != ModuleLayer.boot()) {
            layer.parents().forEach(l -> ServiceProviderInheritanceWorkaround.forLayerAndParents(l, visited, operation));
        }
    }
}

