/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.connector.locator;

import com.mojang.logging.LogUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.moddiscovery.AbstractJarFileModLocator;
import net.minecraftforge.fml.loading.moddiscovery.ModDiscoverer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.filter.MarkerFilter;
import org.sinytra.connector.loader.ConnectorEarlyLoader;
import org.sinytra.connector.locator.ConnectorLocator;
import org.sinytra.connector.locator.EmbeddedDependencies;
import org.slf4j.Logger;

public class ConnectorEarlyLocator
extends AbstractJarFileModLocator {
    private static final String NAME = "connector_early_locator";
    private static final Logger LOGGER = LogUtils.getLogger();

    public Stream<Path> scanCandidates() {
        try {
            Method method = FMLLoader.class.getDeclaredMethod("getModDiscoverer", new Class[0]);
            method.setAccessible(true);
            ModDiscoverer discoverer = (ModDiscoverer)method.invoke(null, new Object[0]);
            Field field = ModDiscoverer.class.getDeclaredField("dependencyLocatorList");
            field.setAccessible(true);
            List dependencyLocatorList = (List)field.get(discoverer);
            dependencyLocatorList.sort(Comparator.comparingInt(loc -> loc instanceof ConnectorLocator ? 1 : 0));
        }
        catch (Throwable t) {
            LOGGER.error("Error sorting FML dependency locators", t);
            ConnectorEarlyLoader.addGenericLoadingException(t, "Error sorting FML dependency locators");
        }
        ConnectorEarlyLocator.injectLogMarkers();
        return EmbeddedDependencies.locateEmbeddedJars();
    }

    public String name() {
        return NAME;
    }

    public void initArguments(Map<String, ?> arguments) {
    }

    private static void injectLogMarkers() {
        String markerselection = System.getProperty("connector.logging.markers", "");
        Arrays.stream(markerselection.split(",")).forEach(marker -> System.setProperty("connector.logging.marker." + marker.toLowerCase(Locale.ROOT), "ACCEPT"));
        org.apache.logging.log4j.core.Logger logger = (org.apache.logging.log4j.core.Logger)LogManager.getLogger(ConnectorEarlyLocator.class);
        Configuration config = logger.getContext().getConfiguration();
        config.addFilter((Filter)MarkerFilter.createFilter((String)"MIXINPATCH", (Filter.Result)ConnectorEarlyLocator.parseLogMarker("connector.logging.marker.mixinpatch"), (Filter.Result)Filter.Result.NEUTRAL));
        logger.getContext().updateLoggers();
    }

    private static Filter.Result parseLogMarker(String propertyName) {
        String value = System.getProperty(propertyName, "DENY");
        return Filter.Result.valueOf((String)value);
    }
}

