/*
 * Decompiled with CFR 0.152.
 */
package moe.caramel.mica;

import com.mojang.blaze3d.platform.Window;
import java.io.File;
import java.nio.file.Path;
import java.util.Properties;
import moe.caramel.mica.natives.DwmApi;
import net.minecraft.client.Minecraft;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.dedicated.Settings;
import org.jetbrains.annotations.NotNull;

public final class ModConfig
extends Settings<ModConfig> {
    private static final Path MOD_CONFIG = new File("./config/caramel.mica.properties").toPath();
    private static ModConfig instance;
    public final Settings.MutableValue<Boolean> useImmersiveDarkMode = this.m_139864_("use-immersive-dark-mode", Boolean::parseBoolean, false);
    public final Settings.MutableValue<DwmApi.DWM_SYSTEMBACKDROP_TYPE> systemBackdropType = this.m_139864_("system-backdrop-type", value -> {
        try {
            return DwmApi.DWM_SYSTEMBACKDROP_TYPE.valueOf(value);
        }
        catch (IllegalArgumentException ignored) {
            return DwmApi.DWM_SYSTEMBACKDROP_TYPE.DWMSBT_AUTO;
        }
    }, (Object)DwmApi.DWM_SYSTEMBACKDROP_TYPE.DWMSBT_AUTO);
    public final Settings.MutableValue<DwmApi.DWM_WINDOW_CORNER_PREFERENCE> windowCorner = this.m_139864_("window-corner-preference", value -> {
        try {
            return DwmApi.DWM_WINDOW_CORNER_PREFERENCE.valueOf(value);
        }
        catch (IllegalArgumentException ignored) {
            return DwmApi.DWM_WINDOW_CORNER_PREFERENCE.DWMWCP_DEFAULT;
        }
    }, (Object)DwmApi.DWM_WINDOW_CORNER_PREFERENCE.DWMWCP_DEFAULT);
    public final Settings.MutableValue<Boolean> useDefaultBorder = this.m_139864_("use-default-border-color", Boolean::parseBoolean, true);
    public final Settings.MutableValue<Boolean> hideWindowBorder = this.m_139864_("hide-window-border", Boolean::parseBoolean, false);
    public final Settings.MutableValue<Integer> borderColor = this.m_139864_("border-color", value -> {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ignored) {
            return -1;
        }
    }, -1);
    public final Settings.MutableValue<Boolean> useDefaultCaption = this.m_139864_("use-default-caption-color", Boolean::parseBoolean, true);
    public final Settings.MutableValue<Integer> captionColor = this.m_139864_("caption-color", value -> {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ignored) {
            return -1;
        }
    }, -1);
    public final Settings.MutableValue<Boolean> useDefaultText = this.m_139864_("use-default-text-color", Boolean::parseBoolean, true);
    public final Settings.MutableValue<Integer> textColor = this.m_139864_("text-color", value -> {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ignored) {
            return -1;
        }
    }, -1);

    @NotNull
    public static ModConfig get() {
        if (instance == null) {
            instance = new ModConfig();
        }
        return instance;
    }

    private ModConfig() {
        this(Settings.m_139839_((Path)MOD_CONFIG));
    }

    private ModConfig(Properties properties) {
        super(properties);
    }

    @NotNull
    protected ModConfig reload(RegistryAccess registryAccess, Properties properties) {
        instance = new ModConfig(properties);
        instance.m_139876_(MOD_CONFIG);
        return ModConfig.get();
    }

    public <T> void setConfig(Settings.MutableValue<T> config, T value) {
        config.m_139895_(null, value);
        ModConfig.update();
    }

    public static void update() {
        Window window = Minecraft.m_91087_().m_91268_();
        DwmApi.updateDwm(window.m_85440_(), window.m_85439_());
    }
}

