/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.antique_atlas.reloader;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import folk.sisby.antique_atlas.AntiqueAtlas;
import folk.sisby.antique_atlas.MarkerTexture;
import folk.sisby.antique_atlas.util.CodecUtil;
import folk.sisby.surveyor.landmark.Landmark;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceMetadata;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class MarkerTextures
extends SimplePreparableReloadListener<Map<ResourceLocation, MarkerTextureMeta>>
implements IdentifiableResourceReloadListener {
    public static final MarkerTextures INSTANCE = new MarkerTextures();
    public static final ResourceLocation ID = AntiqueAtlas.id("marker_textures");
    protected final Map<ResourceLocation, MarkerTexture> textures = new HashMap<ResourceLocation, MarkerTexture>();

    public static MarkerTextures getInstance() {
        return INSTANCE;
    }

    public MarkerTexture get(ResourceLocation id) {
        return this.textures.get(id);
    }

    public MarkerTexture getOrDefault(ResourceLocation id) {
        return this.getOrDefault(id, MarkerTexture.DEFAULT);
    }

    public MarkerTexture getOrDefault(ResourceLocation id, MarkerTexture defaultTexture) {
        return this.textures.getOrDefault(id, defaultTexture);
    }

    public ResourceLocation minimumId(ResourceLocation id) {
        while (this.get(id) == null && id.m_135815_().contains("/")) {
            id = id.m_247449_(id.m_135815_().substring(0, id.m_135815_().lastIndexOf(47)));
        }
        return this.get(id) == null ? id.m_247449_("default") : id;
    }

    public MarkerTexture fromLandmark(Landmark landmark) {
        return this.getOrDefault(this.minimumId(landmark.id()));
    }

    public MarkerTexture fromLandmark(Landmark landmark, String variant) {
        ResourceLocation id = this.minimumId(landmark.id());
        return this.getOrDefault(id.m_247266_(p -> p + "/" + variant), this.getOrDefault(id));
    }

    public Map<ResourceLocation, MarkerTexture> asMap() {
        return new HashMap<ResourceLocation, MarkerTexture>(this.textures);
    }

    protected Map<ResourceLocation, MarkerTextureMeta> prepare(ResourceManager manager, ProfilerFiller profiler) {
        HashMap<ResourceLocation, MarkerTextureMeta> textureMeta = new HashMap<ResourceLocation, MarkerTextureMeta>();
        for (Map.Entry e : manager.m_214159_("textures/atlas/marker", id -> id.m_135815_().endsWith(".png")).entrySet()) {
            ResourceLocation id2 = ResourceLocation.m_214293_((String)((ResourceLocation)e.getKey()).m_135827_(), (String)((ResourceLocation)e.getKey()).m_135815_().substring("textures/atlas/marker/".length(), ((ResourceLocation)e.getKey()).m_135815_().length() - ".png".length()));
            try {
                ResourceMetadata metadata = ((Resource)e.getValue()).m_215509_();
                textureMeta.put(id2, metadata.m_214059_(MarkerTextureMeta.METADATA).orElse(MarkerTextureMeta.DEFAULT));
            }
            catch (IOException ex) {
                AntiqueAtlas.LOGGER.error("[Antique Atlas] Failed to access marker texture metadata for {}", e.getKey(), (Object)ex);
                textureMeta.put(id2, MarkerTextureMeta.DEFAULT);
            }
        }
        return textureMeta;
    }

    protected void apply(Map<ResourceLocation, MarkerTextureMeta> prepared, ResourceManager manager, ProfilerFiller profiler) {
        AntiqueAtlas.LOGGER.info("[Antique Atlas] Reloading Marker Textures...");
        this.textures.clear();
        prepared.forEach((id, meta) -> {
            if (id.m_135815_().endsWith("_accent")) {
                ResourceLocation mainId = id.m_247266_(s -> s.substring(0, s.length() - "_accent".length()));
                MarkerTextureMeta main = (MarkerTextureMeta)prepared.get(mainId);
                if (main != null) {
                    this.textures.put(mainId, main.build(mainId, true));
                } else {
                    AntiqueAtlas.LOGGER.error("[Antique Atlas] Marker accent {} has no main texture! Discarding.", id);
                }
            }
        });
        prepared.forEach((id, meta) -> {
            if (!this.textures.containsKey(id) && !id.m_135815_().endsWith("_accent")) {
                this.textures.put((ResourceLocation)id, meta.build((ResourceLocation)id, false));
            }
        });
    }

    public ResourceLocation getFabricId() {
        return ID;
    }

    public record MarkerTextureMeta(Optional<Integer> textureWidth, Optional<Integer> textureHeight, Optional<Integer> mipLevels, Optional<Integer> offsetX, Optional<Integer> offsetY, Optional<Integer> nearClip, Optional<Integer> farClip) {
        public static final MarkerTextureMeta DEFAULT = new MarkerTextureMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        public static final Codec<MarkerTextureMeta> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("textureWidth").forGetter(MarkerTextureMeta::textureWidth), (App)Codec.INT.optionalFieldOf("textureHeight").forGetter(MarkerTextureMeta::textureHeight), (App)Codec.INT.optionalFieldOf("mipLevels").forGetter(MarkerTextureMeta::mipLevels), (App)Codec.INT.optionalFieldOf("offsetX").forGetter(MarkerTextureMeta::offsetX), (App)Codec.INT.optionalFieldOf("offsetY").forGetter(MarkerTextureMeta::offsetY), (App)Codec.INT.optionalFieldOf("nearClip").forGetter(MarkerTextureMeta::nearClip), (App)Codec.INT.optionalFieldOf("farClip").forGetter(MarkerTextureMeta::farClip)).apply((Applicative)instance, MarkerTextureMeta::new));
        public static final MetadataSectionSerializer<MarkerTextureMeta> METADATA = new CodecUtil.CodecResourceMetadataSerializer<MarkerTextureMeta>(CODEC, AntiqueAtlas.id("marker"));

        public MarkerTexture build(ResourceLocation id, boolean accent) {
            int textureWidth = this.textureWidth.orElse(32);
            int textureHeight = this.textureHeight.orElse(32);
            int mipLevels = this.mipLevels.orElse(0);
            int offsetX = this.offsetX.orElse(-textureWidth / 2);
            int offsetY = this.offsetY.orElse(-textureHeight / 2);
            int nearClip = this.nearClip.orElse(1);
            int farClip = this.farClip.orElse(Integer.MAX_VALUE);
            return MarkerTexture.ofId(id, offsetX, offsetY, textureWidth, textureHeight, mipLevels, nearClip, farClip, accent);
        }
    }
}

