/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.antique_atlas.gui.core;

import folk.sisby.antique_atlas.AntiqueAtlas;
import folk.sisby.antique_atlas.gui.core.Component;
import folk.sisby.antique_atlas.gui.core.ViewportComponent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class ScrollBoxComponent
extends Component {
    public static final ResourceLocation ARROW = AntiqueAtlas.id("textures/gui/arrow.png");
    public static final int ARROW_SIZE = 16;
    public static final int ARROW_TEXTURE_WIDTH = 32;
    public static final int ARROW_TEXTURE_HEIGHT = 64;
    protected final int scrollStep;
    protected final boolean vertical;
    protected final ViewportComponent viewport;
    protected int scrollPos = 0;

    public ScrollBoxComponent(boolean vertical, int scrollStep) {
        this.vertical = vertical;
        this.scrollStep = scrollStep;
        this.viewport = new ViewportComponent();
        this.addChild(this.viewport);
    }

    public void renderArrow(GuiGraphics context, int mouseX, int mouseY, boolean prev) {
        int x;
        int n = !this.vertical ? (prev ? this.getGuiX() - 16 : this.getGuiX() + this.getWidth()) : (x = this.getGuiX() + (this.getWidth() - 16) / 2);
        int y = this.vertical ? (prev ? this.getGuiY() - 16 : this.getGuiY() + this.getHeight()) : this.getGuiY() + (this.getHeight() - 16) / 2;
        boolean hovered = new Rect2i(x, y, 16, 16).m_110087_(mouseX, mouseY);
        int u = prev ? 0 : 16;
        int v = (this.vertical ? 0 : 16) + (hovered ? 32 : 0);
        context.m_280163_(ARROW, x, y, (float)u, (float)v, 16, 16, 32, 64);
    }

    @Override
    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(context, mouseX, mouseY, partialTick);
        if (this.scrollPos > 0) {
            this.renderArrow(context, mouseX, mouseY, true);
        }
        if (this.scrollPos < this.getContentSize() - this.getViewportSize()) {
            this.renderArrow(context, mouseX, mouseY, false);
        }
    }

    public boolean clickArrow(double mouseX, double mouseY, boolean prev) {
        int x;
        int n = !this.vertical ? (prev ? this.getGuiX() - 16 : this.getGuiX() + this.getWidth()) : (x = this.getGuiX() + (this.getWidth() - 16) / 2);
        int y = this.vertical ? (prev ? this.getGuiY() - 16 : this.getGuiY() + this.getHeight()) : this.getGuiY() + (this.getHeight() - 16) / 2;
        boolean hovered = new Rect2i(x, y, 16, 16).m_110087_((int)mouseX, (int)mouseY);
        if (hovered) {
            int numSteps = (int)Math.round((double)this.getViewportSize() / (double)this.scrollStep);
            this.setScrollPos(this.scrollPos + numSteps * this.scrollStep * (prev ? -1 : 1));
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)((SoundEvent)SoundEvents.f_12490_.m_203334_()), (float)1.0f));
            return true;
        }
        return false;
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int mb) {
        if (this.scrollPos > 0 && this.clickArrow(mouseX, mouseY, true)) {
            return true;
        }
        if (this.scrollPos < this.getContentSize() - this.getViewportSize() && this.clickArrow(mouseX, mouseY, false)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, mb);
    }

    @Override
    public boolean m_6050_(double mx, double my, double wheelMove) {
        if (this.m_5953_(mx, my) && wheelMove != 0.0) {
            wheelMove = wheelMove > 0.0 ? -1.0 : 1.0;
            this.setScrollPos((int)((double)this.scrollPos + wheelMove * (double)this.scrollStep));
            return true;
        }
        return super.m_6050_(mx, my, wheelMove);
    }

    public void setScrollPos(int scrollPos) {
        this.viewport.content.updateSize();
        this.viewport.updateSize();
        this.doSetScrollPos(scrollPos);
    }

    protected void doSetScrollPos(int newPos) {
        this.scrollPos = Math.max(0, Math.min(newPos, this.getContentSize() - this.getViewportSize()));
        this.updateContentPos();
    }

    protected void updateContentPos() {
        this.viewport.content.setRelativeCoords(this.vertical ? this.viewport.content.getRelativeX() : -this.scrollPos, this.vertical ? -this.scrollPos : this.viewport.content.getRelativeY());
    }

    public int getContentSize() {
        return this.vertical ? this.viewport.contentHeight : this.viewport.contentWidth;
    }

    public int getViewportSize() {
        return this.vertical ? this.viewport.getHeight() : this.viewport.getWidth();
    }

    public ViewportComponent getViewport() {
        return this.viewport;
    }
}

