/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.antique_atlas.gui.core;

import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.FormattedText;

public class Component
extends Screen {
    public Component parent = null;
    public final List<Component> children = new CopyOnWriteArrayList<Component>();
    protected int properWidth;
    protected int properHeight;
    protected int contentWidth;
    protected int contentHeight;
    public boolean isClipped = false;
    public int guiX = 0;
    public int guiY = 0;

    public Component() {
        super((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.m_237113_((String)"component"));
    }

    public void setGuiCoords(int x, int y) {
        int dx = x - this.guiX;
        int dy = y - this.guiY;
        this.guiX = x;
        this.guiY = y;
        for (Component child : this.children) {
            child.offsetGuiCoords(dx, dy);
        }
        if (this.parent != null && (dx != 0 || dy != 0)) {
            this.parent.updateSize();
        }
    }

    public final void setRelativeCoords(int x, int y) {
        if (this.parent != null) {
            this.setGuiCoords(this.parent.getGuiX() + x, this.parent.getGuiY() + y);
        } else {
            this.setGuiCoords(x, y);
        }
    }

    public final void setRelativeX(int x) {
        if (this.parent != null) {
            this.setGuiCoords(this.parent.getGuiX() + x, this.guiY);
        } else {
            this.setGuiCoords(x, this.guiY);
        }
    }

    public final void setRelativeY(int y) {
        if (this.parent != null) {
            this.setGuiCoords(this.guiX, this.parent.getGuiY() + y);
        } else {
            this.setGuiCoords(this.guiX, y);
        }
    }

    public final void offsetGuiCoords(int dx, int dy) {
        this.setGuiCoords(this.guiX + dx, this.guiY + dy);
    }

    public int getGuiX() {
        return this.guiX;
    }

    public int getGuiY() {
        return this.guiY;
    }

    public int getRelativeX() {
        return this.parent == null ? this.guiX : this.guiX - this.parent.guiX;
    }

    public int getRelativeY() {
        return this.parent == null ? this.guiY : this.guiY - this.parent.guiY;
    }

    public void setSize(int width, int height) {
        this.properWidth = width;
        this.properHeight = height;
        this.contentWidth = width;
        this.contentHeight = height;
        this.updateSize();
    }

    public Component addChild(Component child) {
        this.doAddChild(null, child, null);
        return child;
    }

    public Component addChildBehind(Component behind, Component child) {
        this.doAddChild(null, child, behind);
        return child;
    }

    public void doAddChild(Component inFrontOf, Component child, Component behind) {
        if (child == null || this.children.contains((Object)child) || this.parent == child) {
            return;
        }
        int i = this.children.indexOf((Object)inFrontOf);
        if (i == -1) {
            int j = this.children.indexOf((Object)behind);
            if (j == -1) {
                this.children.add(child);
            } else {
                this.children.add(j, child);
            }
        } else {
            this.children.add(i + 1, child);
        }
        child.parent = this;
        child.setGuiCoords(this.guiX, this.guiY);
        if (Minecraft.m_91087_() != null) {
            child.m_6575_(Minecraft.m_91087_(), this.f_96543_, this.f_96544_);
        }
        this.updateSize();
    }

    public Component removeChild(Component child) {
        if (child != null && this.children.contains((Object)child)) {
            child.parent = null;
            this.children.remove((Object)child);
            this.updateSize();
            this.onChildClosed(child);
        }
        return child;
    }

    public void removeAllChildren() {
        this.children.clear();
        this.updateSize();
    }

    public Component getParent() {
        return this.parent;
    }

    public List<Component> getChildren() {
        return this.children;
    }

    public boolean iterateInput(Predicate<Component> callMethod) {
        ListIterator<Component> iter = this.children.listIterator(this.children.size());
        while (iter.hasPrevious()) {
            Component child = iter.previous();
            if (!callMethod.test(child)) continue;
            return true;
        }
        return false;
    }

    public boolean m_6375_(double mx, double my, int mb) {
        if (!this.iterateInput(c -> c.m_6375_(mx, my, mb))) {
            return super.m_6375_(mx, my, mb);
        }
        return true;
    }

    public boolean m_6348_(double mx, double my, int mb) {
        if (!this.iterateInput(c -> c.m_6348_(mx, my, mb))) {
            return super.m_6348_(mx, my, mb);
        }
        return true;
    }

    public boolean m_7979_(double mx, double my, int mb, double mx2, double my2) {
        if (!this.iterateInput(c -> c.m_7979_(mx, my, mb, mx2, my2))) {
            return super.m_6375_(mx, my, mb);
        }
        return true;
    }

    public boolean m_6050_(double mx, double my, double dy) {
        if (!this.iterateInput(c -> c.m_6050_(mx, my, dy))) {
            return super.m_6050_(mx, my, dy);
        }
        return true;
    }

    public void m_94757_(double mx, double my) {
        if (!this.iterateInput(c -> {
            c.m_94757_(mx, my);
            return false;
        })) {
            super.m_94757_(mx, my);
        }
    }

    public boolean m_7933_(int a, int b, int c) {
        if (!this.iterateInput(cpt -> cpt.m_7933_(a, b, c))) {
            return super.m_7933_(a, b, c);
        }
        return true;
    }

    public boolean m_5534_(char aa, int bb) {
        if (!this.iterateInput(cpt -> cpt.m_5534_(aa, bb))) {
            return super.m_5534_(aa, bb);
        }
        return true;
    }

    public boolean m_7920_(int a, int b, int c) {
        if (!this.iterateInput(cpt -> cpt.m_7920_(a, b, c))) {
            return super.m_7920_(a, b, c);
        }
        return true;
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(context, mouseX, mouseY, partialTick);
        for (Component child : this.children) {
            if (child.isClipped) continue;
            child.m_88315_(context, mouseX, mouseY, partialTick);
        }
    }

    public void m_7379_() {
        for (Component child : this.children) {
            child.m_7379_();
        }
        super.m_7379_();
    }

    public void m_86600_() {
        for (Component child : this.children) {
            child.m_86600_();
        }
        super.m_86600_();
    }

    public void m_7856_() {
        super.m_7856_();
        for (Component child : this.children) {
            child.m_6575_(Minecraft.m_91087_(), this.f_96543_, this.f_96544_);
        }
    }

    public int getWidth() {
        return this.contentWidth;
    }

    public int getHeight() {
        return this.contentHeight;
    }

    public void setClipped(boolean value) {
        this.isClipped = value;
    }

    public void updateSize() {
        int leftmost = Integer.MAX_VALUE;
        int rightmost = Integer.MIN_VALUE;
        int topmost = Integer.MAX_VALUE;
        int bottommost = Integer.MIN_VALUE;
        for (Component child : this.children) {
            int childHeight;
            int y;
            int childWidth;
            int x = child.getGuiX();
            if (x < leftmost) {
                leftmost = x;
            }
            if (x + (childWidth = child.getWidth()) > rightmost) {
                rightmost = x + childWidth;
            }
            if ((y = child.getGuiY()) < topmost) {
                topmost = y;
            }
            if (y + (childHeight = child.getHeight()) <= bottommost) continue;
            bottommost = y + childHeight;
        }
        this.contentWidth = Math.max(this.properWidth, rightmost - leftmost);
        this.contentHeight = Math.max(this.properHeight, bottommost - topmost);
        if (this.parent != null) {
            this.parent.updateSize();
        }
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return mouseX >= (double)this.getGuiX() && mouseX < (double)(this.getGuiX() + this.getWidth()) && mouseY >= (double)this.getGuiY() && mouseY < (double)(this.getGuiY() + this.getHeight());
    }

    public void closeChild() {
        if (this.parent != null) {
            this.parent.removeChild(this);
        } else {
            Minecraft.m_91087_().m_91152_(null);
        }
    }

    public void onChildClosed(Component child) {
    }

    public void drawCentered(GuiGraphics context, net.minecraft.network.chat.Component text, int y, int color, boolean dropShadow) {
        int length = this.f_96547_.m_92852_((FormattedText)text);
        context.m_280614_(this.f_96547_, text, (this.f_96543_ - length) / 2, y, color, dropShadow);
    }

    public double getMouseX() {
        return Minecraft.m_91087_().f_91067_.m_91589_() * (double)this.f_96543_ / (double)Minecraft.m_91087_().m_91268_().m_85443_();
    }

    public double getMouseY() {
        return Minecraft.m_91087_().f_91067_.m_91594_() * (double)this.f_96544_ / (double)Minecraft.m_91087_().m_91268_().m_85444_();
    }
}

