/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.connector.transformer;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.impl.MappingResolverImpl;
import org.sinytra.connector.transformer.jar.IntermediateMapping;
import reloc.net.fabricmc.accesswidener.AccessWidenerReader;
import reloc.net.fabricmc.accesswidener.AccessWidenerVisitor;
import reloc.net.minecraftforge.fart.api.Transformer;

public class AccessWidenerTransformer
implements Transformer {
    private final String resource;
    private final MappingResolverImpl resolver;
    private final IntermediateMapping fastMapping;

    public AccessWidenerTransformer(String resource, MappingResolverImpl namedMappingFile, IntermediateMapping fastMapping) {
        this.resource = resource;
        this.resolver = namedMappingFile;
        this.fastMapping = fastMapping;
    }

    @Override
    public Transformer.ResourceEntry process(Transformer.ResourceEntry entry) {
        if (entry.getName().equals(this.resource)) {
            String content = this.mapAccessWidener(entry.getData());
            return Transformer.ResourceEntry.create("META-INF/accesstransformer.cfg", entry.getTime(), content.getBytes(StandardCharsets.UTF_8));
        }
        return entry;
    }

    public String mapAccessWidener(byte[] content) {
        AccessWidenerReader.Header header = AccessWidenerReader.readHeader(content);
        String namespace = header.getNamespace();
        RemappingAccessWidenerVisitor visitor = new RemappingAccessWidenerVisitor(namespace);
        AccessWidenerReader reader = new AccessWidenerReader(visitor);
        reader.read(content);
        visitor.finish();
        return visitor.builder.toString();
    }

    public class RemappingAccessWidenerVisitor
    implements AccessWidenerVisitor {
        private final String sourceNamespace;
        private final StringBuilder builder = new StringBuilder();
        private final Map<String, AccessWidenerReader.AccessType> classAccess = new HashMap<String, AccessWidenerReader.AccessType>();
        private final Map<String, Map<String, AccessWidenerReader.AccessType>> classFields = new HashMap<String, Map<String, AccessWidenerReader.AccessType>>();

        public RemappingAccessWidenerVisitor(String sourceNamespace) {
            this.sourceNamespace = sourceNamespace;
            this.builder.append("# Access Transformer file converted by Connector\n");
        }

        public void finish() {
            this.classAccess.forEach((name, access) -> {
                String modifier = switch (access) {
                    case AccessWidenerReader.AccessType.ACCESSIBLE -> "public";
                    case AccessWidenerReader.AccessType.EXTENDABLE -> "public-f";
                    default -> throw new IllegalArgumentException("Invalid access type " + access + " for class");
                };
                String mappedName = AccessWidenerTransformer.this.resolver.mapClassName(this.sourceNamespace, (String)name).replace('/', '.');
                this.builder.append(modifier).append(" ").append(mappedName).append("\n");
            });
            this.classFields.forEach((owner, fields) -> fields.forEach((name, access) -> {
                String modifier = switch (access) {
                    case AccessWidenerReader.AccessType.ACCESSIBLE -> "public";
                    case AccessWidenerReader.AccessType.MUTABLE -> "public-f";
                    default -> throw new IllegalArgumentException("Invalid access type " + access + " for field");
                };
                String mappedOwner = AccessWidenerTransformer.this.resolver.mapClassName(this.sourceNamespace, (String)owner);
                String mappedName = AccessWidenerTransformer.this.resolver.mapFieldName(this.sourceNamespace, (String)owner, (String)name, "");
                this.builder.append(modifier).append(" ").append(mappedOwner.replace('/', '.')).append(" ").append(mappedName).append((String)(!name.equals(mappedName) ? " # " + mappedName : "")).append("\n");
            }));
        }

        @Override
        public void visitClass(String name, AccessWidenerReader.AccessType access, boolean transitive) {
            this.classAccess.compute(name, (value, existing) -> existing == null || access.ordinal() > existing.ordinal() ? access : existing);
        }

        @Override
        public void visitMethod(String owner, String name, String descriptor, AccessWidenerReader.AccessType access, boolean transitive) {
            String modifier = switch (access) {
                case AccessWidenerReader.AccessType.ACCESSIBLE -> "public";
                case AccessWidenerReader.AccessType.EXTENDABLE -> "protected-f";
                default -> throw new IllegalArgumentException("Invalid access type " + access + " for method");
            };
            String mappedOwner = AccessWidenerTransformer.this.resolver.mapClassName(this.sourceNamespace, owner);
            String mappedName = AccessWidenerTransformer.this.resolver.mapMethodName(this.sourceNamespace, owner, name, descriptor);
            if (name.equals(mappedName)) {
                mappedName = AccessWidenerTransformer.this.fastMapping.mapMethodOrDefault(name, descriptor);
            }
            String mappedDescriptor = AccessWidenerTransformer.this.resolver.mapDescriptor(this.sourceNamespace, descriptor);
            this.builder.append(modifier).append(" ").append(mappedOwner.replace('/', '.')).append(" ").append(mappedName).append(mappedDescriptor).append((String)(!name.equals(mappedName) ? " # " + mappedName : "")).append("\n");
            this.visitClass(owner, access, false);
        }

        @Override
        public void visitField(String owner, String name, String descriptor, AccessWidenerReader.AccessType access, boolean transitive) {
            this.classFields.computeIfAbsent(owner, n -> new HashMap()).compute(name, (value, existing) -> existing == null || access.ordinal() > existing.ordinal() ? access : existing);
            if (access != AccessWidenerReader.AccessType.MUTABLE) {
                this.visitClass(owner, access, false);
            }
        }
    }
}

