/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.transformer.dynamic;

import com.mojang.logging.LogUtils;
import java.util.List;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.patch.analysis.MethodCallAnalyzer;
import org.sinytra.adapter.patch.api.GlobalReferenceMapper;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.MethodTransform;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.api.PatchContext;
import org.sinytra.adapter.patch.fixes.BytecodeFixerUpper;
import org.sinytra.adapter.patch.selector.AnnotationHandle;
import org.sinytra.adapter.patch.selector.AnnotationValueHandle;
import org.sinytra.adapter.patch.util.MethodQualifier;
import org.slf4j.Logger;

public class DynamicInheritedInjectionPointPatch
implements MethodTransform {
    private static final Logger LOGGER = LogUtils.getLogger();

    @Override
    public Patch.Result apply(ClassNode classNode, MethodNode methodNode, MethodContext methodContext, PatchContext context) {
        AnnotationHandle atNode = methodContext.injectionPointAnnotation();
        if (atNode == null) {
            LOGGER.debug("Target @At annotation not found in method {}.{}{}", new Object[]{classNode.name, methodNode.name, methodNode.desc});
            return Patch.Result.PASS;
        }
        if (atNode.getValue("value").map(v -> !((String)v.get()).equals("INVOKE")).orElse(true).booleanValue()) {
            return Patch.Result.PASS;
        }
        AnnotationValueHandle target = atNode.getValue("target").orElse(null);
        if (target == null) {
            return Patch.Result.PASS;
        }
        MethodQualifier q = methodContext.getInjectionPointMethodQualifier();
        if (q == null) {
            return Patch.Result.PASS;
        }
        MethodContext.TargetPair targetPair = methodContext.findDirtyInjectionTarget();
        if (targetPair == null) {
            return Patch.Result.PASS;
        }
        List<AbstractInsnNode> insns = methodContext.findInjectionTargetInsns(targetPair);
        if (!insns.isEmpty()) {
            return Patch.Result.PASS;
        }
        String owner = q.internalOwnerName();
        for (AbstractInsnNode insn : targetPair.methodNode().instructions) {
            if (!(insn instanceof MethodInsnNode)) continue;
            MethodInsnNode minsn = (MethodInsnNode)insn;
            if (!minsn.name.equals(q.name()) || !minsn.desc.equals(q.desc()) || minsn.owner.equals(owner) || !context.environment().inheritanceHandler().isClassInherited(minsn.owner, owner) && !this.isFixedField((AbstractInsnNode)minsn, context)) continue;
            target.set(MethodCallAnalyzer.getCallQualifier(minsn));
            if (methodContext.methodAnnotation().matchesDesc("Lorg/spongepowered/asm/mixin/injection/Redirect;") && minsn.getOpcode() != 184) {
                methodNode.visitParameterAnnotation(0, "Lorg/spongepowered/asm/mixin/injection/Coerce;", false);
            }
            return Patch.Result.APPLY;
        }
        return Patch.Result.PASS;
    }

    private boolean isFixedField(AbstractInsnNode insn, PatchContext context) {
        for (AbstractInsnNode prev = insn.getPrevious(); prev != null && !(prev instanceof LabelNode); prev = prev.getPrevious()) {
            if (!(prev instanceof FieldInsnNode)) continue;
            FieldInsnNode finsn = (FieldInsnNode)prev;
            BytecodeFixerUpper bfu = context.environment().bytecodeFixerUpper();
            return bfu.getFieldTypeChange(finsn.owner, GlobalReferenceMapper.remapReference(finsn.name)) != null;
        }
        return false;
    }
}

