/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.golemdungeons.init.data.structure;

import dev.xkmc.golemdungeons.init.GolemDungeons;
import dev.xkmc.golemdungeons.init.data.loot.GDLootGen;
import dev.xkmc.golemdungeons.init.data.structure.ElementFactory;
import dev.xkmc.golemdungeons.init.data.structure.GDPieceData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosAlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.PosRuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProtectedBlockProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.AppendLoot;
import net.minecraft.world.level.levelgen.structure.templatesystem.rule.blockentity.RuleBlockEntityModifier;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import org.jetbrains.annotations.NotNull;

public class GDStructureGen
extends DatapackBuiltinEntriesProvider {
    public static final GDStructure ABANDONED_FACTORY;
    public static final GDStructure PIGLIN_FACTORY;
    public static final GDStructure SCULK_FACTORY;
    private static final List<GDStructure> STRUCTURES;
    private static final RegistrySetBuilder BUILDER;

    private static GDPieceData singlePiece(String str) {
        return new GDPieceData(str, List.of(str));
    }

    private static GDPieceData folder(String str, String ... items) {
        for (int i = 0; i < items.length; ++i) {
            items[i] = str + "/" + items[i];
        }
        return new GDPieceData(str, List.of(items));
    }

    public GDStructureGen(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, BUILDER, Set.of("minecraft", "golemdungeons"));
    }

    @NotNull
    public String m_6055_() {
        return "Golem Dungeons Data";
    }

    private static ProcessorRule injectData(Block block, ResourceLocation table) {
        return new ProcessorRule((RuleTest)new BlockMatchTest(block), (RuleTest)AlwaysTrueTest.f_73954_, (PosRuleTest)PosAlwaysTrueTest.f_74188_, block.m_49966_(), (RuleBlockEntityModifier)new AppendLoot(table));
    }

    static {
        STRUCTURES = new ArrayList<GDStructure>();
        SCULK_FACTORY = new GDStructure(GolemDungeons.loc("sculk_factory"), 32, 12, List.of(new ProtectedBlockProcessor(BlockTags.f_144287_)), List.of(GDStructureGen.singlePiece("root").custom(ElementFactory.thickBox(22)).loot(GDStructureGen.injectData(Blocks.f_50087_, GDLootGen.SCULK_ROOT)), GDStructureGen.singlePiece("heart").custom(ElementFactory.thickBox(22)).loot(GDStructureGen.injectData(Blocks.f_50618_, GDLootGen.SCULK_HEART_BARREL), GDStructureGen.injectData(Blocks.f_50087_, GDLootGen.SCULK_HEART_CHEST)), GDStructureGen.singlePiece("crane").custom(ElementFactory.fatBox(2)).loot(GDStructureGen.injectData(Blocks.f_50087_, GDLootGen.SCULK_CRANE)), GDStructureGen.singlePiece("crane_arm"), GDStructureGen.singlePiece("treasure").custom(ElementFactory.thickBox(22)), GDStructureGen.singlePiece("left_plaza").custom(ElementFactory.thickBox(22)), GDStructureGen.singlePiece("right_plaza").custom(ElementFactory.thickBox(22)), GDStructureGen.singlePiece("right_open").custom(ElementFactory.thickBox(22)), GDStructureGen.singlePiece("sculpture").custom(ElementFactory.thickBox(22)), GDStructureGen.singlePiece("pile").custom(ElementFactory.thickBox(22)), GDStructureGen.singlePiece("side_path").custom(ElementFactory.thickBox(22)), GDStructureGen.folder("pillar", "pillar_front_1", "pillar_front_2", "pillar_front_3", "pillar_back_1", "pillar_back_2").custom(ElementFactory.fatBox(2))), Map.of(), Optional.empty(), (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)-27)), GenerationStep.Decoration.UNDERGROUND_DECORATION, TerrainAdjustment.BEARD_BOX);
        PIGLIN_FACTORY = new GDStructure(GolemDungeons.loc("piglin_factory"), 32, 12, List.of(new ProtectedBlockProcessor(BlockTags.f_144287_)), List.of(GDStructureGen.singlePiece("piglin_factory").loot(GDStructureGen.injectData(Blocks.f_50087_, GDLootGen.PIGLIN_CHEST))), Map.of(), Optional.empty(), (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)33)), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_BOX);
        ABANDONED_FACTORY = new GDStructure(GolemDungeons.loc("abandoned_factory"), 64, 24, List.of(new ProtectedBlockProcessor(BlockTags.f_144287_)), List.of(GDStructureGen.singlePiece("top").custom(ElementFactory.thin()), GDStructureGen.singlePiece("garden").custom(ElementFactory.thin()), GDStructureGen.singlePiece("pillar").custom(ElementFactory.thin()), GDStructureGen.singlePiece("elevator").custom(ElementFactory.bury()), GDStructureGen.singlePiece("elevator_base").custom(ElementFactory.bury()), GDStructureGen.singlePiece("room").loot(GDStructureGen.injectData(Blocks.f_50087_, GDLootGen.FACTORY_ROOM_CHEST), GDStructureGen.injectData(Blocks.f_50618_, GDLootGen.FACTORY_ROOM_BARREL), GDStructureGen.injectData(Blocks.f_276445_, GDLootGen.FACTORY_ROOM_GRAVEL)).custom(ElementFactory.bury()), GDStructureGen.singlePiece("stair").custom(ElementFactory.bury()), GDStructureGen.singlePiece("cross").custom(ElementFactory.bury()), GDStructureGen.singlePiece("hall").custom(ElementFactory.bury()), GDStructureGen.singlePiece("tway").custom(ElementFactory.bury()), GDStructureGen.folder("end", "end0", "end1", "end2", "end3", "end4").loot(GDStructureGen.injectData(Blocks.f_50087_, GDLootGen.FACTORY_END_CHEST), GDStructureGen.injectData(Blocks.f_276445_, GDLootGen.FACTORY_END_GRAVEL)).custom(ElementFactory.bury())), Map.of(), Optional.of(Heightmap.Types.WORLD_SURFACE_WG), (HeightProvider)ConstantHeight.m_161956_((VerticalAnchor)VerticalAnchor.m_158922_((int)0)), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_THIN);
        STRUCTURES.add(SCULK_FACTORY);
        STRUCTURES.add(PIGLIN_FACTORY);
        STRUCTURES.add(ABANDONED_FACTORY);
        BUILDER = new RegistrySetBuilder().m_254916_(Registries.f_257011_, ctx -> {
            for (GDStructure e : STRUCTURES) {
                ctx.m_255272_(ResourceKey.m_135785_((ResourceKey)Registries.f_257011_, (ResourceLocation)e.id), (Object)new StructureProcessorList(e.processors()));
                for (GDPieceData pool : e.pools) {
                    pool.buildProcessors((BootstapContext<StructureProcessorList>)ctx, e.id, e.processors());
                }
            }
        }).m_254916_(Registries.f_256948_, ctx -> {
            Holder.Reference empty = ctx.m_255420_(Registries.f_256948_).m_255043_(ResourceKey.m_135785_((ResourceKey)Registries.f_256948_, (ResourceLocation)new ResourceLocation("empty")));
            for (GDStructure e : STRUCTURES) {
                Holder.Reference base = ctx.m_255420_(Registries.f_257011_).m_255043_(ResourceKey.m_135785_((ResourceKey)Registries.f_257011_, (ResourceLocation)e.id()));
                for (GDPieceData pool : e.pools) {
                    pool.buildTemplate((BootstapContext<StructureTemplatePool>)ctx, e.id(), (Holder.Reference<StructureProcessorList>)base, (Holder.Reference<StructureTemplatePool>)empty);
                }
            }
        }).m_254916_(Registries.f_256944_, ctx -> {
            for (GDStructure e : STRUCTURES) {
                HolderSet.Named biome = ctx.m_255420_(Registries.f_256952_).m_254956_(e.biomes());
                ResourceLocation start = e.id().m_266382_("/" + e.pools.get(0).id());
                Holder.Reference pool = ctx.m_255420_(Registries.f_256948_).m_255043_(ResourceKey.m_135785_((ResourceKey)Registries.f_256948_, (ResourceLocation)start));
                ctx.m_255272_(ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)e.id()), (Object)new JigsawStructure(new Structure.StructureSettings((HolderSet)biome, e.spawns(), e.step(), e.beard()), (Holder)pool, Optional.empty(), 7, e.height(), false, e.heightMap(), 80));
            }
        }).m_254916_(Registries.f_256998_, ctx -> {
            for (GDStructure e : STRUCTURES) {
                Holder.Reference str = ctx.m_255420_(Registries.f_256944_).m_255043_(ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)e.id));
                ctx.m_255272_(ResourceKey.m_135785_((ResourceKey)Registries.f_256998_, (ResourceLocation)e.id), (Object)new StructureSet((Holder)str, (StructurePlacement)new RandomSpreadStructurePlacement(e.spacing(), e.separation(), RandomSpreadType.LINEAR, e.id.hashCode() & Integer.MAX_VALUE)));
            }
        });
    }

    public record GDStructure(ResourceLocation id, int spacing, int separation, List<StructureProcessor> processors, List<GDPieceData> pools, Map<MobCategory, StructureSpawnOverride> spawns, Optional<Heightmap.Types> heightMap, HeightProvider height, GenerationStep.Decoration step, TerrainAdjustment beard) {
        public TagKey<Biome> biomes() {
            return TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)this.id.m_246208_("has_structure/"));
        }

        public TagKey<Structure> asTag() {
            return TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)this.id);
        }

        public ResourceKey<Structure> asKey() {
            return ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)this.id);
        }
    }
}

