/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.golemdungeons.init.data.structure;

import com.mojang.datafixers.util.Pair;
import dev.xkmc.golemdungeons.content.structure.GDRuleProcessor;
import dev.xkmc.golemdungeons.init.data.structure.ElementFactory;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class GDPieceData {
    private final String id;
    private final List<String> pool;
    private final List<StructureProcessor> processors = new ArrayList<StructureProcessor>();
    private ElementFactory factory;

    public GDPieceData(String id, List<String> pool) {
        this.id = id;
        this.pool = pool;
        this.factory = ElementFactory.rigid();
    }

    public GDPieceData with(StructureProcessor ... processors) {
        this.processors.addAll(List.of(processors));
        return this;
    }

    public GDPieceData loot(ProcessorRule ... processors) {
        this.processors.add(new GDRuleProcessor(List.of(processors)));
        return this;
    }

    public GDPieceData custom(ElementFactory factory) {
        this.factory = factory;
        return this;
    }

    public String id() {
        return this.id;
    }

    public List<String> pool() {
        return this.pool;
    }

    public List<StructureProcessor> processors() {
        return this.processors;
    }

    public ElementFactory factory() {
        return this.factory;
    }

    public void buildProcessors(BootstapContext<StructureProcessorList> ctx, ResourceLocation sid, List<StructureProcessor> def) {
        ResourceLocation poolId = sid.m_266382_("/" + this.id());
        if (!this.processors().isEmpty()) {
            ArrayList<StructureProcessor> merged = new ArrayList<StructureProcessor>(def);
            merged.addAll(this.processors());
            ctx.m_255272_(ResourceKey.m_135785_((ResourceKey)Registries.f_257011_, (ResourceLocation)poolId), (Object)new StructureProcessorList(merged));
        }
    }

    public void buildTemplate(BootstapContext<StructureTemplatePool> ctx, ResourceLocation sid, Holder.Reference<StructureProcessorList> base, Holder.Reference<StructureTemplatePool> empty) {
        ResourceLocation poolId = sid.m_266382_("/" + this.id());
        Holder.Reference processors = this.processors().isEmpty() ? base : ctx.m_255420_(Registries.f_257011_).m_255043_(ResourceKey.m_135785_((ResourceKey)Registries.f_257011_, (ResourceLocation)poolId));
        ArrayList<Pair> pieces = new ArrayList<Pair>();
        for (String elem : this.pool()) {
            pieces.add(Pair.of((Object)this.factory().create(sid.m_266382_("/" + elem), (Holder<StructureProcessorList>)processors), (Object)1));
        }
        ctx.m_255272_(ResourceKey.m_135785_((ResourceKey)Registries.f_256948_, (ResourceLocation)poolId), (Object)new StructureTemplatePool(empty, pieces));
    }
}

