/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.golemdungeons.init.data;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class GDConfig {
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    public static void init() {
        GDConfig.register(ModConfig.Type.CLIENT, CLIENT_SPEC);
        GDConfig.register(ModConfig.Type.COMMON, COMMON_SPEC);
    }

    private static void register(ModConfig.Type type, IConfigSpec<?> spec) {
        ModContainer mod = ModLoadingContext.get().getActiveContainer();
        String path = "l2_configs/" + mod.getModId() + "-" + type.extension() + ".toml";
        ModLoadingContext.get().registerConfig(type, spec, path);
    }

    static {
        Pair client = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)client.getRight();
        CLIENT = (Client)client.getLeft();
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Client {
        Client(ForgeConfigSpec.Builder builder) {
        }
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue enableRaidGolems;
        public final ForgeConfigSpec.DoubleValue flameSwordDamage;
        public final ForgeConfigSpec.DoubleValue flameSwordLoot;
        public final ForgeConfigSpec.DoubleValue sculkScytheDamage;
        public final ForgeConfigSpec.DoubleValue fierySwordDamage;

        Common(ForgeConfigSpec.Builder builder) {
            this.enableRaidGolems = builder.comment("Enable adding hostile golems to raids").define("enableRaidGolems", true);
            this.flameSwordDamage = builder.comment("Flame sword extra damage as percentage original attack").defineInRange("flameSwordDamage", 0.25, 0.0, 10.0);
            this.flameSwordLoot = builder.comment("Flame sword material loot as percentage of crafting cost").defineInRange("flameSwordLoot", 0.33, 0.0, 1.0);
            this.sculkScytheDamage = builder.comment("Sculk Scythe extra damage as percentage original attack").defineInRange("sculkScytheDamage", 0.25, 0.0, 10.0);
            this.fierySwordDamage = builder.comment("Giant Fiery sword extra damage as percentage original attack").defineInRange("fierySwordDamage", 1.0, 0.0, 10.0);
        }
    }
}

