/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.golemdungeons.init;

import com.tterrag.registrate.providers.ProviderType;
import dev.xkmc.golemdungeons.compat.cataclysm.CataclysmEventHandler;
import dev.xkmc.golemdungeons.compat.cataclysm.CataclysmFactions;
import dev.xkmc.golemdungeons.compat.cataclysm.CataclysmModEventHandler;
import dev.xkmc.golemdungeons.compat.twilightforest.TwilightFactions;
import dev.xkmc.golemdungeons.content.config.EquipmentConfig;
import dev.xkmc.golemdungeons.content.config.SpawnConfig;
import dev.xkmc.golemdungeons.content.config.TrialConfig;
import dev.xkmc.golemdungeons.content.faction.DungeonFactionRegistry;
import dev.xkmc.golemdungeons.content.item.SummonWandSelector;
import dev.xkmc.golemdungeons.events.GDAttackListener;
import dev.xkmc.golemdungeons.init.data.GDConfig;
import dev.xkmc.golemdungeons.init.data.GDConfigGen;
import dev.xkmc.golemdungeons.init.data.GDDamageTypes;
import dev.xkmc.golemdungeons.init.data.GDGLMGen;
import dev.xkmc.golemdungeons.init.data.GDLang;
import dev.xkmc.golemdungeons.init.data.GDRecipeGen;
import dev.xkmc.golemdungeons.init.data.GDTagGen;
import dev.xkmc.golemdungeons.init.data.advancement.GDAdvGen;
import dev.xkmc.golemdungeons.init.data.advancement.GDTriggers;
import dev.xkmc.golemdungeons.init.data.loot.GDLootGen;
import dev.xkmc.golemdungeons.init.data.structure.GDBiomeTagsProvider;
import dev.xkmc.golemdungeons.init.data.structure.GDStructureGen;
import dev.xkmc.golemdungeons.init.data.structure.GDStructureTagsProvider;
import dev.xkmc.golemdungeons.init.reg.GDItems;
import dev.xkmc.golemdungeons.init.reg.GDModifiers;
import dev.xkmc.golemdungeons.init.reg.GDWorldGen;
import dev.xkmc.l2damagetracker.contents.attack.AttackEventHandler;
import dev.xkmc.l2damagetracker.contents.attack.AttackListener;
import dev.xkmc.l2itemselector.select.item.IItemSelector;
import dev.xkmc.l2library.base.L2Registrate;
import dev.xkmc.l2library.serial.config.ConfigTypeEntry;
import dev.xkmc.l2library.serial.config.PacketHandlerWithConfig;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.entity.EntityAttributeModificationEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="golemdungeons")
@Mod.EventBusSubscriber(modid="golemdungeons", bus=Mod.EventBusSubscriber.Bus.MOD)
public class GolemDungeons {
    public static final String MODID = "golemdungeons";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final L2Registrate REGISTRATE = new L2Registrate("golemdungeons");
    public static final IEventBus MOD_BUS = FMLJavaModLoadingContext.get().getModEventBus();
    public static final PacketHandlerWithConfig HANDLER = new PacketHandlerWithConfig(new ResourceLocation("golemdungeons", "main"), 1, new Function[0]);
    public static final ConfigTypeEntry<SpawnConfig> SPAWN = new ConfigTypeEntry(HANDLER, "spawn", SpawnConfig.class);
    public static final ConfigTypeEntry<EquipmentConfig> ITEMS = new ConfigTypeEntry(HANDLER, "equipment", EquipmentConfig.class);
    public static final ConfigTypeEntry<TrialConfig> TRIAL = new ConfigTypeEntry(HANDLER, "trial", TrialConfig.class);

    public GolemDungeons() {
        GDItems.register();
        GDModifiers.register();
        GDWorldGen.register();
        GDTriggers.register();
        GDConfig.init();
        AttackEventHandler.register((int)3513, (AttackListener)new GDAttackListener());
        if (ModList.get().isLoaded("cataclysm")) {
            MinecraftForge.EVENT_BUS.register(CataclysmEventHandler.class);
            FMLJavaModLoadingContext.get().getModEventBus().register(CataclysmModEventHandler.class);
        }
    }

    @SubscribeEvent
    public static void modifyAttributes(EntityAttributeModificationEvent event) {
    }

    @SubscribeEvent
    public static void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            DungeonFactionRegistry.register();
            IItemSelector.register((IItemSelector)new SummonWandSelector(MODID));
            if (ModList.get().isLoaded("cataclysm")) {
                CataclysmFactions.register();
                IItemSelector.register((IItemSelector)new SummonWandSelector("cataclysm"));
            }
            if (ModList.get().isLoaded("twilightforest")) {
                TwilightFactions.register();
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void gatherData(GatherDataEvent event) {
        REGISTRATE.addDataGenerator(ProviderType.LANG, GDLang::genLang);
        REGISTRATE.addDataGenerator(ProviderType.LOOT, GDLootGen::genLoot);
        REGISTRATE.addDataGenerator(ProviderType.RECIPE, GDRecipeGen::genRecipe);
        REGISTRATE.addDataGenerator(ProviderType.ADVANCEMENT, GDAdvGen::genAdv);
        REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, GDTagGen::genItemTag);
        DataGenerator gen = event.getGenerator();
        PackOutput output = gen.getPackOutput();
        CompletableFuture pvd = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        boolean server = event.includeServer();
        GDStructureGen reg = new GDStructureGen(output, pvd);
        gen.addProvider(server, (DataProvider)new GDConfigGen(gen));
        gen.addProvider(server, (DataProvider)reg);
        gen.addProvider(server, (DataProvider)new GDBiomeTagsProvider(output, pvd, helper));
        gen.addProvider(server, (DataProvider)new GDGLMGen(output));
        gen.addProvider(server, (DataProvider)new GDStructureTagsProvider(output, reg.getRegistryProvider(), helper));
        new GDDamageTypes(output, pvd, helper).generate(server, gen);
    }

    public static ResourceLocation loc(String id) {
        return new ResourceLocation(MODID, id);
    }
}

