/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.golemdungeons.content.config;

import dev.xkmc.l2library.serial.config.BaseConfig;
import dev.xkmc.l2library.serial.config.CollectType;
import dev.xkmc.l2library.serial.config.ConfigCollect;
import dev.xkmc.l2serial.serialization.SerialClass;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

@SerialClass
public class TrialConfig
extends BaseConfig {
    @ConfigCollect(value=CollectType.COLLECT)
    @SerialClass.SerialField
    public final List<ArrayList<WaveEntry>> list = new ArrayList<ArrayList<WaveEntry>>();
    @SerialClass.SerialField
    public int spawnCost = 1000;
    @SerialClass.SerialField
    public int triggerRange = 12;
    @SerialClass.SerialField
    public int minY = -4;
    @SerialClass.SerialField
    public int maxY = 6;
    @SerialClass.SerialField
    public boolean generateChest = false;
    @SerialClass.SerialField
    @Nullable
    public ResourceLocation reward;

    public TrialConfig add(WaveEntry ... entries) {
        this.list.add(new ArrayList<WaveEntry>(List.of(entries)));
        return this;
    }

    public TrialConfig setCost(int cost) {
        this.spawnCost = cost;
        return this;
    }

    public TrialConfig genChest() {
        this.generateChest = true;
        return this;
    }

    public TrialConfig setTriggerRange(int range, int minY, int maxY) {
        this.triggerRange = range;
        this.minY = minY;
        this.maxY = maxY;
        return this;
    }

    public TrialConfig setReward(ResourceLocation loot) {
        this.reward = loot;
        return this;
    }

    public boolean isInRange(Player pl, BlockPos pos) {
        Vec3 diff = pl.m_20182_().m_82546_(Vec3.m_82512_((Vec3i)pos));
        if (Math.abs(diff.m_7096_()) > (double)this.triggerRange) {
            return false;
        }
        if (Math.abs(diff.m_7094_()) > (double)this.triggerRange) {
            return false;
        }
        return diff.f_82480_ > (double)this.minY && diff.f_82480_ < (double)this.maxY;
    }

    public record WaveEntry(ResourceLocation target, int num) {
    }
}

