/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.antique_atlas.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import folk.sisby.antique_atlas.AntiqueAtlas;
import folk.sisby.antique_atlas.WorldAtlasData;
import folk.sisby.antique_atlas.gui.AtlasScreen;
import folk.sisby.antique_atlas.gui.tiles.TileRenderIterator;
import folk.sisby.antique_atlas.util.DrawBatcher;
import folk.sisby.antique_atlas.util.DrawUtil;
import folk.sisby.antique_atlas.util.MathUtil;
import folk.sisby.antique_atlas.util.Rect;
import folk.sisby.surveyor.PlayerSummary;
import folk.sisby.surveyor.client.SurveyorClient;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.joml.Vector2d;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemInHandRenderer.class})
public class MixinHeldItemRenderer {
    @Inject(method={"renderFirstPersonMap"}, at={@At(value="HEAD")}, cancellable=true)
    void renderFirstPersonAtlas(PoseStack matrices, MultiBufferSource vertexConsumers, int light, ItemStack stack, CallbackInfo ci) {
        if (Minecraft.m_91087_().f_91074_ == null || Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        if (!AntiqueAtlas.isHandheldAtlas(stack)) {
            return;
        }
        matrices.m_85836_();
        matrices.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        matrices.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        float scale = 0.24752294f;
        matrices.m_85841_(scale, scale, 0.38f);
        matrices.m_85837_(-1.2, -0.88, 0.0);
        matrices.m_85841_(0.0078125f, 0.0078125f, 0.0078125f);
        int bookX = 0;
        int bookY = 0;
        int bookWidth = 310;
        int bookHeight = 218;
        int mapWidth = bookWidth - 34;
        int mapHeight = bookHeight - 22;
        int tileChunks = 1;
        try (DrawBatcher batcher = new DrawBatcher(matrices, vertexConsumers, AtlasScreen.BOOK, bookWidth, bookHeight, light);){
            batcher.add(bookX, bookY, 0.01f, bookWidth, bookHeight, 0, 0, bookWidth, bookHeight, -1);
        }
        if (Minecraft.m_91087_().f_91080_ instanceof AtlasScreen) {
            matrices.m_85849_();
            ci.cancel();
            return;
        }
        int mapOffsetX = -Minecraft.m_91087_().f_91074_.m_146903_();
        int mapOffsetY = -Minecraft.m_91087_().f_91074_.m_146907_();
        int mapStartChunkX = MathUtil.roundToBase((double)AtlasScreen.screenXToWorldX(bookX + 17, bookX, mapOffsetX, mapWidth, 1.0) / 16.0, (double)tileChunks) - 2 * tileChunks;
        int mapStartChunkZ = MathUtil.roundToBase((double)AtlasScreen.screenYToWorldZ(bookY + 11, bookY, mapOffsetY, mapHeight, 1.0) / 16.0, (double)tileChunks) - 2 * tileChunks;
        int mapEndChunkX = MathUtil.roundToBase((double)AtlasScreen.screenXToWorldX(bookX + 17 + mapWidth, bookX, mapOffsetX, mapWidth, 1.0) / 16.0, (double)tileChunks) + 2 * tileChunks;
        int mapEndChunkZ = MathUtil.roundToBase((double)AtlasScreen.screenYToWorldZ(bookY + 11 + mapHeight, bookY, mapOffsetY, mapHeight, 1.0) / 16.0, (double)tileChunks) + 2 * tileChunks;
        double mapStartScreenX = AtlasScreen.worldXToScreenX(mapStartChunkX << 4, bookX, mapOffsetX, mapWidth, 1.0);
        double mapStartScreenY = AtlasScreen.worldZToScreenY(mapStartChunkZ << 4, bookY, mapOffsetY, mapHeight, 1.0);
        WorldAtlasData worldAtlasData = WorldAtlasData.getOrCreate((Level)Minecraft.m_91087_().f_91073_);
        TileRenderIterator tiles = new TileRenderIterator(worldAtlasData);
        tiles.setScope(new Rect(mapStartChunkX, mapStartChunkZ, mapEndChunkX, mapEndChunkZ));
        tiles.setStep(tileChunks);
        AtlasScreen.renderTiles(matrices, vertexConsumers, bookX + 17, bookY + 11, 0, mapWidth, mapHeight, mapStartScreenX, mapStartScreenY, 1.0, 16, 1.0, light, tiles);
        Rect2i mapArea = new Rect2i(bookX + 17, bookY + 11, mapWidth, mapHeight);
        worldAtlasData.getAllMarkers(tileChunks).forEach((landmark, texture) -> {
            double markerX = AtlasScreen.worldXToScreenX(landmark.pos().m_123341_(), bookX, mapOffsetX, mapWidth, 1.0) - (double)bookX;
            double markerY = AtlasScreen.worldZToScreenY(landmark.pos().m_123343_(), bookY, mapOffsetY, mapHeight, 1.0) - (double)bookY;
            DyeColor color = landmark.color();
            Vector2d markerPoint = new Vector2d(markerX, markerY);
            float alpha = (float)Mth.m_14008_((double)(MathUtil.innerDistanceToEdge(mapArea, markerPoint) / 32.0), (double)0.0, (double)1.0);
            texture.draw(matrices, vertexConsumers, markerX, markerY, -0.02f, 1.0f, tileChunks, color == null ? null : color.m_41068_(), 1.0f, alpha, light);
        });
        Map friends = SurveyorClient.getFriends();
        PlayerSummary playerSummary = (PlayerSummary)friends.remove(SurveyorClient.getClientUuid());
        LinkedHashMap<UUID, PlayerSummary> orderedFriends = new LinkedHashMap<UUID, PlayerSummary>(friends);
        if (playerSummary != null) {
            orderedFriends.put(SurveyorClient.getClientUuid(), playerSummary);
        }
        orderedFriends.forEach((uuid, friend) -> {
            float tint = friend.online() ? 1.0f : 0.5f;
            float greenTint = friend == playerSummary ? 1.0f : 0.7f;
            int argb = FastColor.ARGB32.m_13660_((int)255, (int)((int)(tint * 255.0f)), (int)((int)(tint * greenTint * 255.0f)), (int)((int)(tint * 255.0f)));
            double playerOffsetX = AtlasScreen.worldXToScreenX(Minecraft.m_91087_().f_91074_.m_20182_().m_7096_(), bookX, mapOffsetX, mapWidth, 1.0) - (double)bookX;
            double playerOffsetY = AtlasScreen.worldZToScreenY(Minecraft.m_91087_().f_91074_.m_20182_().m_7094_(), bookY, mapOffsetY, mapHeight, 1.0) - (double)bookY;
            float playerRotation = (float)Math.round(Minecraft.m_91087_().f_91074_.m_6080_() / 360.0f * 16.0f) / 16.0f * 360.0f;
            DrawUtil.drawCenteredWithRotation(matrices, vertexConsumers, AtlasScreen.PLAYER, playerOffsetX, playerOffsetY, -0.04f, 1.0f, 7, 8, playerRotation, light, argb);
        });
        try (DrawBatcher batcher = new DrawBatcher(matrices, vertexConsumers, AtlasScreen.BOOK_FRAME, bookWidth, bookHeight, light);){
            batcher.add(bookX, bookY, -0.03f, bookWidth, bookHeight, 0, 0, bookWidth, bookHeight, -1);
        }
        matrices.m_85849_();
        ci.cancel();
    }

    @ModifyExpressionValue(method={"renderFirstPersonItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;isOf(Lnet/minecraft/item/Item;)Z", ordinal=0)})
    private boolean enableFirstPersonAtlasRendering(boolean original, AbstractClientPlayer player, float tickDelta, float pitch, InteractionHand hand, float swingProgress, ItemStack stack, float equipProgress, PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        return original || AntiqueAtlas.isHandheldAtlas(stack);
    }
}

