/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.antique_atlas.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import folk.sisby.antique_atlas.AntiqueAtlas;
import folk.sisby.antique_atlas.AntiqueAtlasKeybindings;
import folk.sisby.antique_atlas.AtlasStructureLandmark;
import folk.sisby.antique_atlas.MarkerTexture;
import folk.sisby.antique_atlas.TileTexture;
import folk.sisby.antique_atlas.WorldAtlasData;
import folk.sisby.antique_atlas.gui.BlinkingMarkerComponent;
import folk.sisby.antique_atlas.gui.BookmarkButton;
import folk.sisby.antique_atlas.gui.MarkerBookmarkButton;
import folk.sisby.antique_atlas.gui.MarkerModal;
import folk.sisby.antique_atlas.gui.TextBookmarkButton;
import folk.sisby.antique_atlas.gui.core.ButtonComponent;
import folk.sisby.antique_atlas.gui.core.Component;
import folk.sisby.antique_atlas.gui.core.CursorComponent;
import folk.sisby.antique_atlas.gui.core.ScreenState;
import folk.sisby.antique_atlas.gui.core.ScrollBoxComponent;
import folk.sisby.antique_atlas.gui.tiles.SubTile;
import folk.sisby.antique_atlas.gui.tiles.SubTileQuartet;
import folk.sisby.antique_atlas.gui.tiles.TileRenderIterator;
import folk.sisby.antique_atlas.util.DrawBatcher;
import folk.sisby.antique_atlas.util.DrawUtil;
import folk.sisby.antique_atlas.util.MathUtil;
import folk.sisby.antique_atlas.util.Rect;
import folk.sisby.surveyor.PlayerSummary;
import folk.sisby.surveyor.client.SurveyorClient;
import folk.sisby.surveyor.landmark.Landmark;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.joml.Vector2d;

public class AtlasScreen
extends Component {
    public static final ResourceLocation BOOK = AntiqueAtlas.id("textures/gui/book.png");
    public static final ResourceLocation BOOK_FULLSCREEN = AntiqueAtlas.id("textures/gui/book_fullscreen.png");
    public static final ResourceLocation BOOK_FULLSCREEN_R = AntiqueAtlas.id("textures/gui/book_fullscreen_r.png");
    public static final ResourceLocation BOOK_FRAME = AntiqueAtlas.id("textures/gui/book_frame.png");
    public static final ResourceLocation BOOK_FRAME_FULLSCREEN = AntiqueAtlas.id("textures/gui/book_frame_fullscreen.png");
    public static final ResourceLocation BOOK_FRAME_FULLSCREEN_R = AntiqueAtlas.id("textures/gui/book_frame_fullscreen_r.png");
    public static final ResourceLocation BOOK_FRAME_NARROW = AntiqueAtlas.id("textures/gui/book_frame_narrow.png");
    public static final ResourceLocation BOOK_FRAME_NARROW_FULLSCREEN = AntiqueAtlas.id("textures/gui/book_frame_narrow_fullscreen.png");
    public static final ResourceLocation BOOK_FRAME_NARROW_FULLSCREEN_R = AntiqueAtlas.id("textures/gui/book_frame_narrow_fullscreen_r.png");
    public static final ResourceLocation PLAYER = AntiqueAtlas.id("textures/gui/player.png");
    public static final ResourceLocation ERASER = AntiqueAtlas.id("textures/gui/eraser.png");
    public static final ResourceLocation ICON_ADD_MARKER = AntiqueAtlas.id("textures/gui/icons/add_marker.png");
    public static final ResourceLocation ICON_DELETE_MARKER = AntiqueAtlas.id("textures/gui/icons/del_marker.png");
    public static final ResourceLocation ICON_SHOW_MARKERS = AntiqueAtlas.id("textures/gui/icons/show_markers.png");
    public static final ResourceLocation ICON_HIDE_MARKERS = AntiqueAtlas.id("textures/gui/icons/hide_markers.png");
    private static final net.minecraft.network.chat.Component TEXT_ADD_MARKER = net.minecraft.network.chat.Component.m_237115_((String)"gui.antique_atlas.addMarker");
    private static final net.minecraft.network.chat.Component TEXT_ADD_MARKER_HERE = net.minecraft.network.chat.Component.m_237115_((String)"gui.antique_atlas.addMarkerHere");
    public static final int MAP_BORDER_WIDTH = 17;
    public static final int MAP_BORDER_HEIGHT = 11;
    public static final float PLAYER_ROTATION_STEPS = 16.0f;
    public static final int PLAYER_ICON_WIDTH = 7;
    public static final int PLAYER_ICON_HEIGHT = 8;
    private static final int BOOKMARK_SPACING = 2;
    public static final int MARKER_SIZE = 32;
    private static final int NAVIGATE_STEP = 24;
    public static final ScreenState.State<AtlasScreen> NORMAL = new ScreenState.ToggleState<AtlasScreen>();
    public static final ScreenState.State<AtlasScreen> PLACING_MARKER = new ScreenState.ToggleState<AtlasScreen>(s -> s.addMarkerBookmark);
    public static final ScreenState.State<AtlasScreen> DELETING_MARKER = new ScreenState.ToggleState<AtlasScreen>(s -> s.deleteMarkerBookmark, s -> s.addChild(s.eraser), s -> s.removeChild(s.eraser));
    public static final ScreenState.State<AtlasScreen> HIDING_MARKERS = new ScreenState.ToggleState<AtlasScreen>(s -> s.markerVisibilityBookmark, s -> {
        s.markerVisibilityBookmark.setTitle((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.m_237115_((String)"gui.antique_atlas.showMarkers"));
        s.markerVisibilityBookmark.setIconTexture(ICON_SHOW_MARKERS);
    }, s -> {
        s.clearTargetBookmarks(s.playerBookmark);
        s.markerVisibilityBookmark.setTitle((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.m_237115_((String)"gui.antique_atlas.hideMarkers"));
        s.markerVisibilityBookmark.setIconTexture(ICON_HIDE_MARKERS);
    });
    private final int bookWidth;
    private final int bookHeight;
    private final int mapWidth;
    private final int mapHeight;
    private final boolean fullscreen;
    private final BookmarkButton addMarkerBookmark;
    private final BookmarkButton deleteMarkerBookmark;
    private final BookmarkButton markerVisibilityBookmark;
    private final TextBookmarkButton resetScaleBookmark;
    private final BookmarkButton playerBookmark;
    private final ScrollBoxComponent markerScrollBox = new ScrollBoxComponent(true, 20);
    private final MarkerModal markerModal = new MarkerModal();
    private final BlinkingMarkerComponent markerCursor = new BlinkingMarkerComponent();
    private final CursorComponent eraser = new CursorComponent();
    private final List<BookmarkButton> markerBookmarks = new ArrayList<BookmarkButton>();
    private final ScreenState<AtlasScreen> state = new ScreenState((oldState, newState) -> AntiqueAtlas.lastState.switchTo((ScreenState.State<AtlasScreen>)newState, this));
    private Landmark<?> hoveredLandmark = null;
    private PlayerSummary hoveredFriend = null;
    private ButtonComponent selectedButton = null;
    private Player player;
    private WorldAtlasData worldAtlasData;
    private Integer targetOffsetX;
    private Integer targetOffsetY;
    private boolean isMouseOverMap = false;
    private boolean isDragging = false;
    private static double mapOffsetX;
    private static double mapOffsetY;
    private static int tilePixels;
    private static int tileChunks;
    private int mapScale;

    public AtlasScreen() {
        this.fullscreen = AntiqueAtlas.CONFIG.fullscreen;
        if (this.fullscreen) {
            this.bookWidth = (int)((double)Minecraft.m_91087_().m_91268_().m_85445_() * 0.9 - 40.0);
            this.bookHeight = (int)((double)Minecraft.m_91087_().m_91268_().m_85446_() * 0.9);
        } else {
            this.bookWidth = 310;
            this.bookHeight = 218;
        }
        this.setSize(this.bookWidth, this.bookHeight);
        this.mapWidth = this.bookWidth - 34;
        this.mapHeight = this.bookHeight - 22;
        this.mapScale = this.getMapScale();
        this.playerBookmark = new BookmarkButton((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.m_237115_((String)"gui.antique_atlas.followPlayer"), AntiqueAtlas.id("textures/gui/player.png"), DyeColor.GRAY, null, 7, 8, false);
        this.addChild(this.playerBookmark).offsetGuiCoords(this.bookWidth - 10, this.bookHeight - 11 - 18 - 10);
        this.playerBookmark.addListener(b -> {
            this.selectedButton = this.playerBookmark;
            this.clearTargetBookmarks(this.playerBookmark);
            this.playerBookmark.setSelected(true);
        });
        this.addMarkerBookmark = new BookmarkButton(TEXT_ADD_MARKER, ICON_ADD_MARKER, DyeColor.RED, null, 16, 16, false);
        this.addChild(this.addMarkerBookmark).offsetGuiCoords(this.bookWidth - 10, 14);
        this.addMarkerBookmark.addListener(button -> {
            if (this.state.is(PLACING_MARKER)) {
                this.selectedButton = null;
                this.state.switchTo(NORMAL, this);
            } else {
                this.selectedButton = button;
                this.state.switchTo(PLACING_MARKER, this);
                if (AtlasScreen.m_96638_()) {
                    this.markerModal.setMarkerData(this.player.m_20193_(), this.player.m_146903_(), this.player.m_146907_());
                    this.addChild(this.markerModal);
                    this.markerCursor.setTexture(this.markerModal.selectedTexture.id(), this.markerModal.selectedTexture.textureWidth(), this.markerModal.selectedTexture.textureHeight());
                    this.addChildBehind(this.markerModal, this.markerCursor).setGuiCoords((int)this.worldXToScreenX(this.player.m_146903_() - 16), (int)this.worldZToScreenY(this.player.m_146907_() - 16));
                    KeyMapping.m_90847_();
                    this.selectedButton = null;
                    this.state.switchTo(NORMAL, this);
                }
            }
        });
        this.deleteMarkerBookmark = new BookmarkButton((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.m_237115_((String)"gui.antique_atlas.delMarker"), ICON_DELETE_MARKER, DyeColor.YELLOW, null, 16, 16, false);
        this.addChild(this.deleteMarkerBookmark).offsetGuiCoords(this.bookWidth - 10, 33);
        this.deleteMarkerBookmark.addListener(button -> {
            if (this.state.is(DELETING_MARKER)) {
                this.selectedButton = null;
                this.state.switchTo(NORMAL, this);
            } else {
                this.selectedButton = button;
                this.state.switchTo(DELETING_MARKER, this);
            }
        });
        this.markerVisibilityBookmark = new BookmarkButton((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.m_237115_((String)"gui.antique_atlas.hideMarkers"), ICON_HIDE_MARKERS, DyeColor.GREEN, null, 16, 16, false);
        this.addChild(this.markerVisibilityBookmark).offsetGuiCoords(this.bookWidth - 10, 52);
        this.markerVisibilityBookmark.addListener(button -> {
            this.selectedButton = null;
            if (this.state.is(HIDING_MARKERS)) {
                this.state.switchTo(NORMAL, this);
            } else {
                this.selectedButton = null;
                this.state.switchTo(HIDING_MARKERS, this);
            }
        });
        this.resetScaleBookmark = new TextBookmarkButton((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.m_237115_((String)"gui.antique_atlas.resetScale"), net.minecraft.network.chat.Component.m_130674_((String)"1c"));
        this.addChild(this.resetScaleBookmark).offsetGuiCoords(this.bookWidth - 10, 71);
        this.resetScaleBookmark.addListener(button -> {
            this.resetZoom();
            this.resetScaleBookmark.setSelected(false);
        });
        this.addChild(this.markerScrollBox).setRelativeCoords(-14, 19);
        int markersOnScreen = (this.mapHeight - 20) / 18;
        this.markerScrollBox.getViewport().setSize(24, markersOnScreen * 20 - 2);
        this.markerModal.addMarkerListener(this.markerCursor);
        this.eraser.setTexture(ERASER, 12, 14, 2, 11);
        this.state.switchTo(AntiqueAtlas.lastState.is(HIDING_MARKERS) ? HIDING_MARKERS : NORMAL, this);
    }

    private int getMapScale() {
        return switch (AntiqueAtlas.CONFIG.mapScale) {
            case -2 -> Math.max(1, (int)Math.floor(Minecraft.m_91087_().m_91268_().m_85449_() / 2.0));
            case -1 -> Math.max(1, (int)Math.ceil(Minecraft.m_91087_().m_91268_().m_85449_() / 2.0));
            case 0 -> (int)Minecraft.m_91087_().m_91268_().m_85449_();
            default -> AntiqueAtlas.CONFIG.mapScale;
        };
    }

    private float getEffectiveScale() {
        return (float)((double)this.mapScale / Minecraft.m_91087_().m_91268_().m_85449_());
    }

    public AtlasScreen prepareToOpen() {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.0f));
        this.player = Minecraft.m_91087_().f_91074_;
        this.updateAtlasData();
        if (!AntiqueAtlas.CONFIG.keepOffset) {
            this.playerBookmark.setSelected(true);
            this.setMapPosition(this.player.m_146903_(), this.player.m_146907_());
        }
        if (!AntiqueAtlas.CONFIG.keepZoom) {
            this.resetZoom();
        }
        return this;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.setGuiCoords((this.f_96543_ - this.bookWidth) / 2, (this.f_96544_ - this.bookHeight) / 2);
        this.updateScaleBookmark();
        this.updateBookmarkerList();
    }

    public void updateBookmarkerList() {
        this.markerScrollBox.getViewport().removeAllContent();
        this.markerScrollBox.setScrollPos(0);
        this.markerBookmarks.clear();
        if (this.worldAtlasData == null) {
            return;
        }
        this.worldAtlasData.getEditableLandmarks().forEach((landmark, texture) -> {
            MarkerBookmarkButton bookmark = new MarkerBookmarkButton(landmark.name(), (MarkerTexture)texture, landmark.color(), true);
            bookmark.addListener(button -> {
                if (this.state.is(NORMAL)) {
                    this.clearTargetBookmarks(bookmark);
                    this.setTargetPosition(new ColumnPos(landmark.pos().m_123341_(), landmark.pos().m_123343_()));
                } else if (this.state.is(DELETING_MARKER)) {
                    if (!this.worldAtlasData.deleteLandmark(this.player.m_20193_(), (Landmark<?>)landmark)) {
                        return;
                    }
                    this.updateBookmarkerList();
                    this.player.m_20193_().m_5594_(this.player, this.player.m_20183_(), SoundEvents.f_12493_, SoundSource.AMBIENT, 1.0f, 0.5f);
                    if (!AtlasScreen.m_96638_()) {
                        this.state.switchTo(NORMAL, this);
                    }
                }
            });
            this.markerBookmarks.add(bookmark);
        });
        int[] contentY = new int[]{0};
        for (BookmarkButton bookmark : this.markerBookmarks) {
            this.markerScrollBox.getViewport().addContent(bookmark).setRelativeY(contentY[0]);
            contentY[0] = contentY[0] + 20;
        }
    }

    public void clearTargetBookmarks(BookmarkButton except) {
        if (this.playerBookmark != except) {
            this.playerBookmark.setSelected(false);
        }
        for (BookmarkButton bookmark : this.markerBookmarks) {
            if (bookmark == except) continue;
            bookmark.setSelected(false);
        }
    }

    public void updateMouse(double mouseX, double mouseY) {
        double relativeMouseX = mouseX - (double)this.getGuiX();
        double relativeMouseY = mouseY - (double)this.getGuiY();
        this.isMouseOverMap = relativeMouseX >= 17.0 && relativeMouseX <= (double)(17 + this.mapWidth) && relativeMouseY >= 11.0 && relativeMouseY <= (double)(11 + this.mapHeight);
    }

    @Override
    public void m_94757_(double mouseX, double mouseY) {
        super.m_94757_(mouseX, mouseY);
        this.updateMouse(mouseX, mouseY);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int mouseState) {
        this.updateMouse(mouseX, mouseY);
        if (super.m_6375_(mouseX, mouseY, mouseState)) {
            return true;
        }
        if (this.markerModal.getParent() != null) {
            return false;
        }
        if (!this.state.is(NORMAL) && !this.state.is(HIDING_MARKERS)) {
            if (this.state.is(PLACING_MARKER) && this.isMouseOverMap && mouseState == 0) {
                this.markerModal.setMarkerData(this.player.m_20193_(), this.screenXToWorldX(mouseX), this.screenYToWorldZ(mouseY));
                this.addChild(this.markerModal);
                this.markerCursor.setTexture(this.markerModal.selectedTexture.id(), 32, 32);
                this.addChildBehind(this.markerModal, this.markerCursor).setGuiCoords((int)mouseX - 16, (int)mouseY - 16);
                KeyMapping.m_90847_();
                this.state.switchTo(NORMAL, this);
                return true;
            }
            if (this.state.is(DELETING_MARKER) && this.hoveredLandmark != null && this.isMouseOverMap && mouseState == 0 && this.worldAtlasData.deleteLandmark(this.player.m_20193_(), this.hoveredLandmark)) {
                this.updateBookmarkerList();
                this.player.m_20193_().m_5594_(this.player, this.player.m_20183_(), SoundEvents.f_12493_, SoundSource.AMBIENT, 1.0f, 0.5f);
            }
            if (!AtlasScreen.m_96638_() || !this.state.is(DELETING_MARKER)) {
                this.state.switchTo(NORMAL, this);
            }
        } else if (this.isMouseOverMap && this.selectedButton == null) {
            this.isDragging = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 265) {
            this.navigateMap(0, 24);
        } else if (keyCode == 264) {
            this.navigateMap(0, -24);
        } else if (keyCode == 263) {
            this.navigateMap(24, 0);
        } else if (keyCode == 262) {
            this.navigateMap(-24, 0);
        } else if (keyCode == 61 || keyCode == 334) {
            this.zoomIn(true, 16 << AntiqueAtlas.CONFIG.maxTilePixels);
        } else if (keyCode == 45 || keyCode == 333) {
            this.zoomOut(true, 1 << AntiqueAtlas.CONFIG.maxTileChunks);
        } else if (keyCode == 256 || AntiqueAtlasKeybindings.ATLAS_KEYMAPPING.m_90832_(keyCode, scanCode) && this.markerModal.getParent() == null) {
            this.m_7379_();
        } else {
            return super.m_7933_(keyCode, scanCode, modifiers);
        }
        return true;
    }

    private double getPixelsPerBlock() {
        return (double)this.getEffectiveScale() * (double)tilePixels / ((double)tileChunks * 16.0);
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double wheelMove) {
        this.updateMouse(mouseX, mouseY);
        if (super.m_6050_(mouseX, mouseY, wheelMove)) {
            return true;
        }
        if (this.markerModal.getParent() == null && wheelMove != 0.0) {
            int direction;
            int n = direction = wheelMove > 0.0 ? 1 : -1;
            if ((wheelMove > 0.0 ? this.zoomIn(true, 16 << AntiqueAtlas.CONFIG.maxTilePixels) : this.zoomOut(true, 1 << AntiqueAtlas.CONFIG.maxTileChunks)) && (this.isMouseOverMap || this.isDragging)) {
                double xOffset = ((double)(this.getGuiX() + 17) + (double)this.mapWidth / 2.0 - mouseX) * (double)direction;
                double yOffset = ((double)(this.getGuiY() + 11) + (double)this.mapHeight / 2.0 - mouseY) * (double)direction;
                if (Math.abs(xOffset) > 5.0 || Math.abs(yOffset) > 5.0) {
                    mapOffsetX += xOffset / (direction < 0 ? 2.0 : 1.0);
                    mapOffsetY += yOffset / (direction < 0 ? 2.0 : 1.0);
                    this.clearTargetBookmarks(null);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int mouseState) {
        boolean result = false;
        if (mouseState != -1) {
            result = this.selectedButton != null || this.isDragging;
            this.selectedButton = null;
            this.isDragging = false;
        }
        return super.m_6348_(mouseX, mouseY, mouseState) || result;
    }

    @Override
    public boolean m_7979_(double mouseX, double mouseY, int lastMouseButton, double deltaX, double deltaY) {
        boolean result = false;
        if (this.isDragging) {
            this.clearTargetBookmarks(null);
            mapOffsetX += deltaX;
            mapOffsetY += deltaY;
            result = true;
        }
        return super.m_7979_(mouseX, mouseY, lastMouseButton, deltaX, deltaY) || result;
    }

    @Override
    public void m_86600_() {
        super.m_86600_();
        if (this.player == null) {
            return;
        }
        if (this.playerBookmark.isSelected() && (mapOffsetX != (double)(-this.player.m_146903_()) * this.getPixelsPerBlock() || mapOffsetY != (double)(-this.player.m_146907_()) * this.getPixelsPerBlock())) {
            this.setTargetPosition(new ColumnPos(this.player.m_146903_(), this.player.m_146907_()));
        }
        if (this.targetOffsetX != null) {
            if (Math.abs(this.getTargetPositionX() - mapOffsetX) > 24.0) {
                this.softNavigateMap(this.getTargetPositionX() > mapOffsetX ? 24 : -24, 0);
            } else {
                mapOffsetX = this.getTargetPositionX();
                this.targetOffsetX = null;
            }
        }
        if (this.targetOffsetY != null) {
            if (Math.abs(this.getTargetPositionY() - mapOffsetY) > 24.0) {
                this.softNavigateMap(0, this.getTargetPositionY() > mapOffsetY ? 24 : -24);
            } else {
                mapOffsetY = this.getTargetPositionY();
                this.targetOffsetY = null;
            }
        }
    }

    private void updateAtlasData() {
        if (Minecraft.m_91087_().f_91073_ != null) {
            this.worldAtlasData = WorldAtlasData.getOrCreate((Level)Minecraft.m_91087_().f_91073_);
        }
    }

    private void navigateMap(int dx, int dy) {
        mapOffsetX += (double)dx;
        mapOffsetY += (double)dy;
        this.clearTargetBookmarks(null);
    }

    private void softNavigateMap(int dx, int dy) {
        mapOffsetX += (double)dx;
        mapOffsetY += (double)dy;
    }

    private void setMapPosition(int x, int z) {
        mapOffsetX = (int)((double)(-x) * this.getPixelsPerBlock());
        mapOffsetY = (int)((double)(-z) * this.getPixelsPerBlock());
    }

    private void setTargetPosition(ColumnPos pos) {
        this.targetOffsetX = pos.f_140723_();
        this.targetOffsetY = pos.f_140724_();
    }

    private double getTargetPositionX() {
        return (double)(-this.targetOffsetX.intValue()) * this.getPixelsPerBlock();
    }

    private double getTargetPositionY() {
        return (double)(-this.targetOffsetY.intValue()) * this.getPixelsPerBlock();
    }

    private void updateScaleBookmark() {
        int tileSizeBlocks = tileChunks * 16 * 16 / tilePixels;
        int defaultTileSizeBlocks = 16;
        int rulerSizeBlocks = (int)((float)tileSizeBlocks / this.getEffectiveScale());
        this.resetScaleBookmark.setLabel((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.m_237113_((String)(rulerSizeBlocks == 16 | rulerSizeBlocks >= 32 ? "%dc".formatted(rulerSizeBlocks / 16) : "%db".formatted(rulerSizeBlocks))).m_130940_(tileSizeBlocks < defaultTileSizeBlocks ? ChatFormatting.DARK_RED : (tileSizeBlocks == defaultTileSizeBlocks ? ChatFormatting.BLACK : ChatFormatting.DARK_BLUE)));
    }

    private boolean zoomIn(boolean playSound, int maxTilePixels) {
        if (tileChunks == 1) {
            if (tilePixels >= maxTilePixels) {
                return false;
            }
            tilePixels <<= 1;
            if (playSound) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_144231_, (float)1.0f));
            }
        } else {
            tileChunks >>= 1;
            if (playSound) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.0f));
            }
        }
        mapOffsetX *= 2.0;
        mapOffsetY *= 2.0;
        this.updateScaleBookmark();
        return true;
    }

    private boolean zoomOut(boolean playSound, int maxTileChunks) {
        if (tilePixels == 16) {
            if (tileChunks >= maxTileChunks) {
                return false;
            }
            tileChunks <<= 1;
            if (playSound) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.0f));
            }
        } else {
            tilePixels >>= 1;
            if (playSound) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_144231_, (float)1.0f));
            }
        }
        mapOffsetX /= 2.0;
        mapOffsetY /= 2.0;
        this.updateScaleBookmark();
        return true;
    }

    private void resetZoom() {
        block3: {
            block2: {
                if (!this.zoomIn(true, 8)) break block2;
                while (this.zoomIn(false, 8)) {
                }
                break block3;
            }
            if (!this.zoomOut(true, 1)) break block3;
            while (this.zoomOut(false, 1)) {
            }
        }
    }

    @Override
    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float par3) {
        Object texture2;
        super.m_280273_(context);
        this.mapScale = this.getMapScale();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.fullscreen) {
            int left_width = this.bookWidth / 2 - 15;
            context.m_280260_(BOOK_FULLSCREEN, this.getGuiX(), this.getGuiY(), left_width, this.bookHeight, 50, 140, 218, 0, 0);
            context.m_280260_(BOOK_FULLSCREEN, this.getGuiX() + left_width, this.getGuiY(), 29, this.bookHeight, 50, 29, 218, 140, 0);
            context.m_280260_(BOOK_FULLSCREEN_R, this.getGuiX() + left_width + 29, this.getGuiY(), left_width + 1, this.bookHeight, 50, 140, 218, 0, 0);
        } else {
            context.m_280163_(BOOK, this.getGuiX(), this.getGuiY(), 0.0f, 0.0f, this.bookWidth, this.bookHeight, this.bookWidth, this.bookHeight);
        }
        if (this.worldAtlasData == null) {
            return;
        }
        double guiScale = this.f_96541_.m_91268_().m_85449_();
        RenderSystem.enableScissor((int)((int)(guiScale * (double)(this.getGuiX() + 17))), (int)((int)(guiScale * (double)(this.getGuiY() + 11))), (int)((int)(guiScale * (double)this.mapWidth)), (int)((int)(guiScale * (double)this.mapHeight)));
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        int mapStartChunkX = MathUtil.roundToBase(this.screenXToWorldX(this.getGuiX()) >> 4, tileChunks) - 2 * tileChunks;
        int mapStartChunkZ = MathUtil.roundToBase(this.screenYToWorldZ(this.getGuiY()) >> 4, tileChunks) - 2 * tileChunks;
        int mapEndChunkX = MathUtil.roundToBase(this.screenXToWorldX(this.getGuiX() + this.bookWidth) >> 4, tileChunks) + 2 * tileChunks;
        int mapEndChunkZ = MathUtil.roundToBase(this.screenYToWorldZ(this.getGuiY() + this.bookHeight) >> 4, tileChunks) + 2 * tileChunks;
        double mapStartScreenX = this.worldXToScreenX(mapStartChunkX << 4);
        double mapStartScreenY = this.worldZToScreenY(mapStartChunkZ << 4);
        TileRenderIterator tiles = new TileRenderIterator(this.worldAtlasData);
        tiles.setScope(new Rect(mapStartChunkX, mapStartChunkZ, mapEndChunkX, mapEndChunkZ));
        tiles.setStep(tileChunks);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.state.is(DELETING_MARKER) ? 0.5f : 1.0f));
        AtlasScreen.renderTiles(context.m_280168_(), null, this.getGuiX() + 17, this.getGuiY() + 11, 0, this.mapWidth, this.mapHeight, mapStartScreenX, mapStartScreenY, this.mapScale, tilePixels, guiScale, 0xF00000, tiles);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.fullscreen) {
            int left_width = this.bookWidth / 2 - 15;
            context.m_280260_(BOOK_FRAME_FULLSCREEN, this.getGuiX(), this.getGuiY(), left_width, this.bookHeight, 50, 140, 218, 0, 0);
            context.m_280260_(BOOK_FRAME_FULLSCREEN, this.getGuiX() + left_width, this.getGuiY(), 29, this.bookHeight, 50, 29, 218, 140, 0);
            context.m_280260_(BOOK_FRAME_FULLSCREEN_R, this.getGuiX() + left_width + 29, this.getGuiY(), left_width + 1, this.bookHeight, 50, 140, 218, 0, 0);
        } else {
            context.m_280163_(BOOK_FRAME, this.getGuiX(), this.getGuiY(), 0.0f, 0.0f, this.bookWidth, this.bookHeight, this.bookWidth, this.bookHeight);
        }
        context.m_280168_().m_85836_();
        context.m_280168_().m_252880_((float)this.getGuiX(), (float)this.getGuiY(), 0.0f);
        float markerScale = (float)((double)tilePixels * (double)this.mapScale / (guiScale * 16.0));
        Map friends = SurveyorClient.getFriends();
        this.hoveredLandmark = null;
        this.hoveredFriend = null;
        if (!this.state.is(HIDING_MARKERS)) {
            if (this.isMouseOverMap) {
                double bestDistance = Double.MAX_VALUE;
                for (Map.Entry<Landmark<?>, MarkerTexture> entry : this.worldAtlasData.getAllMarkers(tileChunks).entrySet()) {
                    Landmark<?> landmark2 = entry.getKey();
                    texture2 = entry.getValue();
                    double markerX = this.worldXToScreenX(landmark2.pos().m_123341_());
                    double markerY = this.worldZToScreenY(landmark2.pos().m_123343_());
                    Vector2d markerCenter = ((MarkerTexture)texture2).getCenter(tileChunks);
                    double squaredDistance = Vector2d.distanceSquared((double)(markerX + (double)markerScale * markerCenter.x), (double)(markerY + (double)markerScale * markerCenter.y), (double)mouseX, (double)mouseY);
                    if (!(squaredDistance > 0.0) || !(squaredDistance < bestDistance) || !(squaredDistance < ((MarkerTexture)texture2).getSquaredSize(tileChunks) * (double)markerScale * (double)markerScale / 4.0)) continue;
                    bestDistance = squaredDistance;
                    this.hoveredLandmark = landmark2;
                }
                for (PlayerSummary friend2 : friends.values()) {
                    double markerY;
                    double markerX = this.worldXToScreenX(friend2.pos().m_7096_());
                    double squaredDistance = Vector2d.distanceSquared((double)markerX, (double)(markerY = this.worldZToScreenY(friend2.pos().m_7094_())), (double)mouseX, (double)mouseY);
                    if (!(squaredDistance > 0.0) || !(squaredDistance < bestDistance) || !(squaredDistance < 21.0)) continue;
                    bestDistance = squaredDistance;
                    this.hoveredFriend = friend2;
                    this.hoveredLandmark = null;
                }
            }
            this.worldAtlasData.getAllMarkers(tileChunks).forEach((landmark, texture) -> this.renderMarker(context, (Landmark<?>)landmark, (MarkerTexture)texture, WorldAtlasData.landmarkIsEditable(landmark), this.hoveredLandmark == landmark && this.markerModal.getParent() == null, markerScale));
        }
        context.m_280168_().m_85849_();
        RenderSystem.disableScissor();
        if (this.fullscreen) {
            int left_width = this.bookWidth / 2 - 15;
            context.m_280260_(BOOK_FRAME_NARROW_FULLSCREEN, this.getGuiX(), this.getGuiY(), left_width, this.bookHeight, 50, 140, 218, 0, 0);
            context.m_280260_(BOOK_FRAME_NARROW_FULLSCREEN, this.getGuiX() + left_width, this.getGuiY(), 29, this.bookHeight, 50, 29, 218, 140, 0);
            context.m_280260_(BOOK_FRAME_NARROW_FULLSCREEN_R, this.getGuiX() + left_width + 29, this.getGuiY(), left_width + 1, this.bookHeight, 50, 140, 218, 0, 0);
        } else {
            context.m_280163_(BOOK_FRAME_NARROW, this.getGuiX(), this.getGuiY(), 0.0f, 0.0f, this.bookWidth, this.bookHeight, this.bookWidth, this.bookHeight);
        }
        this.markerScrollBox.getViewport().setHidden(this.state.is(HIDING_MARKERS));
        context.m_280168_().m_85836_();
        context.m_280168_().m_252880_((float)this.getGuiX(), (float)this.getGuiY(), 0.0f);
        PlayerSummary playerSummary = (PlayerSummary)friends.remove(SurveyorClient.getClientUuid());
        LinkedHashMap<UUID, PlayerSummary> orderedFriends = new LinkedHashMap<UUID, PlayerSummary>(friends);
        if (playerSummary != null) {
            orderedFriends.put(SurveyorClient.getClientUuid(), playerSummary);
        }
        orderedFriends.forEach((uuid, friend) -> {
            if (this.state.is(HIDING_MARKERS) && (!this.playerBookmark.isSelected() || friend != playerSummary)) {
                return;
            }
            this.renderPlayer(context, (PlayerSummary)friend, (float)((double)this.mapScale / guiScale), this.hoveredFriend == friend && this.markerModal.getParent() == null, friend == playerSummary);
        });
        context.m_280168_().m_85849_();
        super.m_88315_(context, mouseX, mouseY, par3);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        if (this.state.is(PLACING_MARKER)) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            context.m_280163_(this.markerModal.selectedTexture.id(), mouseX + this.markerModal.selectedTexture.offsetX(), mouseY + this.markerModal.selectedTexture.offsetY(), 0.0f, 0.0f, this.markerModal.selectedTexture.textureWidth(), this.markerModal.selectedTexture.textureHeight(), this.markerModal.selectedTexture.textureWidth(), this.markerModal.selectedTexture.textureHeight());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        RenderSystem.disableBlend();
        this.addMarkerBookmark.setTitle(AtlasScreen.m_96638_() ? TEXT_ADD_MARKER_HERE : TEXT_ADD_MARKER);
        if (AntiqueAtlas.CONFIG.debugRender && !this.isDragging && this.isMouseOverMap && this.markerModal.getParent() == null) {
            int x = this.screenXToWorldX((int)this.getMouseX());
            int z = this.screenYToWorldZ((int)this.getMouseY());
            ChunkPos pos = new ChunkPos(new BlockPos(x, 0, z));
            context.m_280614_(this.f_96547_, (net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.m_237113_((String)"%d,%d (%d,%d)".formatted(pos.f_45578_, pos.f_45579_, x, z)), this.getGuiX(), this.getGuiY() - 12, -1, true);
            if (this.hoveredLandmark != null) {
                texture2 = this.worldAtlasData.getMarkerTexture(this.hoveredLandmark);
                context.m_280614_(this.f_96547_, (net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.m_237113_((String)this.hoveredLandmark.type().id().toString()), this.getGuiX() + this.bookWidth - this.f_96547_.m_92852_((FormattedText)net.minecraft.network.chat.Component.m_237113_((String)this.hoveredLandmark.type().id().toString())), this.getGuiY() - 12, -1, true);
                Landmark<?> landmark3 = this.hoveredLandmark;
                if (landmark3 instanceof AtlasStructureLandmark) {
                    AtlasStructureLandmark sLandmark = (AtlasStructureLandmark)landmark3;
                    context.m_280614_(this.f_96547_, (net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.m_237113_((String)sLandmark.displayId().toString()), this.getGuiX(), this.getGuiY() + this.bookHeight, -1, true);
                }
                if (texture2 != null) {
                    context.m_280614_(this.f_96547_, (net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.m_237113_((String)((MarkerTexture)texture2).displayId()), this.getGuiX() + this.bookWidth - this.f_96547_.m_92852_((FormattedText)net.minecraft.network.chat.Component.m_237113_((String)((MarkerTexture)texture2).displayId())), this.getGuiY() + this.bookHeight, -1, true);
                }
            } else {
                texture2 = this.worldAtlasData.getTile(pos);
                ResourceLocation providerId = this.worldAtlasData.getProvider(pos);
                String predicate = this.worldAtlasData.getTilePredicate(pos);
                if (texture2 != null) {
                    if (predicate != null) {
                        context.m_280614_(this.f_96547_, (net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.m_237113_((String)predicate), this.getGuiX() + this.bookWidth - this.f_96547_.m_92852_((FormattedText)net.minecraft.network.chat.Component.m_237113_((String)predicate)), this.getGuiY() - 12, -1, true);
                    }
                    context.m_280614_(this.f_96547_, (net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.m_237113_((String)providerId.toString()), this.getGuiX(), this.getGuiY() + this.bookHeight, -1, true);
                    context.m_280614_(this.f_96547_, (net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.m_237113_((String)((TileTexture)texture2).displayId()), this.getGuiX() + this.bookWidth - this.f_96547_.m_92852_((FormattedText)net.minecraft.network.chat.Component.m_237113_((String)((TileTexture)texture2).displayId())), this.getGuiY() + this.bookHeight, -1, true);
                }
            }
        }
    }

    public static void renderTiles(PoseStack matrices, MultiBufferSource vertexConsumers, int mapX, int mapY, int z, int mapWidth, int mapHeight, double mapStartScreenX, double mapStartScreenY, double mapScale, int pixelsPerTile, double guiScale, int light, TileRenderIterator tiles) {
        float effectiveScale = (float)(mapScale / guiScale);
        matrices.m_85836_();
        matrices.m_85837_(mapStartScreenX, mapStartScreenY, 0.0);
        matrices.m_85841_(effectiveScale, effectiveScale, 1.0f);
        Reference2ObjectArrayMap tileTextures = new Reference2ObjectArrayMap();
        for (SubTileQuartet subTiles : tiles) {
            for (SubTile subtile : subTiles) {
                if (subtile == null || subtile.texture == null) continue;
                tileTextures.computeIfAbsent(subtile.texture, k -> new ArrayList()).add(subtile.copy());
            }
        }
        int subTilePixels = pixelsPerTile / 2;
        tileTextures.forEach((texture, subtiles) -> {
            try (DrawBatcher batcher = new DrawBatcher(matrices, vertexConsumers, texture.id(), 32, 48, light);){
                for (SubTile subtile : subtiles) {
                    int drawX = subtile.x * subTilePixels;
                    int drawY = subtile.y * subTilePixels;
                    if ((double)((float)drawX * effectiveScale) > (double)(mapX + mapWidth) - mapStartScreenX || (double)((float)drawY * effectiveScale) > (double)(mapY + mapHeight) - mapStartScreenY || (double)((float)(drawX + subTilePixels) * effectiveScale) < (double)mapX - mapStartScreenX || (double)((float)(drawY + subTilePixels) * effectiveScale) < (double)mapY - mapStartScreenY) continue;
                    batcher.add(drawX, drawY, z, subTilePixels, subTilePixels, subtile.getTextureU() * 8, subtile.getTextureV() * 8, 8, 8, -1);
                }
            }
        });
        matrices.m_85849_();
    }

    private void renderPlayer(GuiGraphics context, PlayerSummary player, float iconScale, boolean hovering, boolean self) {
        double playerOffsetX = this.worldXToScreenX(player.pos().m_7096_()) - (double)this.getGuiX();
        double playerOffsetY = this.worldZToScreenY(player.pos().m_7094_()) - (double)this.getGuiY();
        playerOffsetX = Mth.m_14008_((double)playerOffsetX, (double)17.0, (double)(this.mapWidth + 17));
        playerOffsetY = Mth.m_14008_((double)playerOffsetY, (double)11.0, (double)(this.mapHeight + 11));
        float tint = (player.online() ? 1.0f : 0.5f) * (hovering ? 0.9f : 1.0f);
        float greenTint = self ? 1.0f : 0.7f;
        int argb = FastColor.ARGB32.m_13660_((int)(this.state.is(PLACING_MARKER) ? 127 : 255), (int)((int)(tint * 255.0f)), (int)((int)(tint * greenTint * 255.0f)), (int)((int)(tint * 255.0f)));
        float playerRotation = (float)Math.round(player.yaw() / 360.0f * 16.0f) / 16.0f * 360.0f;
        DrawUtil.drawCenteredWithRotation(context.m_280168_(), null, PLAYER, playerOffsetX, playerOffsetY, 0.0f, iconScale, 7, 8, playerRotation, 0xF00000, argb);
        if (hovering && !self) {
            context.m_280557_(this.f_96547_, (net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.m_237113_((String)player.username()).m_130940_(player.online() ? ChatFormatting.LIGHT_PURPLE : ChatFormatting.GRAY), (int)this.getMouseX() - this.getGuiX(), (int)this.getMouseY() - this.getGuiY());
        }
    }

    private void renderMarker(GuiGraphics context, Landmark<?> landmark, MarkerTexture texture, boolean editable, boolean hovering, float markerScale) {
        DyeColor color;
        float alpha;
        double markerX = this.worldXToScreenX(landmark.pos().m_123341_()) - (double)this.getGuiX();
        double markerY = this.worldZToScreenY(landmark.pos().m_123343_()) - (double)this.getGuiY();
        float tint = hovering ? 0.8f : 1.0f;
        float f = alpha = this.state.is(PLACING_MARKER) || this.state.is(DELETING_MARKER) && !editable || editable && markerX <= 17.0 || markerX >= (double)(this.mapWidth + 17) || markerY <= 11.0 || markerY >= (double)(this.mapHeight + 11) ? 0.5f : 1.0f;
        if (editable) {
            markerX = Mth.m_14008_((double)markerX, (double)17.0, (double)(this.mapWidth + 17));
            markerY = Mth.m_14008_((double)markerY, (double)11.0, (double)(this.mapHeight + 11));
        }
        texture.draw(context, markerX, markerY, markerScale, tileChunks, (color = landmark.color()) == null ? null : color.m_41068_(), tint, alpha);
        if (hovering && landmark.name() != null && !landmark.name().getString().isEmpty()) {
            context.m_280557_(this.f_96547_, landmark.name(), (int)this.getMouseX() - this.getGuiX(), (int)this.getMouseY() - this.getGuiY());
        }
    }

    public boolean m_7043_() {
        return false;
    }

    @Override
    public void m_7379_() {
        super.m_7379_();
        this.markerModal.closeChild();
        this.removeChild(this.markerCursor);
    }

    private int screenXToWorldX(double screenX) {
        return AtlasScreen.screenXToWorldX(screenX, this.getGuiX(), mapOffsetX, this.mapWidth, this.getPixelsPerBlock());
    }

    private int screenYToWorldZ(double screenY) {
        return AtlasScreen.screenYToWorldZ(screenY, this.getGuiY(), mapOffsetY, this.mapHeight, this.getPixelsPerBlock());
    }

    private double worldXToScreenX(double x) {
        return AtlasScreen.worldXToScreenX(x, this.getGuiX(), mapOffsetX, this.mapWidth, this.getPixelsPerBlock());
    }

    private double worldZToScreenY(double z) {
        return AtlasScreen.worldZToScreenY(z, this.getGuiY(), mapOffsetY, this.mapHeight, this.getPixelsPerBlock());
    }

    public static int screenXToWorldX(double screenX, int bookX, double mapOffsetX, int mapWidth, double pixelsPerBlock) {
        double mapX = (int)Math.round(screenX - (double)bookX - 17.0);
        return (int)Math.round((mapX - (double)((float)mapWidth / 2.0f) - mapOffsetX) / pixelsPerBlock);
    }

    public static int screenYToWorldZ(double screenY, int bookY, double mapOffsetY, int mapHeight, double pixelsPerBlock) {
        double mapY = (int)Math.round(screenY - (double)bookY - 11.0);
        return (int)Math.round((mapY - (double)((float)mapHeight / 2.0f) - mapOffsetY) / pixelsPerBlock);
    }

    public static double worldXToScreenX(double x, int bookX, double mapOffsetX, int mapWidth, double pixelsPerBlock) {
        double mapX = x * pixelsPerBlock + mapOffsetX + (double)((float)mapWidth / 2.0f);
        return mapX + (double)bookX + 17.0;
    }

    public static double worldZToScreenY(double z, int bookY, double mapOffsetY, int mapHeight, double pixelsPerBlock) {
        double mapY = z * pixelsPerBlock + mapOffsetY + (double)((float)mapHeight / 2.0f);
        return mapY + (double)bookY + 11.0;
    }

    @Override
    protected void onChildClosed(Component child) {
        if (((Object)((Object)child)).equals((Object)this.markerModal)) {
            this.removeChild(this.markerCursor);
        }
    }

    public WorldAtlasData getworldAtlasData() {
        return this.worldAtlasData;
    }

    static {
        tilePixels = 16;
        tileChunks = 1;
    }
}

