/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.mixin;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.xylonity.knightlib.KnightLib;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.crafting.RecipeManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RecipeManager.class})
public class RecipeManagerMixin {
    @Unique
    private static final String knightlib$GREAT_CHALICE = new ResourceLocation("knightlib", "great_chalice").toString();
    @Unique
    private static final String knightlib$HOMUNCULUS = new ResourceLocation("knightlib", "homunculus").toString();
    @Unique
    private static final String knightlib$EMPTY_GRAIL = new ResourceLocation("knightlib", "empty_grail").toString();
    @Unique
    private static final String knightlib$SMALL_ESSENCE = new ResourceLocation("knightlib", "small_essence").toString();
    @Unique
    private static final String knightlib$GREAT_ESSENCE = new ResourceLocation("knightlib", "great_essence").toString();

    @Inject(method={"apply(Ljava/util/Map;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)V"}, at={@At(value="HEAD")})
    private void knightlib$apply(Map<?, ?> map, ResourceManager resourceManager, ProfilerFiller profilerFiller, CallbackInfo ci) {
        boolean essences;
        if (map == null || map.isEmpty()) {
            return;
        }
        boolean greatChalice = !KnightLib.isEnabled(KnightLib.Usage.GREAT_CHALICE);
        boolean homunculus = !KnightLib.isEnabled(KnightLib.Usage.HOMUNCULUS);
        boolean emptyGrail = !KnightLib.isEnabled(KnightLib.Usage.COPPER_GRAILS);
        boolean bl = essences = !KnightLib.isEnabled(KnightLib.Usage.GREEN_ESSENCES);
        if (!(greatChalice || homunculus || emptyGrail || essences)) {
            return;
        }
        Object entry = null;
        Iterator<?> iterator = map.values().iterator();
        if (iterator.hasNext()) {
            Object value = iterator.next();
            entry = value;
        }
        if (entry == null) {
            return;
        }
        if (entry instanceof JsonElement) {
            Iterator<Map.Entry<?, ?>> iterator2 = map.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<?, ?> element = iterator2.next();
                Object obj = element.getValue();
                if (!(obj instanceof JsonObject)) continue;
                JsonObject object = (JsonObject)obj;
                boolean remove = false;
                if (!remove) {
                    if (essences && (RecipeManagerMixin.knightlib$jsonResultIs(object, knightlib$SMALL_ESSENCE) || RecipeManagerMixin.knightlib$jsonResultIs(object, knightlib$GREAT_ESSENCE))) {
                        remove = true;
                    } else if (greatChalice && RecipeManagerMixin.knightlib$jsonResultIs(object, knightlib$GREAT_CHALICE)) {
                        remove = true;
                    } else if (homunculus && RecipeManagerMixin.knightlib$jsonResultIs(object, knightlib$HOMUNCULUS)) {
                        remove = true;
                    } else if (emptyGrail && RecipeManagerMixin.knightlib$jsonResultIs(object, knightlib$EMPTY_GRAIL)) {
                        remove = true;
                    }
                }
                if (!remove) {
                    if (essences && (RecipeManagerMixin.knightlib$jsonHasIngredient(object, knightlib$SMALL_ESSENCE) || RecipeManagerMixin.knightlib$jsonHasIngredient(object, knightlib$GREAT_ESSENCE))) {
                        remove = true;
                    } else if (greatChalice && RecipeManagerMixin.knightlib$jsonHasIngredient(object, knightlib$GREAT_CHALICE)) {
                        remove = true;
                    } else if (homunculus && RecipeManagerMixin.knightlib$jsonHasIngredient(object, knightlib$HOMUNCULUS)) {
                        remove = true;
                    } else if (emptyGrail && RecipeManagerMixin.knightlib$jsonHasIngredient(object, knightlib$EMPTY_GRAIL)) {
                        remove = true;
                    }
                }
                if (!remove) continue;
                iterator2.remove();
            }
            return;
        }
        if (entry instanceof Map) {
            Collection<?> byType = map.values();
            for (Map byId : byType) {
                if (greatChalice) {
                    byId.remove(new ResourceLocation("knightlib", "great_chalice"));
                }
                if (homunculus) {
                    byId.remove(new ResourceLocation("knightlib", "homunculus"));
                }
                if (!emptyGrail) continue;
                byId.remove(new ResourceLocation("knightlib", "empty_grail"));
            }
        }
    }

    @Unique
    private static boolean knightlib$jsonResultIs(JsonObject object, String target) {
        JsonElement element = object.get("result");
        if (element == null) {
            element = object.get("output");
        }
        if (element == null) {
            return false;
        }
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
            return target.equals(element.getAsString());
        }
        if (element.isJsonObject()) {
            return target.equals(RecipeManagerMixin.knightlib$first(element.getAsJsonObject(), "item", "id", "result", "output"));
        }
        if (element.isJsonArray()) {
            for (JsonElement elem : element.getAsJsonArray()) {
                if (!(elem.isJsonPrimitive() && elem.getAsJsonPrimitive().isString() ? target.equals(elem.getAsString()) : elem.isJsonObject() && target.equals(RecipeManagerMixin.knightlib$first(elem.getAsJsonObject(), "item", "id", "result", "output")))) continue;
                return true;
            }
        }
        return false;
    }

    @Unique
    private static boolean knightlib$jsonHasIngredient(JsonObject jsonObject, String target) {
        if (RecipeManagerMixin.knightlib$arrayHasItem((JsonElement)RecipeManagerMixin.knightlib$getArray(jsonObject, "ingredients"), target)) {
            return true;
        }
        if (RecipeManagerMixin.knightlib$hasItem(RecipeManagerMixin.knightlib$get(jsonObject, "ingredient"), target)) {
            return true;
        }
        if (RecipeManagerMixin.knightlib$objectHasItem(RecipeManagerMixin.knightlib$getObject(jsonObject, "key"), target)) {
            return true;
        }
        if (RecipeManagerMixin.knightlib$hasItem(RecipeManagerMixin.knightlib$get(jsonObject, "base"), target)) {
            return true;
        }
        if (RecipeManagerMixin.knightlib$hasItem(RecipeManagerMixin.knightlib$get(jsonObject, "addition"), target)) {
            return true;
        }
        if (RecipeManagerMixin.knightlib$hasItem(RecipeManagerMixin.knightlib$get(jsonObject, "template"), target)) {
            return true;
        }
        if (RecipeManagerMixin.knightlib$hasItem(RecipeManagerMixin.knightlib$get(jsonObject, "input"), target)) {
            return true;
        }
        return RecipeManagerMixin.knightlib$arrayHasItem((JsonElement)RecipeManagerMixin.knightlib$getArray(jsonObject, "inputs"), target);
    }

    @Unique
    private static boolean knightlib$objectHasItem(JsonObject object, String target) {
        if (object == null) {
            return false;
        }
        for (Map.Entry element : object.entrySet()) {
            if (!RecipeManagerMixin.knightlib$hasItem((JsonElement)element.getValue(), target)) continue;
            return true;
        }
        return false;
    }

    @Unique
    private static boolean knightlib$arrayHasItem(JsonElement element, String target) {
        if (element == null || !element.isJsonArray()) {
            return false;
        }
        for (JsonElement elem : element.getAsJsonArray()) {
            if (!RecipeManagerMixin.knightlib$hasItem(elem, target)) continue;
            return true;
        }
        return false;
    }

    @Unique
    private static boolean knightlib$hasItem(JsonElement element, String target) {
        if (element == null) {
            return false;
        }
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
            return target.equals(element.getAsString());
        }
        if (element.isJsonObject()) {
            JsonObject object = element.getAsJsonObject();
            String direct = RecipeManagerMixin.knightlib$first(object, "item", "id");
            if (target.equals(direct)) {
                return true;
            }
            JsonArray items = RecipeManagerMixin.knightlib$getArray(object, "items");
            if (items != null) {
                for (JsonElement elem : items) {
                    String nested;
                    if (!(elem.isJsonPrimitive() && elem.getAsJsonPrimitive().isString() ? target.equals(elem.getAsString()) : elem.isJsonObject() && target.equals(nested = RecipeManagerMixin.knightlib$first(elem.getAsJsonObject(), "item", "id")))) continue;
                    return true;
                }
            }
        }
        if (element.isJsonArray()) {
            for (JsonElement elem : element.getAsJsonArray()) {
                if (!RecipeManagerMixin.knightlib$hasItem(elem, target)) continue;
                return true;
            }
        }
        return false;
    }

    @Unique
    private static String knightlib$first(JsonObject object, String ... keys) {
        for (String key : keys) {
            if (!object.has(key)) continue;
            try {
                return GsonHelper.m_13906_((JsonObject)object, (String)key);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Unique
    private static JsonElement knightlib$get(JsonObject jsonObject, String key) {
        if (jsonObject == null) {
            return null;
        }
        return jsonObject.get(key);
    }

    @Unique
    private static JsonObject knightlib$getObject(JsonObject jsonObject, String key) {
        JsonElement jsonElement = RecipeManagerMixin.knightlib$get(jsonObject, key);
        if (jsonElement != null && jsonElement.isJsonObject()) {
            return jsonElement.getAsJsonObject();
        }
        return null;
    }

    @Unique
    private static JsonArray knightlib$getArray(JsonObject jsonObject, String key) {
        JsonElement jsonElement = RecipeManagerMixin.knightlib$get(jsonObject, key);
        if (jsonElement != null && jsonElement.isJsonArray()) {
            return jsonElement.getAsJsonArray();
        }
        return null;
    }
}

