/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightlib.compat.jei;

import dev.xylonity.knightlib.common.recipe.ChaliceFillingRecipe;
import dev.xylonity.knightlib.common.recipe.GreatChaliceRecipe;
import dev.xylonity.knightlib.compat.jei.ChaliceFillingRecipeCategory;
import dev.xylonity.knightlib.compat.jei.GreatChaliceRecipeCategory;
import dev.xylonity.knightlib.registry.KnightLibBlocks;
import dev.xylonity.knightlib.registry.KnightLibItems;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public final class KnightLibPlugin
implements IModPlugin {
    private static final ResourceLocation UID = new ResourceLocation("knightlib", "jei_plugin");

    @NotNull
    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerCategories(IRecipeCategoryRegistration reg) {
        reg.addRecipeCategories(new IRecipeCategory[]{new GreatChaliceRecipeCategory(reg.getJeiHelpers().getGuiHelper())});
        reg.addRecipeCategories(new IRecipeCategory[]{new ChaliceFillingRecipeCategory(reg.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration reg) {
        reg.addRecipes(GreatChaliceRecipeCategory.TYPE, List.of(new GreatChaliceRecipe()));
        reg.addRecipes(ChaliceFillingRecipeCategory.TYPE, List.of(new ChaliceFillingRecipe(new ItemStack((ItemLike)KnightLibItems.SMALL_ESSENCE.get()), new ItemStack((ItemLike)KnightLibBlocks.GREAT_CHALICE.get())), new ChaliceFillingRecipe(new ItemStack((ItemLike)KnightLibItems.GREAT_ESSENCE.get()), new ItemStack((ItemLike)KnightLibBlocks.GREAT_CHALICE.get()))));
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration reg) {
        reg.addRecipeCatalyst(new ItemStack((ItemLike)KnightLibBlocks.GREAT_CHALICE.get()), new RecipeType[]{GreatChaliceRecipeCategory.TYPE});
        reg.addRecipeCatalyst(new ItemStack((ItemLike)KnightLibBlocks.GREAT_CHALICE.get()), new RecipeType[]{ChaliceFillingRecipeCategory.TYPE});
    }
}

