/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.util;

import java.util.Collection;
import java.util.List;
import me.pepperbell.continuity.client.ContinuityClient;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.MaterialFinder;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.model.SpriteFinder;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourceReloadListenerKeys;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public final class RenderUtil {
    private static final BlockColors BLOCK_COLORS = Minecraft.m_91087_().m_91298_();
    private static final ModelManager MODEL_MANAGER = Minecraft.m_91087_().m_91304_();
    private static final ThreadLocal<MaterialFinder> MATERIAL_FINDER = ThreadLocal.withInitial(() -> RendererAccess.INSTANCE.getRenderer().materialFinder());
    private static SpriteFinder blockAtlasSpriteFinder;

    public static int getTintColor(@Nullable BlockState state, BlockAndTintGetter blockView, BlockPos pos, int tintIndex) {
        if (state == null || tintIndex == -1) {
            return -1;
        }
        return 0xFF000000 | BLOCK_COLORS.m_92577_(state, blockView, pos, tintIndex);
    }

    public static RenderMaterial findOverlayMaterial(BlendMode blendMode, @Nullable BlockState tintBlock) {
        MaterialFinder finder = RenderUtil.getMaterialFinder();
        finder.blendMode(blendMode);
        if (tintBlock != null) {
            finder.ambientOcclusion(TriState.of((boolean)RenderUtil.canHaveAO(tintBlock)));
        } else {
            finder.ambientOcclusion(TriState.TRUE);
        }
        return finder.find();
    }

    public static boolean canHaveAO(BlockState state) {
        return state.m_60791_() == 0;
    }

    public static MaterialFinder getMaterialFinder() {
        return MATERIAL_FINDER.get().clear();
    }

    public static SpriteFinder getSpriteFinder() {
        return blockAtlasSpriteFinder;
    }

    public static class ReloadListener
    implements SimpleSynchronousResourceReloadListener {
        public static final ResourceLocation ID = ContinuityClient.asId("render_util");
        public static final List<ResourceLocation> DEPENDENCIES = List.of(ResourceReloadListenerKeys.MODELS);
        private static final ReloadListener INSTANCE = new ReloadListener();

        public static void init() {
            ResourceManagerHelper.get((PackType)PackType.CLIENT_RESOURCES).registerReloadListener((IdentifiableResourceReloadListener)INSTANCE);
        }

        public void m_6213_(ResourceManager manager) {
            blockAtlasSpriteFinder = SpriteFinder.get((TextureAtlas)MODEL_MANAGER.m_119428_(TextureAtlas.f_118259_));
        }

        public ResourceLocation getFabricId() {
            return ID;
        }

        public Collection<ResourceLocation> getFabricDependencies() {
            return DEPENDENCIES;
        }
    }
}

