/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.resource;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import me.pepperbell.continuity.client.mixinterface.ModelLoaderExtension;
import me.pepperbell.continuity.client.model.QuadProcessors;
import me.pepperbell.continuity.client.resource.CtmPropertiesLoader;
import me.pepperbell.continuity.client.resource.EmissiveSuffixLoader;
import me.pepperbell.continuity.client.resource.ModelWrappingHandler;
import me.pepperbell.continuity.client.resource.SpriteLoaderLoadContext;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.AtlasSet;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.Nullable;

public class BakedModelManagerReloadExtension {
    private final CompletableFuture<CtmPropertiesLoader.LoadingResult> ctmLoadingResultFuture;
    private final AtomicBoolean wrapEmissiveModels = new AtomicBoolean();
    private final SpriteLoaderLoadContextImpl spriteLoaderLoadContext;
    private volatile List<QuadProcessors.ProcessorHolder> processorHolders;

    public BakedModelManagerReloadExtension(ResourceManager resourceManager, Executor prepareExecutor) {
        this.ctmLoadingResultFuture = CompletableFuture.supplyAsync(() -> CtmPropertiesLoader.loadAllWithState(resourceManager), prepareExecutor);
        this.spriteLoaderLoadContext = new SpriteLoaderLoadContextImpl((CompletableFuture<Map<ResourceLocation, Set<ResourceLocation>>>)this.ctmLoadingResultFuture.thenApply(CtmPropertiesLoader.LoadingResult::getTextureDependencies), this.wrapEmissiveModels);
        EmissiveSuffixLoader.load(resourceManager);
    }

    public void setContext() {
        SpriteLoaderLoadContext.THREAD_LOCAL.set(this.spriteLoaderLoadContext);
    }

    public void clearContext() {
        SpriteLoaderLoadContext.THREAD_LOCAL.set(null);
    }

    public void beforeBaking(Map<ResourceLocation, AtlasSet.StitchResult> preparations, ModelBakery modelLoader) {
        CtmPropertiesLoader.LoadingResult result = this.ctmLoadingResultFuture.join();
        List<QuadProcessors.ProcessorHolder> processorHolders = result.createProcessorHolders(spriteId -> {
            AtlasSet.StitchResult preparation = (AtlasSet.StitchResult)preparations.get(spriteId.m_119193_());
            TextureAtlasSprite sprite = preparation.m_245551_(spriteId.m_119203_());
            if (sprite != null) {
                return sprite;
            }
            return preparation.m_247223_();
        });
        this.processorHolders = processorHolders;
        ModelWrappingHandler wrappingHandler = ModelWrappingHandler.create(!processorHolders.isEmpty(), this.wrapEmissiveModels.get());
        ((ModelLoaderExtension)modelLoader).continuity$setModelWrappingHandler(wrappingHandler);
    }

    public void apply() {
        List<QuadProcessors.ProcessorHolder> processorHolders = this.processorHolders;
        if (processorHolders != null) {
            QuadProcessors.reload(processorHolders);
        }
    }

    private static class SpriteLoaderLoadContextImpl
    implements SpriteLoaderLoadContext {
        private final CompletableFuture<Map<ResourceLocation, Set<ResourceLocation>>> allExtraIdsFuture;
        private final Map<ResourceLocation, CompletableFuture<Set<ResourceLocation>>> extraIdsFutures = new Object2ObjectOpenHashMap();
        private final SpriteLoaderLoadContext.EmissiveControl blockAtlasEmissiveControl;

        public SpriteLoaderLoadContextImpl(CompletableFuture<Map<ResourceLocation, Set<ResourceLocation>>> allExtraIdsFuture, AtomicBoolean blockAtlasHasEmissivesHolder) {
            this.allExtraIdsFuture = allExtraIdsFuture;
            this.blockAtlasEmissiveControl = new EmissiveControlImpl(blockAtlasHasEmissivesHolder);
        }

        @Override
        public CompletableFuture<@Nullable Set<ResourceLocation>> getExtraIdsFuture(ResourceLocation atlasId) {
            return this.extraIdsFutures.computeIfAbsent(atlasId, id -> this.allExtraIdsFuture.thenApply(allExtraIds -> (Set)allExtraIds.get(id)));
        }

        @Override
        @Nullable
        public SpriteLoaderLoadContext.EmissiveControl getEmissiveControl(ResourceLocation atlasId) {
            if (atlasId.equals((Object)TextureAtlas.f_118259_)) {
                return this.blockAtlasEmissiveControl;
            }
            return null;
        }

        private static class EmissiveControlImpl
        implements SpriteLoaderLoadContext.EmissiveControl {
            @Nullable
            private volatile Map<ResourceLocation, ResourceLocation> emissiveIdMap;
            private final AtomicBoolean hasEmissivesHolder;

            public EmissiveControlImpl(AtomicBoolean hasEmissivesHolder) {
                this.hasEmissivesHolder = hasEmissivesHolder;
            }

            @Override
            @Nullable
            public Map<ResourceLocation, ResourceLocation> getEmissiveIdMap() {
                return this.emissiveIdMap;
            }

            @Override
            public void setEmissiveIdMap(Map<ResourceLocation, ResourceLocation> emissiveIdMap) {
                this.emissiveIdMap = emissiveIdMap;
            }

            @Override
            public void markHasEmissives() {
                this.hasEmissivesHolder.set(true);
            }
        }
    }
}

