/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.world;

import eu.ha3.presencefootsteps.compat.ContraptionCollidable;
import eu.ha3.presencefootsteps.sound.SoundEngine;
import eu.ha3.presencefootsteps.util.PlayerUtil;
import eu.ha3.presencefootsteps.world.Association;
import eu.ha3.presencefootsteps.world.AssociationPool;
import eu.ha3.presencefootsteps.world.Solver;
import eu.ha3.presencefootsteps.world.SoundsKey;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PFSolver
implements Solver {
    private static final double TRAP_DOOR_OFFSET = 0.1;
    private final SoundEngine engine;
    private long lastUpdateTime;
    private final Long2ObjectOpenHashMap<Association> associationCache = new Long2ObjectOpenHashMap();

    public PFSolver(SoundEngine engine) {
        this.engine = engine;
    }

    private BlockState getBlockStateAt(Entity entity, BlockPos pos) {
        Level world = entity.m_9236_();
        BlockState state = world.m_8055_(pos);
        if (state.m_60795_() && entity instanceof ContraptionCollidable) {
            ContraptionCollidable collidable = (ContraptionCollidable)entity;
            state = collidable.getCollidedStateAt(pos);
        }
        return state.getAppearance((BlockAndTintGetter)world, pos, Direction.UP, state, pos);
    }

    private AABB getCollider(Entity player) {
        AABB collider = player.m_20191_();
        collider = collider.m_82386_(0.0, -(collider.f_82289_ - Math.floor(collider.f_82289_)), 0.0);
        double expansionRatio = 0.1;
        collider = collider.m_82400_(expansionRatio);
        if (player.m_20142_()) {
            collider = collider.m_82377_(0.3, 0.5, 0.3);
        }
        return collider;
    }

    private boolean checkCollision(Level world, BlockState state, BlockPos pos, AABB collider) {
        VoxelShape shape = state.m_60812_((BlockGetter)world, pos);
        if (shape.m_83281_()) {
            shape = state.m_60808_((BlockGetter)world, pos);
        }
        return shape.m_83281_() || shape.m_83215_().m_82338_(pos).m_82381_(collider);
    }

    @Override
    public Association findAssociation(AssociationPool associations, LivingEntity ply, BlockPos pos, String strategy) {
        if (!"find_messy_foliage".equals(strategy)) {
            return Association.NOT_EMITTER;
        }
        pos = pos.m_7494_();
        BlockState above = this.getBlockStateAt((Entity)ply, pos);
        SoundsKey foliage = this.engine.getIsolator().blocks().getAssociation(above, "foliage");
        if (foliage.isEmitter() && this.engine.getIsolator().blocks().getAssociation(above, "messy") == SoundsKey.MESSY_GROUND) {
            return Association.of(above, pos, ply, SoundsKey.NON_EMITTER, SoundsKey.NON_EMITTER, foliage);
        }
        return Association.NOT_EMITTER;
    }

    @Override
    public Association findAssociation(AssociationPool associations, LivingEntity ply, double verticalOffsetAsMinus, boolean isRightFoot) {
        Association cached;
        Vec3 vel;
        double rot = Math.toRadians(Mth.m_14177_((float)ply.m_146908_()));
        Vec3 pos = ply.m_20182_();
        float feetDistanceToCenter = 0.2f * (float)(isRightFoot ? -1 : 1) * PlayerUtil.getScale(ply);
        BlockPos footPos = BlockPos.m_274561_((double)(pos.f_82479_ + Math.cos(rot) * (double)feetDistanceToCenter), (double)(ply.m_20191_().m_82340_(Direction.Axis.Y) - 0.1 - verticalOffsetAsMinus), (double)(pos.f_82481_ + Math.sin(rot) * (double)feetDistanceToCenter));
        if (!(ply instanceof RemotePlayer) && (vel = ply.m_20184_()).m_82556_() != 0.0 && Math.abs(vel.f_82480_) < 0.004) {
            return Association.NOT_EMITTER;
        }
        long time = ply.m_9236_().m_46467_();
        if (time != this.lastUpdateTime) {
            this.lastUpdateTime = time;
            this.associationCache.clear();
        }
        if ((cached = (Association)this.associationCache.get(footPos.m_121878_())) != null) {
            return cached;
        }
        AABB collider = this.getCollider((Entity)ply);
        BlockPos.MutableBlockPos mutableFootPos = footPos.m_122032_();
        if (feetDistanceToCenter > 1.0f) {
            for (BlockPos underfootPos : BlockPos.m_121925_((BlockPos)footPos, (int)((int)feetDistanceToCenter), (int)2, (int)((int)feetDistanceToCenter))) {
                mutableFootPos.m_122190_((Vec3i)underfootPos);
                Association assos = this.findAssociation(associations, ply, collider, underfootPos, mutableFootPos);
                if (!assos.isResult()) continue;
                this.associationCache.put(footPos.m_121878_(), (Object)assos);
                return assos;
            }
        }
        Association assos = this.findAssociation(associations, ply, collider, footPos, mutableFootPos);
        this.associationCache.put(footPos.m_121878_(), (Object)assos);
        return assos;
    }

    private Association findAssociation(AssociationPool associations, LivingEntity player, AABB collider, BlockPos originalFootPos, BlockPos.MutableBlockPos pos) {
        Association association;
        if (this.engine.getConfig().isVisualiserRunning()) {
            for (int i = 0; i < 10; ++i) {
                player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123776_, (double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
            }
        }
        if ((association = this.findAssociation(associations, player, pos, collider)).isResult() && !association.state().m_278721_()) {
            if (this.engine.getConfig().isVisualiserRunning()) {
                player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123796_, (double)association.pos().m_123341_() + 0.5, (double)association.pos().m_123342_() + 0.9, (double)association.pos().m_123343_() + 0.5, 0.0, 0.0, 0.0);
            }
            return association;
        }
        double radius = 0.4;
        int[] xValues = new int[]{Mth.m_14107_((double)(collider.m_82340_(Direction.Axis.X) - radius)), pos.m_123341_(), Mth.m_14107_((double)(collider.m_82374_(Direction.Axis.X) + radius))};
        int[] zValues = new int[]{Mth.m_14107_((double)(collider.m_82340_(Direction.Axis.Z) - radius)), pos.m_123343_(), Mth.m_14107_((double)(collider.m_82374_(Direction.Axis.Z) + radius))};
        for (int x : xValues) {
            for (int z : zValues) {
                if (x == originalFootPos.m_123341_() && z == originalFootPos.m_123343_()) continue;
                pos.m_122178_(x, originalFootPos.m_123342_(), z);
                if (this.engine.getConfig().isVisualiserRunning()) {
                    for (int i = 0; i < 10; ++i) {
                        player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123776_, (double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5, 0.0, 0.0, 0.0);
                    }
                }
                if (!(association = this.findAssociation(associations, player, pos, collider)).isResult() || association.state().m_278721_()) continue;
                if (this.engine.getConfig().isVisualiserRunning()) {
                    player.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123796_, (double)association.pos().m_123341_() + 0.5, (double)association.pos().m_123342_() + 0.9, (double)association.pos().m_123343_() + 0.5, 0.0, 0.0, 0.0);
                }
                return association;
            }
        }
        pos.m_122190_((Vec3i)originalFootPos);
        BlockState state = this.getBlockStateAt((Entity)player, (BlockPos)pos);
        if (state.m_278721_()) {
            if (state.m_60819_().m_205070_(FluidTags.f_13132_)) {
                return Association.of(state, pos.m_7495_(), player, SoundsKey.LAVAFINE, SoundsKey.NON_EMITTER, SoundsKey.NON_EMITTER);
            }
            return Association.of(state, pos.m_7495_(), player, SoundsKey.WATERFINE, SoundsKey.NON_EMITTER, SoundsKey.NON_EMITTER);
        }
        return association;
    }

    private Association findAssociation(AssociationPool associations, LivingEntity entity, BlockPos.MutableBlockPos pos, AABB collider) {
        associations.reset();
        BlockState target = this.getBlockStateAt((Entity)entity, (BlockPos)pos);
        pos.m_122173_(Direction.UP);
        boolean hasRain = entity.m_9236_().m_46758_((BlockPos)pos);
        BlockState carpet = this.getBlockStateAt((Entity)entity, (BlockPos)pos);
        VoxelShape shape = carpet.m_60808_((BlockGetter)entity.m_9236_(), (BlockPos)pos);
        boolean isValidCarpet = !shape.m_83281_() && shape.m_83297_(Direction.Axis.Y) < (double)0.3f;
        SoundsKey association = SoundsKey.UNASSIGNED;
        SoundsKey foliage = SoundsKey.UNASSIGNED;
        SoundsKey wetAssociation = SoundsKey.UNASSIGNED;
        if (isValidCarpet && (association = associations.get((BlockPos)pos, carpet, "carpet")).isEmitter() && !association.isSilent()) {
            target = carpet;
        } else {
            association = SoundsKey.UNASSIGNED;
            pos.m_122173_(Direction.DOWN);
            if (target.m_60795_()) {
                pos.m_122173_(Direction.DOWN);
                BlockState fence = this.getBlockStateAt((Entity)entity, (BlockPos)pos);
                if (this.checkCollision(entity.m_9236_(), fence, (BlockPos)pos, collider)) {
                    association = associations.get((BlockPos)pos, fence, "bigger");
                    if (association.isResult()) {
                        carpet = target;
                        target = fence;
                    } else {
                        pos.m_122173_(Direction.UP);
                    }
                }
            }
            if (!association.isResult()) {
                association = associations.get((BlockPos)pos, target, "");
            }
            if (this.engine.getConfig().foliageSoundsVolume.get() > 0 && (entity.m_6844_(EquipmentSlot.FEET).m_41619_() || entity.m_20142_()) && association.isEmitter() && carpet.m_60812_((BlockGetter)entity.m_9236_(), (BlockPos)pos).m_83281_()) {
                pos.m_122173_(Direction.UP);
                foliage = associations.get((BlockPos)pos, carpet, "foliage");
                pos.m_122173_(Direction.DOWN);
            }
        }
        if (association.isResult() && !this.checkCollision(entity.m_9236_(), target, (BlockPos)pos, collider)) {
            association = SoundsKey.UNASSIGNED;
        }
        if (association.isEmitter() && (hasRain || !associations.wasLastMatchGolem() && (target.m_60819_().m_205070_(FluidTags.f_13131_) && !target.m_60783_((BlockGetter)entity.m_9236_(), (BlockPos)pos, Direction.UP) || carpet.m_60819_().m_205070_(FluidTags.f_13131_) && !carpet.m_60783_((BlockGetter)entity.m_9236_(), (BlockPos)pos, Direction.UP)))) {
            wetAssociation = associations.get((BlockPos)pos, target, "wet");
        }
        return Association.of(target, (BlockPos)pos, entity, association, wetAssociation, foliage);
    }
}

