/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.world;

import eu.ha3.presencefootsteps.world.SoundsKey;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public record Association(BlockState state, BlockPos pos, @Nullable LivingEntity source, SoundsKey dry, SoundsKey wet, SoundsKey foliage) {
    public static final Association NOT_EMITTER = new Association(Blocks.f_50016_.m_49966_(), BlockPos.f_121853_, null, SoundsKey.NON_EMITTER, SoundsKey.NON_EMITTER, SoundsKey.NON_EMITTER);

    public static Association of(BlockState state, BlockPos pos, LivingEntity source, SoundsKey dry, SoundsKey wet, SoundsKey foliage) {
        if (dry.isSilent() && wet.isSilent() && foliage.isSilent()) {
            return NOT_EMITTER;
        }
        return new Association(state, pos.m_7949_(), source, dry, wet, foliage);
    }

    public boolean isResult() {
        return this.dry.isResult() || this.wet.isResult() || this.foliage.isResult();
    }

    public boolean isSilent() {
        return this == NOT_EMITTER || this.state.m_60795_();
    }

    public boolean dataEquals(Association other) {
        return Objects.equals(this.dry, other.dry);
    }
}

