/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import eu.ha3.presencefootsteps.util.JsonObjectWriter;
import eu.ha3.presencefootsteps.util.MathUtil;
import java.io.IOException;
import java.util.Random;
import net.minecraft.util.Mth;

public record Range(float min, float max) {
    public static final Range DEFAULT = Range.exactly(1.0f);

    public static Range exactly(float value) {
        return new Range(value, value);
    }

    public Range read(String name, JsonObject json) {
        if ("volume".equals(name) && (json.has("vol") || json.has("vol_min") || json.has("vol_max"))) {
            return this.read("vol", json);
        }
        if (json.has(name)) {
            JsonElement element = json.get(name);
            if (element.isJsonObject()) {
                return new Range(Range.getPercentage(element.getAsJsonObject(), "min", this.min), Range.getPercentage(element.getAsJsonObject(), "max", this.max));
            }
            return Range.exactly(Range.getPercentage(json, name, this.min));
        }
        return new Range(Range.getPercentage(json, name + "_min", this.min), Range.getPercentage(json, name + "_max", this.max));
    }

    public void write(JsonObjectWriter writer) throws IOException {
        if (Mth.m_14033_((float)this.min, (float)this.max)) {
            writer.writer().value(this.min * 100.0f);
        } else {
            writer.object(() -> {
                writer.field("min", this.min * 100.0f);
                writer.field("max", this.max * 100.0f);
            });
        }
    }

    public float random(Random rand) {
        return MathUtil.randAB(rand, this.min, this.max);
    }

    public float on(float value) {
        return MathUtil.between(this.min, this.max, value);
    }

    private static float getPercentage(JsonObject object, String param, float fallback) {
        if (!object.has(param)) {
            return fallback;
        }
        return object.get(param).getAsFloat() / 100.0f;
    }
}

