/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.util;

import com.google.gson.stream.JsonWriter;
import com.minelittlepony.common.util.GamePaths;
import eu.ha3.presencefootsteps.util.JsonObjectWriter;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.SoundType;

public interface BlockReport {
    public static CompletableFuture<?> execute(Reportable reportable, String baseName, boolean full) {
        Minecraft client = Minecraft.m_91087_();
        ChatComponent hud = client.f_91065_.m_93076_();
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            try {
                Path loc = BlockReport.getUniqueFileName(GamePaths.getGameDirectory().resolve("presencefootsteps"), baseName, ".json");
                Files.createDirectories(loc.getParent(), new FileAttribute[0]);
                try (JsonObjectWriter writer = JsonObjectWriter.of(new JsonWriter((Writer)Files.newBufferedWriter(loc, new OpenOption[0])));){
                    reportable.writeToReport(full, writer, (Map<String, SoundType>)new Object2ObjectOpenHashMap());
                }
                return loc;
            }
            catch (IOException e) {
                throw new RuntimeException("Could not generate report", e);
            }
        }, Util.m_183992_()).thenAcceptAsync(loc -> hud.m_93785_((Component)Component.m_237110_((String)"pf.report.save", (Object[])new Object[]{Component.m_237113_((String)loc.getFileName().toString()).m_130938_(s -> s.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, loc.toString())).m_131157_(ChatFormatting.UNDERLINE))}).m_130938_(s -> s.m_131140_(ChatFormatting.GREEN))), (Executor)client)).exceptionallyAsync(e -> {
            hud.m_93785_((Component)Component.m_237110_((String)"pf.report.error", (Object[])new Object[]{e.getMessage()}).m_130938_(s -> s.m_131140_(ChatFormatting.RED)));
            return null;
        }, (Executor)client);
    }

    private static Path getUniqueFileName(Path directory, String baseName, String ext) {
        Path loc = null;
        int counter = 0;
        while (loc == null || Files.exists(loc, new LinkOption[0])) {
            loc = directory.resolve(baseName + (String)(counter == 0 ? "" : "_" + counter) + ext);
            ++counter;
        }
        return loc;
    }

    public static interface Reportable {
        public void writeToReport(boolean var1, JsonObjectWriter var2, Map<String, SoundType> var3) throws IOException;
    }
}

