/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound.generator;

import eu.ha3.presencefootsteps.config.Variator;
import eu.ha3.presencefootsteps.sound.Options;
import eu.ha3.presencefootsteps.sound.SoundEngine;
import eu.ha3.presencefootsteps.sound.State;
import eu.ha3.presencefootsteps.sound.generator.Modifier;
import eu.ha3.presencefootsteps.sound.generator.TerrestrialStepSoundGenerator;
import eu.ha3.presencefootsteps.util.MathUtil;
import eu.ha3.presencefootsteps.world.SoundsKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

class WingedStepSoundGenerator
extends TerrestrialStepSoundGenerator {
    private static final SoundsKey SWIFT = SoundsKey.of("_SWIFT");
    private static final SoundsKey WING = SoundsKey.of("_WING");
    protected boolean isFalling = false;
    protected FlightState state = FlightState.IDLE;
    protected int flapMod = 0;
    private long lastTimeImmobile;
    protected long nextFlapTime;

    public WingedStepSoundGenerator(LivingEntity entity, SoundEngine engine, Modifier<TerrestrialStepSoundGenerator> modifier) {
        super(entity, engine, modifier);
    }

    @Override
    public void generateFootsteps() {
        this.lastTimeImmobile = this.timeImmobile;
        super.generateFootsteps();
    }

    @Override
    protected void simulateAirborne() {
        this.isFalling = this.motionTracker.getMotionY() < -0.3;
        super.simulateAirborne();
        if (this.isAirborne) {
            this.simulateFlying();
        }
    }

    @Override
    protected boolean updateImmobileState(float reference) {
        if (this.isAirborne) {
            Vec3 vel = this.entity.m_20184_();
            boolean stationary = vel.f_82479_ != 0.0 && vel.f_82481_ != 0.0;
            this.lastReference = reference;
            if (!this.isImmobile && stationary) {
                this.timeImmobile = System.currentTimeMillis();
                this.isImmobile = true;
            } else if (this.isImmobile && !stationary) {
                this.isImmobile = false;
                return System.currentTimeMillis() - this.timeImmobile > (long)this.engine.getIsolator().variator().IMMOBILE_DURATION;
            }
            return false;
        }
        return super.updateImmobileState(reference);
    }

    protected int getWingSpeed() {
        Variator variator = this.engine.getIsolator().variator();
        return switch (this.state) {
            case FlightState.COASTING -> {
                if (this.flapMod == 0) {
                    yield variator.WING_SPEED_COAST;
                }
                yield variator.WING_SPEED_NORMAL * this.flapMod;
            }
            case FlightState.COASTING_STRAFING -> variator.WING_SPEED_NORMAL * (1 + this.flapMod);
            case FlightState.DASHING -> variator.WING_SPEED_RAPID;
            case FlightState.ASCENDING, FlightState.FLYING -> variator.WING_SPEED_NORMAL;
            default -> variator.WING_SPEED_IDLE;
        };
    }

    @Override
    protected void simulateJumpingLanding() {
        boolean speedingJumpStateChange;
        if (this.hasStoppingConditions()) {
            return;
        }
        long now = System.currentTimeMillis();
        float speed = (float)Math.sqrt(this.motionTracker.getHorizontalSpeed());
        Variator variator = this.engine.getIsolator().variator();
        if (this.isAirborne) {
            this.nextFlapTime = now + (long)variator.WING_JUMPING_REST_TIME;
        }
        boolean hugeLanding = !this.isAirborne && this.lastFallDistance > variator.HUGEFALL_LANDING_DISTANCE_MIN;
        boolean bl = speedingJumpStateChange = speed > variator.MIN_MOTION_HOR;
        if (hugeLanding || speedingJumpStateChange) {
            if (!this.isAirborne) {
                float volume = speedingJumpStateChange ? 2.0f : MathUtil.scalex(this.lastFallDistance, variator.HUGEFALL_LANDING_DISTANCE_MIN, variator.HUGEFALL_LANDING_DISTANCE_MAX);
                this.engine.getIsolator().acoustics().playAcoustic(this.entity, SWIFT, State.LAND, Options.singular("gliding_volume", volume));
            } else {
                this.engine.getIsolator().acoustics().playAcoustic(this.entity, SWIFT, State.JUMP, Options.EMPTY);
            }
        }
        if (this.isAirborne && this.isJumping()) {
            this.simulateJumping();
        } else if (!this.isAirborne && hugeLanding) {
            this.simulateLanding();
        }
    }

    protected void simulateFlying() {
        long now = System.currentTimeMillis();
        Variator variator = this.engine.getIsolator().variator();
        if (this.updateState(this.motionTracker.getHorizontalSpeed(), this.motionTracker.getMotionY(), this.entity.f_20900_)) {
            this.nextFlapTime = now + (long)variator.FLIGHT_TRANSITION_TIME;
        }
        if (!this.entity.m_5842_() && !this.isFalling && now > this.nextFlapTime) {
            this.nextFlapTime = now + (long)this.getWingSpeed() + (long)(this.entity.m_9236_().f_46441_.m_188503_(100) - 50);
            this.flapMod = (this.flapMod + 1) % (1 + this.entity.m_9236_().f_46441_.m_188503_(4));
            float volume = 1.0f;
            long diffImmobile = now - this.lastTimeImmobile;
            if (diffImmobile > (long)variator.WING_IMMOBILE_FADE_START) {
                volume -= MathUtil.scalex(diffImmobile, variator.WING_IMMOBILE_FADE_START, variator.WING_IMMOBILE_FADE_START + variator.WING_IMMOBILE_FADE_DURATION);
            }
            this.engine.getIsolator().acoustics().playAcoustic(this.entity, WING, State.WALK, Options.singular("gliding_volume", volume));
        }
    }

    protected boolean updateState(double horSpeed, double verticalSpeed, double strafe) {
        float motionHor = (float)Math.sqrt(horSpeed);
        FlightState result = FlightState.IDLE;
        Variator variator = this.engine.getIsolator().variator();
        if (motionHor > variator.MIN_DASH_MOTION) {
            result = FlightState.DASHING;
        } else if (motionHor > variator.MIN_COAST_MOTION && (float)Math.abs(verticalSpeed) < variator.MIN_COAST_MOTION / 20.0f) {
            result = strafe > (double)variator.MIN_MOTION_Y ? FlightState.COASTING_STRAFING : FlightState.COASTING;
        } else if (motionHor > variator.MIN_MOTION_HOR) {
            result = FlightState.FLYING;
        } else if (verticalSpeed < 0.0) {
            result = FlightState.DESCENDING;
        } else if ((float)verticalSpeed > variator.MIN_MOTION_Y) {
            result = FlightState.ASCENDING;
        }
        boolean changed = result != this.state;
        this.state = result;
        return changed;
    }

    private static enum FlightState {
        DASHING,
        COASTING,
        COASTING_STRAFING,
        FLYING,
        IDLE,
        ASCENDING,
        DESCENDING;

    }
}

