/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound.generator;

import eu.ha3.presencefootsteps.sound.SoundEngine;
import eu.ha3.presencefootsteps.sound.generator.MineLP;
import eu.ha3.presencefootsteps.sound.generator.Modifier;
import eu.ha3.presencefootsteps.sound.generator.QuadrupedModifier;
import eu.ha3.presencefootsteps.sound.generator.StepSoundGenerator;
import eu.ha3.presencefootsteps.sound.generator.TerrestrialStepSoundGenerator;
import eu.ha3.presencefootsteps.sound.generator.WingedStepSoundGenerator;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public enum Locomotion {
    NONE,
    BIPED((entity, engine) -> new TerrestrialStepSoundGenerator((LivingEntity)entity, (SoundEngine)engine, new Modifier<TerrestrialStepSoundGenerator>())),
    QUADRUPED((entity, engine) -> new TerrestrialStepSoundGenerator((LivingEntity)entity, (SoundEngine)engine, new QuadrupedModifier())),
    FLYING((entity, engine) -> new WingedStepSoundGenerator((LivingEntity)entity, (SoundEngine)engine, new QuadrupedModifier())),
    FLYING_BIPED((entity, engine) -> new WingedStepSoundGenerator((LivingEntity)entity, (SoundEngine)engine, new Modifier<TerrestrialStepSoundGenerator>()));

    private static final Map<String, Locomotion> registry;
    private final BiFunction<LivingEntity, SoundEngine, Optional<StepSoundGenerator>> constructor;
    private static final String AUTO_TRANSLATION_KEY = "menu.pf.stance.auto";
    private final String translationKey = "menu.pf.stance." + this.name().toLowerCase(Locale.ROOT);

    private Locomotion() {
        this.constructor = (entity, engine) -> Optional.empty();
    }

    private Locomotion(BiFunction<LivingEntity, SoundEngine, StepSoundGenerator> gen) {
        this.constructor = (entity, engine) -> Optional.of((StepSoundGenerator)gen.apply((LivingEntity)entity, (SoundEngine)engine));
    }

    public Optional<StepSoundGenerator> supplyGenerator(LivingEntity entity, SoundEngine engine) {
        return this.constructor.apply(entity, engine);
    }

    public Component getOptionName() {
        return Component.m_237110_((String)"menu.pf.stance", (Object[])new Object[]{Component.m_237115_((String)(this == NONE ? AUTO_TRANSLATION_KEY : this.translationKey))});
    }

    public Component getOptionTooltip() {
        return Component.m_237115_((String)(this.translationKey + ".tooltip"));
    }

    public static Locomotion byName(String name) {
        return registry.getOrDefault(name, BIPED);
    }

    public static Locomotion forLiving(Entity entity, Locomotion fallback) {
        if (MineLP.hasPonies()) {
            return MineLP.getLocomotion(entity, fallback);
        }
        return fallback;
    }

    public static Locomotion forPlayer(Player ply, Locomotion preference) {
        if (preference == NONE) {
            if (ply instanceof LocalPlayer && MineLP.hasPonies()) {
                return MineLP.getLocomotion(ply);
            }
            return BIPED;
        }
        return preference;
    }

    static {
        registry = new Object2ObjectOpenHashMap();
        for (Locomotion i : Locomotion.values()) {
            registry.put(i.name(), i);
            registry.put(String.valueOf(i.ordinal()), i);
        }
    }
}

