/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound.acoustics;

import com.google.gson.JsonObject;
import eu.ha3.presencefootsteps.sound.Options;
import eu.ha3.presencefootsteps.sound.State;
import eu.ha3.presencefootsteps.sound.acoustics.Acoustic;
import eu.ha3.presencefootsteps.sound.acoustics.AcousticsFile;
import eu.ha3.presencefootsteps.sound.acoustics.EmptyAcoustic;
import eu.ha3.presencefootsteps.sound.player.SoundPlayer;
import eu.ha3.presencefootsteps.util.JsonObjectWriter;
import eu.ha3.presencefootsteps.util.Range;
import java.io.IOException;
import net.minecraft.world.entity.LivingEntity;

record VaryingAcoustic(String soundName, Range volume, Range pitch) implements Acoustic
{
    static final Acoustic.Serializer FACTORY = (json, context) -> {
        if (json.isJsonPrimitive()) {
            return new VaryingAcoustic(context.getSoundName(json.getAsString()), context.defaultVolume(), context.defaultPitch());
        }
        JsonObject jso = json.getAsJsonObject();
        if (!jso.has("name")) {
            return EmptyAcoustic.INSTANCE;
        }
        String name = jso.get("name").getAsString();
        if (name.isEmpty()) {
            return EmptyAcoustic.INSTANCE;
        }
        return new VaryingAcoustic(context.getSoundName(name), context.defaultVolume().read("volume", jso), context.defaultPitch().read("pitch", jso));
    };

    @Override
    public void playSound(SoundPlayer player, LivingEntity location, State event, Options inputOptions) {
        if (this.soundName.isEmpty()) {
            return;
        }
        float finalVolume = inputOptions.containsKey("gliding_volume") ? this.volume.on(inputOptions.get("gliding_volume")) : this.volume.random(player.getRNG());
        float finalPitch = inputOptions.containsKey("gliding_pitch") ? this.pitch.on(inputOptions.get("gliding_pitch")) : this.pitch.random(player.getRNG());
        player.playSound(location, this.soundName, finalVolume, finalPitch, inputOptions);
    }

    @Override
    public void write(AcousticsFile context, JsonObjectWriter writer) throws IOException {
        boolean hasPitch;
        boolean hasVolume = !this.volume.equals(context.defaultVolume());
        boolean bl = hasPitch = !this.pitch.equals(context.defaultPitch());
        if (hasVolume || hasPitch) {
            writer.object(() -> {
                if (this.soundName != null && !this.soundName.isEmpty()) {
                    writer.field("type", "basic");
                    writer.field("name", (String)(!context.soundRoot().isEmpty() && this.soundName.startsWith(context.soundRoot()) ? this.soundName.replace(context.soundRoot(), "") : "@" + this.soundName));
                    if (hasVolume) {
                        writer.field("volume", () -> this.volume.write(writer));
                    }
                    if (hasPitch) {
                        writer.field("pitch", () -> this.pitch.write(writer));
                    }
                }
            });
        } else {
            writer.writer().value((String)(!context.soundRoot().isEmpty() && this.soundName.startsWith(context.soundRoot()) ? this.soundName.replace(context.soundRoot(), "") : "@" + this.soundName));
        }
    }
}

