/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound.acoustics;

import eu.ha3.presencefootsteps.PresenceFootsteps;
import eu.ha3.presencefootsteps.sound.Options;
import eu.ha3.presencefootsteps.sound.State;
import eu.ha3.presencefootsteps.sound.acoustics.Acoustic;
import eu.ha3.presencefootsteps.sound.acoustics.AcousticLibrary;
import eu.ha3.presencefootsteps.sound.player.SoundPlayer;
import eu.ha3.presencefootsteps.world.Association;
import eu.ha3.presencefootsteps.world.SoundsKey;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;

public class AcousticsPlayer
implements AcousticLibrary {
    private final Map<String, Acoustic> acoustics = new Object2ObjectOpenHashMap();
    private final SoundPlayer soundPlayer;

    public AcousticsPlayer(SoundPlayer soundPlayer) {
        this.soundPlayer = soundPlayer;
    }

    @Override
    public void addAcoustic(String name, Acoustic acoustic) {
        if (this.acoustics.put(name, acoustic) != null) {
            PresenceFootsteps.logger.info("Duplicate acoustic: " + name);
        }
    }

    @Override
    public void playStep(Association association, State event, Options options) {
        if (association.isSilent()) {
            return;
        }
        if (association.dry().isResult()) {
            this.playAcoustic(association.source(), association.dry(), event, options);
        } else if (!association.state().m_278721_()) {
            SoundType soundType = association.state().m_60827_();
            BlockState above = association.source().m_9236_().m_8055_(association.pos().m_7494_());
            if (above.m_60713_(Blocks.f_50125_)) {
                soundType = above.m_60827_();
            }
            this.soundPlayer.playSound(association.source(), soundType.m_56776_().m_11660_().toString(), soundType.m_56773_() * 0.15f, soundType.m_56774_(), options);
        }
        if (association.wet().isEmitter() && Options.WET_VOLUME_OPTIONS.get("volume_percentage") > 0.1f) {
            this.playAcoustic(association.source(), association.wet(), event, options.and(Options.WET_VOLUME_OPTIONS));
        }
        if (association.foliage().isEmitter() && Options.FOLIAGE_VOLUME_OPTIONS.get("volume_percentage") > 0.1f) {
            this.playAcoustic(association.source(), association.foliage(), event, options.and(Options.FOLIAGE_VOLUME_OPTIONS));
        }
    }

    @Override
    public void playAcoustic(LivingEntity location, SoundsKey sounds, State event, Options inputOptions) {
        for (String acousticName : sounds.names()) {
            Acoustic acoustic = this.acoustics.get(acousticName);
            if (acoustic == null) {
                PresenceFootsteps.logger.warn("Tried to play a missing acoustic: " + acousticName);
                continue;
            }
            acoustic.playSound(this.soundPlayer, location, event, inputOptions);
        }
    }

    @Override
    public void think() {
        this.soundPlayer.think();
    }
}

