/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound.acoustics;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import eu.ha3.presencefootsteps.sound.Options;
import eu.ha3.presencefootsteps.sound.State;
import eu.ha3.presencefootsteps.sound.acoustics.AcousticsFile;
import eu.ha3.presencefootsteps.sound.acoustics.ChanceAcoustic;
import eu.ha3.presencefootsteps.sound.acoustics.DelayedAcoustic;
import eu.ha3.presencefootsteps.sound.acoustics.EventSelectorAcoustics;
import eu.ha3.presencefootsteps.sound.acoustics.SimultaneousAcoustic;
import eu.ha3.presencefootsteps.sound.acoustics.VaryingAcoustic;
import eu.ha3.presencefootsteps.sound.acoustics.WeightedAcoustic;
import eu.ha3.presencefootsteps.sound.player.SoundPlayer;
import eu.ha3.presencefootsteps.util.JsonObjectWriter;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.world.entity.LivingEntity;

public interface Acoustic {
    public static final Map<String, Serializer> FACTORIES = Object2ObjectMaps.unmodifiable((Object2ObjectMap)new Object2ObjectOpenHashMap((Object[])new String[]{"basic", "events", "simultaneous", "delayed", "probability", "chance"}, (Object[])new Serializer[]{VaryingAcoustic.FACTORY, EventSelectorAcoustics.FACTORY, SimultaneousAcoustic.FACTORY, DelayedAcoustic.FACTORY, WeightedAcoustic.FACTORY, ChanceAcoustic.FACTORY}));

    public static Acoustic read(AcousticsFile context, JsonElement unsolved) throws JsonParseException {
        return Acoustic.read(context, unsolved, "basic");
    }

    public static Acoustic read(AcousticsFile context, JsonElement json, String defaultUnassigned) throws JsonParseException {
        String type = Acoustic.getType(json, defaultUnassigned);
        return Acoustic.checked(Acoustic.checked(FACTORIES.get(type), () -> "Invalid type for acoustic `" + type + "`").create(json, context), () -> "Unresolved Json element: \r\n" + json.toString());
    }

    private static String getType(JsonElement unsolved, String defaultUnassigned) {
        if (unsolved.isJsonObject()) {
            JsonObject json = unsolved.getAsJsonObject();
            return json.has("type") ? json.get("type").getAsString() : defaultUnassigned;
        }
        if (unsolved.isJsonArray()) {
            return "simultaneous";
        }
        if (unsolved.isJsonPrimitive() && unsolved.getAsJsonPrimitive().isString()) {
            return "basic";
        }
        return "";
    }

    private static <T> T checked(T t, Supplier<String> message) throws JsonParseException {
        if (t == null) {
            throw new JsonParseException(message.get());
        }
        return t;
    }

    public void write(AcousticsFile var1, JsonObjectWriter var2) throws IOException;

    public void playSound(SoundPlayer var1, LivingEntity var2, State var3, Options var4);

    public static interface Serializer {
        public Acoustic create(JsonElement var1, AcousticsFile var2);

        public static Serializer ofJsObject(BiFunction<JsonObject, AcousticsFile, Acoustic> factory) {
            return (json, context) -> (Acoustic)factory.apply(json.getAsJsonObject(), context);
        }
    }
}

