/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound;

import eu.ha3.presencefootsteps.PresenceFootsteps;
import eu.ha3.presencefootsteps.sound.SoundEngine;
import eu.ha3.presencefootsteps.sound.generator.Locomotion;
import eu.ha3.presencefootsteps.sound.generator.StepSoundGenerator;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public interface StepSoundSource {
    public Optional<StepSoundGenerator> getStepGenerator(SoundEngine var1);

    public boolean isStepBlocked();

    public static final class Container
    implements StepSoundSource {
        private Locomotion locomotion;
        private Optional<StepSoundGenerator> stepSoundGenerator;
        private final LivingEntity entity;

        public Container(LivingEntity entity) {
            this.entity = entity;
        }

        @Override
        public Optional<StepSoundGenerator> getStepGenerator(SoundEngine engine) {
            Locomotion loco = engine.getIsolator().locomotions().lookup((Entity)this.entity);
            if (this.stepSoundGenerator == null || loco != this.locomotion) {
                this.locomotion = loco;
                this.stepSoundGenerator = loco.supplyGenerator(this.entity, engine);
            }
            return this.stepSoundGenerator;
        }

        @Override
        public boolean isStepBlocked() {
            SoundEngine engine = PresenceFootsteps.getInstance().getEngine();
            if (!engine.getConfig().isExclusiveMode() && !(this.entity instanceof Player)) {
                return false;
            }
            return engine.isEnabledFor((Entity)this.entity) && this.getStepGenerator(engine).isPresent();
        }
    }
}

