/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound;

import eu.ha3.presencefootsteps.PFConfig;
import eu.ha3.presencefootsteps.sound.Isolator;
import eu.ha3.presencefootsteps.sound.StepSoundSource;
import eu.ha3.presencefootsteps.sound.player.ImmediateSoundPlayer;
import eu.ha3.presencefootsteps.util.PlayerUtil;
import eu.ha3.presencefootsteps.world.PFSolver;
import eu.ha3.presencefootsteps.world.Solver;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import org.jetbrains.annotations.Nullable;

public class SoundEngine
implements IdentifiableResourceReloadListener {
    private static final ResourceLocation ID = new ResourceLocation("presencefootsteps", "sounds");
    private Isolator isolator = new Isolator(this);
    private final Solver solver = new PFSolver(this);
    final ImmediateSoundPlayer soundPlayer = new ImmediateSoundPlayer(this);
    private final PFConfig config;
    private boolean hasConfigurations;

    public SoundEngine(PFConfig config) {
        this.config = config;
    }

    public float getVolumeForSource(LivingEntity source) {
        float volume = (float)this.config.getGlobalVolume() / 100.0f;
        volume = source instanceof Player ? (PlayerUtil.isClientPlayer((Entity)source) ? (volume *= this.config.clientPlayerVolume.getPercentage()) : (volume *= this.config.otherPlayerVolume.getPercentage())) : (source instanceof Monster ? (volume *= this.config.hostileEntitiesVolume.getPercentage()) : (volume *= this.config.passiveEntitiesVolume.getPercentage()));
        float runningProgress = ((StepSoundSource)source).getStepGenerator(this).map(generator -> Float.valueOf(generator.getMotionTracker().getSpeedScalingRatio(source))).orElse(Float.valueOf(0.0f)).floatValue();
        return volume * (1.0f + (float)this.config.getRunningVolumeIncrease() / 100.0f * runningProgress);
    }

    public Isolator getIsolator() {
        return this.isolator;
    }

    public Solver getSolver() {
        return this.solver;
    }

    public PFConfig getConfig() {
        return this.config;
    }

    public void reload() {
        if (this.config.getEnabled()) {
            this.reloadEverything(Minecraft.m_91087_().m_91098_());
        } else {
            this.shutdown();
        }
    }

    public boolean isEnabledFor(Entity entity) {
        return this.hasData() && this.isRunning(Minecraft.m_91087_()) && this.config.getEntitySelector().test(entity);
    }

    public boolean hasData() {
        return this.hasConfigurations;
    }

    public boolean isRunning(Minecraft client) {
        return this.hasData() && !client.m_91104_() && this.config.getEnabled() && (client.m_91090_() || this.config.getEnabledMP());
    }

    private Stream<? extends Entity> getTargets(Entity cameraEntity) {
        List entities = cameraEntity.m_9236_().m_6249_(null, cameraEntity.m_20191_().m_82400_(16.0), e -> e instanceof LivingEntity && !(e instanceof WaterAnimal) && !(e instanceof FlyingMob) && !(e instanceof Shulker) && !(e instanceof ArmorStand) && !(e instanceof Boat) && !(e instanceof AbstractMinecart) && !this.isolator.golems().contains(e.m_6095_()) && !e.m_20159_() && !((LivingEntity)e).m_5803_() && (!(e instanceof Player) || !e.m_5833_()) && e.m_20280_(cameraEntity) <= 256.0 && this.config.getEntitySelector().test(e));
        Comparator<Entity> nearest = Comparator.comparingDouble(e -> e.m_20280_(cameraEntity));
        if (entities.size() < this.config.getMaxSteppingEntities()) {
            return entities.stream();
        }
        HashSet alreadyVisited = new HashSet();
        return entities.stream().sorted(nearest).filter(e -> e == cameraEntity || e instanceof Player || alreadyVisited.size() < this.config.getMaxSteppingEntities() && alreadyVisited.add(Objects.hash(e.m_6095_(), e.m_20183_())));
    }

    public void onFrame(Minecraft client, Entity cameraEntity) {
        if (this.isRunning(client)) {
            this.getTargets(cameraEntity).forEach(e -> {
                try {
                    ((StepSoundSource)e).getStepGenerator(this).ifPresent(generator -> generator.generateFootsteps());
                }
                catch (Throwable t) {
                    CrashReport report = CrashReport.m_127521_((Throwable)t, (String)"Generating PF sounds for entity");
                    CrashReportCategory section = report.m_127514_("Entity being ticked");
                    if (e == null) {
                        section.m_128159_("Entity Type", (Object)"null");
                    } else {
                        e.m_7976_(section);
                        section.m_128159_("Entity's Locomotion Type", (Object)this.isolator.locomotions().lookup((Entity)e));
                        section.m_128159_("Entity is Golem", (Object)this.isolator.golems().contains(e.m_6095_()));
                    }
                    this.config.populateCrashReport(report.m_127514_("PF Configuration"));
                    throw new ReportedException(report);
                }
            });
            this.isolator.acoustics().think();
        }
    }

    public boolean onSoundRecieved(@Nullable Holder<SoundEvent> event, SoundSource category) {
        return event != null && this.isRunning(Minecraft.m_91087_()) && event.m_203439_().right().filter(sound -> event == SoundEvents.f_12279_ || event == SoundEvents.f_12277_ || event == SoundEvents.f_12319_ || event == SoundEvents.f_12276_).isPresent();
    }

    public ResourceLocation getFabricId() {
        return ID;
    }

    public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier sync, ResourceManager sender, ProfilerFiller serverProfiler, ProfilerFiller clientProfiler, Executor serverExecutor, Executor clientExecutor) {
        return sync.m_6769_(null).thenRunAsync(() -> {
            clientProfiler.m_7242_();
            clientProfiler.m_6180_("Reloading PF Sounds");
            this.reloadEverything(sender);
            clientProfiler.m_7238_();
            clientProfiler.m_7241_();
        }, clientExecutor);
    }

    public void reloadEverything(ResourceManager manager) {
        this.shutdown();
        this.hasConfigurations = this.isolator.load(manager);
    }

    public void shutdown() {
        this.isolator = new Isolator(this);
        this.hasConfigurations = false;
    }
}

