/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps;

import com.minelittlepony.common.util.GamePaths;
import com.mojang.blaze3d.platform.InputConstants;
import eu.ha3.mc.quick.update.TargettedVersion;
import eu.ha3.mc.quick.update.UpdateChecker;
import eu.ha3.mc.quick.update.UpdaterConfig;
import eu.ha3.presencefootsteps.PFConfig;
import eu.ha3.presencefootsteps.PFDebugHud;
import eu.ha3.presencefootsteps.PFOptionsScreen;
import eu.ha3.presencefootsteps.sound.SoundEngine;
import java.nio.file.Path;
import java.util.Optional;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.entity.Entity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PresenceFootsteps
implements ClientModInitializer {
    public static final Logger logger = LogManager.getLogger((String)"PFSolver");
    private static final String MODID = "presencefootsteps";
    private static final String KEY_BINDING_CATEGORY = "key.category.presencefootsteps";
    private static final String UPDATER_ENDPOINT = "https://raw.githubusercontent.com/Sollace/Presence-Footsteps/master/version/latest.json";
    public static final Component MOD_NAME = Component.m_237115_((String)"mod.presencefootsteps.name");
    private static PresenceFootsteps instance;
    private SoundEngine engine;
    private PFConfig config;
    private PFDebugHud debugHud;
    private UpdateChecker updater;
    private KeyMapping optionsKeyBinding;
    private KeyMapping toggleKeyBinding;
    private boolean toggleTriggered;

    public static PresenceFootsteps getInstance() {
        return instance;
    }

    public PresenceFootsteps() {
        instance = this;
    }

    public PFDebugHud getDebugHud() {
        return this.debugHud;
    }

    public SoundEngine getEngine() {
        return this.engine;
    }

    public PFConfig getConfig() {
        return this.config;
    }

    public KeyMapping getOptionsKeyBinding() {
        return this.optionsKeyBinding;
    }

    public UpdateChecker getUpdateChecker() {
        return this.updater;
    }

    public void onInitializeClient() {
        Path pfFolder = GamePaths.getConfigDirectory().resolve(MODID);
        this.updater = new UpdateChecker(new UpdaterConfig(pfFolder.resolve("updater.json")), MODID, UPDATER_ENDPOINT, this::onUpdate);
        this.config = new PFConfig(pfFolder.resolve("userconfig.json"), this);
        this.config.load();
        this.optionsKeyBinding = KeyBindingHelper.registerKeyBinding((KeyMapping)new KeyMapping("key.presencefootsteps.settings", InputConstants.Type.KEYSYM, 299, KEY_BINDING_CATEGORY));
        this.toggleKeyBinding = KeyBindingHelper.registerKeyBinding((KeyMapping)new KeyMapping("key.presencefootsteps.toggle", InputConstants.Type.KEYSYM, InputConstants.f_84822_.m_84873_(), KEY_BINDING_CATEGORY));
        this.engine = new SoundEngine(this.config);
        this.debugHud = new PFDebugHud(this.engine);
        ClientTickEvents.END_CLIENT_TICK.register(this::onTick);
        ResourceManagerHelper.get((PackType)PackType.CLIENT_RESOURCES).registerReloadListener((IdentifiableResourceReloadListener)this.engine);
    }

    private void onTick(Minecraft client) {
        Optional.ofNullable(client.f_91074_).filter(e -> !e.m_213877_()).ifPresent(cameraEntity -> {
            if (client.f_91080_ == null) {
                if (this.optionsKeyBinding.m_90857_()) {
                    client.m_91152_((Screen)new PFOptionsScreen(client.f_91080_));
                }
                if (this.toggleKeyBinding.m_90857_()) {
                    if (!this.toggleTriggered) {
                        this.toggleTriggered = true;
                        this.config.toggleDisabled();
                    }
                } else {
                    this.toggleTriggered = false;
                }
            }
            this.engine.onFrame(client, (Entity)cameraEntity);
            if (!FabricLoader.getInstance().isModLoaded("modmenu")) {
                this.updater.attempt();
            }
        });
    }

    private void onUpdate(TargettedVersion newVersion, TargettedVersion currentVersion) {
        this.showSystemToast((Component)Component.m_237115_((String)"pf.update.title"), (Component)Component.m_237110_((String)"pf.update.text", (Object[])new Object[]{newVersion.version().getFriendlyString(), newVersion.minecraft().getFriendlyString()}));
    }

    void onEnabledStateChange(boolean enabled) {
        this.engine.reload();
        this.showSystemToast(MOD_NAME, (Component)Component.m_237115_((String)("key.presencefootsteps.toggle." + (enabled ? "enabled" : "disabled"))).m_130940_(enabled ? ChatFormatting.GREEN : ChatFormatting.GRAY));
    }

    public void showSystemToast(Component title, Component body) {
        Minecraft client = Minecraft.m_91087_();
        client.m_91300_().m_94922_((Toast)SystemToast.m_94847_((Minecraft)client, (SystemToast.SystemToastIds)SystemToast.SystemToastIds.PACK_LOAD_FAILURE, (Component)title, (Component)body));
    }
}

