/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps;

import com.minelittlepony.common.client.gui.GameGui;
import com.minelittlepony.common.client.gui.IField;
import com.minelittlepony.common.client.gui.ScrollContainer;
import com.minelittlepony.common.client.gui.Tooltip;
import com.minelittlepony.common.client.gui.dimension.Bounds;
import com.minelittlepony.common.client.gui.element.AbstractSlider;
import com.minelittlepony.common.client.gui.element.Button;
import com.minelittlepony.common.client.gui.element.EnumSlider;
import com.minelittlepony.common.client.gui.element.Label;
import com.minelittlepony.common.client.gui.element.Slider;
import com.minelittlepony.common.client.gui.element.Toggle;
import eu.ha3.mc.quick.update.Versions;
import eu.ha3.presencefootsteps.PFConfig;
import eu.ha3.presencefootsteps.PresenceFootsteps;
import eu.ha3.presencefootsteps.config.VolumeOption;
import eu.ha3.presencefootsteps.sound.Isolator;
import eu.ha3.presencefootsteps.sound.acoustics.Acoustic;
import eu.ha3.presencefootsteps.sound.acoustics.AcousticsFile;
import eu.ha3.presencefootsteps.sound.generator.Locomotion;
import eu.ha3.presencefootsteps.util.BlockReport;
import eu.ha3.presencefootsteps.util.ResourceUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.packs.PackSelectionScreen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

class PFOptionsScreen
extends GameGui {
    public static final Component TITLE = Component.m_237115_((String)"menu.pf.title");
    public static final Component UP_TO_DATE = Component.m_237115_((String)"pf.update.up_to_date");
    public static final Component VOLUME_MIN = Component.m_237115_((String)"menu.pf.volume.min");
    private final ScrollContainer content = new ScrollContainer();

    public PFOptionsScreen(@Nullable Screen parent) {
        super((Component)Component.m_237110_((String)"%s (%s)", (Object[])new Object[]{TITLE, PresenceFootsteps.getInstance().getOptionsKeyBinding().m_90863_()}), parent);
        this.content.margin.top = 30;
        this.content.margin.bottom = 30;
        this.content.getContentPadding().top = 10;
        this.content.getContentPadding().right = 10;
        this.content.getContentPadding().bottom = 20;
        this.content.getContentPadding().left = 10;
    }

    protected void m_7856_() {
        this.content.init(this::rebuildContent);
    }

    private void rebuildContent() {
        int left = this.content.f_96543_ / 2 - 100;
        int wideLeft = this.content.f_96543_ / 2 - 165;
        int wideRight = wideLeft + 160;
        int row = 0;
        PFConfig config = PresenceFootsteps.getInstance().getConfig();
        this.getChildElements().add(this.content);
        ((Label)this.addButton((GuiEventListener)new Label(this.f_96543_ / 2, 10))).setCentered().getStyle().setText(this.m_96636_());
        this.redrawUpdateButton(((Button)this.addButton((GuiEventListener)new Button(this.f_96543_ - 30, this.f_96544_ - 25, 25, 20))).onClick(sender -> {
            sender.setEnabled(false);
            sender.getStyle().setTooltip("pf.update.checking");
            PresenceFootsteps.getInstance().getUpdateChecker().checkNow().thenAccept(newVersions -> this.redrawUpdateButton((Button)sender));
        }));
        Toggle disabledToggle = new Toggle(wideLeft, row, config.getDisabled());
        ((Toggle)this.content.addButton((GuiEventListener)disabledToggle.onChange(disabled -> {
            this.updateDisableState(disabledToggle, config.setDisabled((boolean)disabled));
            return disabled;
        }))).getStyle().setText("menu.pf.disable_mod");
        ((Label)this.content.addButton((GuiEventListener)new Label(wideLeft, row += 24))).getStyle().setText("menu.pf.group.volume");
        AbstractSlider slider = ((Slider)this.content.addButton((GuiEventListener)new Slider(wideLeft, row += 24, 0.0f, 100.0f, (float)config.getGlobalVolume()))).onChange(config::setGlobalVolume).setTextFormat(this::formatVolume);
        slider.setBounds(new Bounds(row, wideLeft, 310, 20));
        slider.getStyle().setTooltip(Tooltip.of((String)"menu.pf.volume.tooltip", (int)210)).setTooltipOffset(0, 25);
        row += 10;
        this.addVolumeSlider(wideLeft, row += 24, config.clientPlayerVolume, "player");
        this.addVolumeSlider(wideRight, row, config.otherPlayerVolume, "other_players");
        this.addVolumeSlider(wideLeft, row += 24, config.hostileEntitiesVolume, "hostile_entities");
        this.addVolumeSlider(wideRight, row, config.passiveEntitiesVolume, "passive_entities");
        this.addVolumeSlider(wideLeft, row += 24, config.wetSoundsVolume, "wet");
        this.addVolumeSlider(wideRight, row, config.foliageSoundsVolume, "foliage");
        row += 10;
        slider = ((Slider)this.content.addButton((GuiEventListener)new Slider(wideLeft, row += 24, -100.0f, 100.0f, (float)config.getRunningVolumeIncrease()))).onChange(config::setRunningVolumeIncrease).setTextFormat(PFOptionsScreen.formatVolume("menu.pf.volume.running"));
        slider.setBounds(new Bounds(row, wideLeft, 310, 20));
        slider.getStyle().setTooltip(Tooltip.of((String)"menu.pf.volume.running.tooltip", (int)210)).setTooltipOffset(0, 25);
        ((Label)this.content.addButton((GuiEventListener)new Label(wideLeft, row += 25))).getStyle().setText("menu.pf.group.footsteps");
        ((AbstractSlider)this.content.addButton((GuiEventListener)new EnumSlider(left, row += 24, (Enum)config.getLocomotion()).onChange(config::setLocomotion).setTextFormat(v -> ((Locomotion)((Object)((Object)v.getValue()))).getOptionName()))).setTooltipFormat(v -> Tooltip.of((Component)((Locomotion)((Object)((Object)v.getValue()))).getOptionTooltip(), (int)250)).setBounds(new Bounds(row, wideLeft, 310, 20));
        ((Button)this.content.addButton((GuiEventListener)new Button(wideLeft, row += 24, 150, 20).onClick(sender -> sender.getStyle().setText("menu.pf.global." + config.cycleTargetSelector().name().toLowerCase())))).getStyle().setText("menu.pf.global." + config.getEntitySelector().name().toLowerCase());
        ((Button)this.content.addButton((GuiEventListener)new Button(wideRight, row, 150, 20).onClick(sender -> sender.getStyle().setText("menu.pf.multiplayer." + config.toggleMultiplayer())))).getStyle().setText("menu.pf.multiplayer." + config.getEnabledMP());
        ((Button)this.content.addButton((GuiEventListener)new Button(wideLeft, row += 24, 150, 20).onClick(sender -> sender.getStyle().setText("menu.pf.footwear." + (config.toggleFootwear() ? "on" : "off"))))).getStyle().setText("menu.pf.footwear." + (config.getEnabledFootwear() ? "on" : "off"));
        ((Button)this.content.addButton((GuiEventListener)new Button(wideRight, row, 150, 20).onClick(sender -> sender.getStyle().setText("menu.pf.exclusive_mode." + (config.toggleExclusiveMode() ? "on" : "off"))))).getStyle().setText("menu.pf.exclusive_mode." + (config.isExclusiveMode() ? "on" : "off"));
        ((Label)this.content.addButton((GuiEventListener)new Label(wideLeft, row += 25))).getStyle().setText("menu.pf.group.sound_packs");
        ((Button)this.content.addButton((GuiEventListener)new Button(wideLeft, row += 25, 150, 20).onClick(sender -> this.f_96541_.m_91152_((Screen)new PackSelectionScreen(this.f_96541_.m_91099_(), manager -> {
            this.f_96541_.f_91066_.m_274546_(manager);
            this.f_96541_.m_91152_((Screen)this);
        }, this.f_96541_.m_245161_(), (Component)Component.m_237115_((String)"resourcePack.title")))))).getStyle().setText("options.resourcepack");
        ((Label)this.content.addButton((GuiEventListener)new Label(wideLeft, row += 25))).getStyle().setText("menu.pf.group.debugging");
        ((Button)this.content.addButton((GuiEventListener)new Button(wideLeft, row += 25, 150, 20).onClick(sender -> {
            sender.setEnabled(false);
            BlockReport.execute(PresenceFootsteps.getInstance().getEngine().getIsolator(), "report_concise", false).thenRun(() -> sender.setEnabled(true));
        }))).setEnabled(this.f_96541_.f_91073_ != null).getStyle().setText("menu.pf.report.concise");
        ((Button)this.content.addButton((GuiEventListener)new Button(wideRight, row, 150, 20).onClick(sender -> {
            sender.setEnabled(false);
            BlockReport.execute(PresenceFootsteps.getInstance().getEngine().getIsolator(), "report_full", true).thenRun(() -> sender.setEnabled(true));
        }))).setEnabled(this.f_96541_.f_91073_ != null).getStyle().setText("menu.pf.report.full");
        ((Button)this.content.addButton((GuiEventListener)new Button(wideLeft, row += 25, 150, 20).onClick(sender -> {
            sender.setEnabled(false);
            BlockReport.execute((full, writer, groups) -> ResourceUtils.forEach(Isolator.ACOUSTICS, this.f_96541_.m_91098_(), reader -> {
                HashMap<String, Acoustic> acoustics = new HashMap<String, Acoustic>();
                AcousticsFile file = AcousticsFile.read(reader, acoustics::put, true);
                if (file != null) {
                    try {
                        file.write(writer, acoustics);
                    }
                    catch (IOException e) {
                        PresenceFootsteps.logger.error("Error whilst exporting acoustics", (Throwable)e);
                    }
                }
            }), "acoustics", true).thenRun(() -> sender.setEnabled(true));
        }))).setEnabled(this.f_96541_.f_91073_ != null).getStyle().setText("menu.pf.report.acoustics");
        ((Button)this.addButton((GuiEventListener)new Button(left, this.f_96544_ - 25).onClick(sender -> this.finish()))).getStyle().setText("gui.done");
        this.updateDisableState(disabledToggle, disabledToggle.getValue());
    }

    private void addVolumeSlider(int x, int y, VolumeOption option, String name) {
        AbstractSlider slider = ((Slider)this.content.addButton((GuiEventListener)new Slider(x, y, 0.0f, 100.0f, (float)option.get()))).onChange((IField.IChangeCallback)option).setTextFormat(PFOptionsScreen.formatVolume("menu.pf.volume." + name));
        slider.setBounds(new Bounds(y, x, 150, 20));
        slider.styled(s -> s.setTooltip(Tooltip.of((String)("menu.pf.volume." + name + ".tooltip"), (int)210)).setTooltipOffset(0, 25));
    }

    private void updateDisableState(Toggle disabledToggle, boolean disabled) {
        this.content.m_6702_().forEach(child -> {
            if (child != disabledToggle && child instanceof Button) {
                Button button = (Button)child;
                button.setEnabled(!disabled);
            }
        });
    }

    private void redrawUpdateButton(Button button) {
        Optional<Versions> versions = PresenceFootsteps.getInstance().getUpdateChecker().getNewer();
        boolean hasUpdate = versions.isPresent();
        button.setEnabled(true);
        button.getStyle().setText(hasUpdate ? "\ud83d\ude41" : "\ud83d\ude42").setColor(hasUpdate ? 0xFF0000 : 0xFFFFFF).setTooltip(versions.map(Versions::latest).map(latest -> Component.m_237110_((String)"pf.update.updates_available", (Object[])new Object[]{latest.version().getFriendlyString(), latest.minecraft().getFriendlyString()})).orElse(UP_TO_DATE));
    }

    private Component formatVolume(AbstractSlider<Float> slider) {
        if (((Float)slider.getValue()).floatValue() <= 0.0f) {
            return VOLUME_MIN;
        }
        return Component.m_237110_((String)"menu.pf.volume", (Object[])new Object[]{(int)Math.floor(((Float)slider.getValue()).floatValue())});
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float tickDelta) {
        this.m_280273_(context);
        super.m_88315_(context, mouseX, mouseY, tickDelta);
        this.content.m_88315_(context, mouseX, mouseY, tickDelta);
    }

    static Function<AbstractSlider<Float>, Component> formatVolume(String key) {
        return slider -> Component.m_237110_((String)key, (Object[])new Object[]{(int)Math.floor(((Float)slider.getValue()).floatValue())});
    }
}

