/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps;

import eu.ha3.presencefootsteps.PFConfig;
import eu.ha3.presencefootsteps.api.DerivedBlock;
import eu.ha3.presencefootsteps.sound.SoundEngine;
import eu.ha3.presencefootsteps.sound.generator.Locomotion;
import eu.ha3.presencefootsteps.world.PrimitiveLookup;
import eu.ha3.presencefootsteps.world.SoundsKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class PFDebugHud {
    private final SoundEngine engine;
    private final List<String> list = new ArrayList<String>();

    PFDebugHud(SoundEngine engine) {
        this.engine = engine;
    }

    public void render(HitResult blockHit, HitResult fluidHit, List<String> finalList) {
        EntityHitResult ehr;
        HitResult hitResult;
        Minecraft client = Minecraft.m_91087_();
        this.list.add("");
        this.list.add(ChatFormatting.UNDERLINE + "Presence Footsteps " + ((ModContainer)FabricLoader.getInstance().getModContainer("presencefootsteps").get()).getMetadata().getVersion());
        PFConfig config = this.engine.getConfig();
        this.list.add(String.format("Enabled: %s, Multiplayer: %s, Running: %s", config.getEnabled(), config.getEnabledMP(), this.engine.isRunning(client)));
        this.list.add(String.format("Volume: Global[G: %s%%, W: %s%%, F: %s%%]", config.getGlobalVolume(), config.wetSoundsVolume, config.foliageSoundsVolume));
        this.list.add(String.format("Entities[H: %s%%, P: %s%%], Players[U: %s%%, T: %s%% ]", config.hostileEntitiesVolume, config.passiveEntitiesVolume, config.clientPlayerVolume, config.otherPlayerVolume));
        this.list.add(String.format("Stepping Mode: %s, Targeting Mode: %s, Footwear: %s", config.getLocomotion() == Locomotion.NONE ? String.format("AUTO (%sDETECTED %s%s)", new Object[]{ChatFormatting.BOLD, Locomotion.forPlayer((Player)client.f_91074_, Locomotion.NONE), ChatFormatting.RESET}) : config.getLocomotion(), config.getEntitySelector(), config.getEnabledFootwear()));
        this.list.add(String.format("Data Loaded: B%s P%s G%s", this.engine.getIsolator().blocks().getSubstrates().size(), this.engine.getIsolator().primitives().getSubstrates().size(), this.engine.getIsolator().golems().getSubstrates().size()));
        this.list.add(String.format("Has Resource Pack: %s%s", this.engine.hasData() ? ChatFormatting.GREEN : ChatFormatting.RED, this.engine.hasData()));
        PFDebugHud.insertAt(this.list, finalList, "Targeted Block: ", -1);
        if (blockHit.m_6662_() == HitResult.Type.BLOCK) {
            boolean hasWater;
            BlockPos pos = ((BlockHitResult)blockHit).m_82425_();
            BlockState state = client.f_91073_.m_8055_(pos);
            this.list.add("");
            this.list.add(ChatFormatting.UNDERLINE + "Targeted Block Sounds Like");
            BlockState base = DerivedBlock.getBaseOf(state);
            if (!base.m_60795_()) {
                this.list.add(BuiltInRegistries.f_256975_.m_7981_((Object)base.m_60734_()).toString());
            }
            this.list.add(String.format(Locale.ENGLISH, "Primitive Key: %s", PrimitiveLookup.getKey(state.m_60827_())));
            BlockPos above = pos.m_7494_();
            boolean hasRain = client.f_91073_.m_46471_() && ((Biome)client.f_91073_.m_204166_(above).m_203334_()).m_264600_(above) == Biome.Precipitation.RAIN;
            boolean hasLava = client.f_91073_.m_8055_(above).m_60819_().m_205070_(FluidTags.f_13132_);
            boolean bl = hasWater = client.f_91073_.m_46758_(above) || state.m_60819_().m_205070_(FluidTags.f_13131_) || client.f_91073_.m_8055_(above).m_60819_().m_205070_(FluidTags.f_13131_);
            this.list.add("Surface Condition: " + (hasLava ? ChatFormatting.RED + "LAVA" : (hasWater ? ChatFormatting.BLUE + "WET" : (hasRain ? ChatFormatting.GRAY + "SHELTERED" : ChatFormatting.GRAY + "DRY"))));
            this.renderSoundList("Step Sounds[B]", this.engine.getIsolator().blocks().getAssociations(state), this.list);
            this.renderSoundList("Step Sounds[P]", this.engine.getIsolator().primitives().getAssociations(state.m_60827_().m_56776_()), this.list);
            this.list.add("");
            PFDebugHud.insertAt(this.list, finalList, "Targeted Block: ", 1);
        }
        if ((hitResult = client.f_91077_) instanceof EntityHitResult && (ehr = (EntityHitResult)hitResult).m_82443_() != null) {
            this.list.add(String.format("Targeted Entity Step Mode: %s", new Object[]{this.engine.getIsolator().locomotions().lookup(ehr.m_82443_())}));
            this.renderSoundList("Step Sounds[G]", this.engine.getIsolator().golems().getAssociations(ehr.m_82443_().m_6095_()), this.list);
            PFDebugHud.insertAt(this.list, finalList, "Targeted Entity", 3);
        }
    }

    private static void insertAt(List<String> values, List<String> destination, String target, int offset) {
        int i;
        for (i = 0; i < destination.size() && destination.get(i).indexOf(target) == -1; ++i) {
        }
        destination.addAll(Mth.m_14045_((int)(i + offset), (int)0, (int)destination.size()), values);
        values.clear();
    }

    private void renderSoundList(String title, Map<String, SoundsKey> sounds, List<String> list) {
        if (sounds.isEmpty()) {
            return;
        }
        StringBuilder combinedList = new StringBuilder(ChatFormatting.UNDERLINE + title + ChatFormatting.RESET + ": [ ");
        boolean first = true;
        for (Map.Entry<String, SoundsKey> entry : sounds.entrySet()) {
            if (!first) {
                combinedList.append(" / ");
            }
            first = false;
            if (!entry.getKey().isEmpty()) {
                combinedList.append(entry.getKey()).append(":");
            }
            combinedList.append(entry.getValue().raw());
        }
        combinedList.append(" ]");
        list.add(combinedList.toString());
        if (!list.isEmpty()) {
            return;
        }
        if (sounds.isEmpty()) {
            list.add(SoundsKey.UNASSIGNED.raw());
        } else {
            sounds.forEach((key, value) -> list.add((key.isEmpty() ? "default" : key) + ": " + value.raw()));
        }
    }
}

