/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.transformer;

import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.patch.PatchInstance;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.MethodTransform;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.api.PatchContext;
import org.sinytra.adapter.patch.selector.AnnotationHandle;
import org.sinytra.adapter.patch.selector.AnnotationValueHandle;
import org.slf4j.Logger;

public record RedirectAccessor(String value) implements MethodTransform
{
    private static final Logger LOGGER = LogUtils.getLogger();

    @Override
    public Collection<String> getAcceptedAnnotations() {
        return Set.of("Lorg/spongepowered/asm/mixin/gen/Accessor;");
    }

    @Override
    public Patch.Result apply(ClassNode classNode, MethodNode methodNode, MethodContext methodContext, PatchContext context) {
        AnnotationHandle annotation = methodContext.methodAnnotation();
        AnnotationValueHandle valueHandle = annotation.getValue("value").orElse(null);
        if (valueHandle == null) {
            annotation.appendValue("value", this.value);
        } else {
            valueHandle.set(this.value);
        }
        LOGGER.info(PatchInstance.MIXINPATCH, "Redirecting accessor {}.{} to field {}", new Object[]{classNode.name, methodNode.name, this.value});
        return Patch.Result.APPLY;
    }
}

