/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.transformer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.patch.PatchInstance;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.MethodTransform;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.api.PatchContext;
import org.sinytra.adapter.patch.fixes.MethodUpgrader;
import org.sinytra.adapter.patch.selector.AnnotationHandle;
import org.sinytra.adapter.patch.selector.AnnotationValueHandle;
import org.slf4j.Logger;

public record ModifyInjectionPoint(@Nullable String value, String target, boolean resetValues, boolean dontUpgrade) implements MethodTransform
{
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Codec<ModifyInjectionPoint> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("value").forGetter(i -> Optional.ofNullable(i.value())), (App)Codec.STRING.fieldOf("target").forGetter(ModifyInjectionPoint::target), (App)Codec.BOOL.optionalFieldOf("resetValues", (Object)false).forGetter(ModifyInjectionPoint::resetValues), (App)Codec.BOOL.optionalFieldOf("dontUpgrade", (Object)false).forGetter(ModifyInjectionPoint::dontUpgrade)).apply((Applicative)instance, ModifyInjectionPoint::new));

    public ModifyInjectionPoint(Optional<String> value, String target, boolean resetValues, boolean dontUpgrade) {
        this((String)value.orElse(null), target, resetValues, dontUpgrade);
    }

    @Override
    public Codec<? extends MethodTransform> codec() {
        return CODEC;
    }

    @Override
    public Patch.Result apply(ClassNode classNode, MethodNode methodNode, MethodContext methodContext, PatchContext context) {
        AnnotationValueHandle handle;
        AnnotationHandle annotation = methodContext.injectionPointAnnotation();
        if (annotation == null) {
            return Patch.Result.PASS;
        }
        if (this.value != null) {
            handle = annotation.getValue("value").orElseThrow(() -> new IllegalArgumentException("Missing value handle"));
            handle.set(this.value);
        }
        LOGGER.info(PatchInstance.MIXINPATCH, "Changing mixin method target {}.{} to {}", new Object[]{classNode.name, methodNode.name, this.target});
        handle = annotation.getValue("target").orElse(null);
        if (handle != null) {
            String original = (String)handle.get();
            handle.set(this.target);
            if (!this.dontUpgrade) {
                MethodUpgrader.upgradeMethod(classNode, methodNode, methodContext, original, this.target);
            }
        } else {
            annotation.appendValue("target", this.target);
        }
        if (this.resetValues) {
            annotation.removeValues("ordinal", "shift", "by");
        }
        return Patch.Result.APPLY;
    }
}

