/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.transformer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.patch.PatchInstance;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.MethodTransform;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.api.PatchContext;
import org.slf4j.Logger;

public record ChangeModifiedVariableIndex(int start, int offset) implements MethodTransform
{
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Codec<ChangeModifiedVariableIndex> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("start").forGetter(ChangeModifiedVariableIndex::start), (App)Codec.INT.fieldOf("offset").forGetter(ChangeModifiedVariableIndex::offset)).apply((Applicative)instance, ChangeModifiedVariableIndex::new));

    @Override
    public Codec<? extends MethodTransform> codec() {
        return CODEC;
    }

    @Override
    public Patch.Result apply(ClassNode classNode, MethodNode methodNode, MethodContext methodContext, PatchContext context) {
        return methodContext.methodAnnotation().getValue("index").filter(index -> (Integer)index.get() > -1).map(handle -> {
            int index = (Integer)handle.get();
            int newIndex = index >= this.start ? index + this.offset : index;
            LOGGER.info(PatchInstance.MIXINPATCH, "Updating variable index of variable modifier method {}.{} to {}", new Object[]{classNode.name, methodNode.name, newIndex});
            handle.set(newIndex);
            return Patch.Result.APPLY;
        }).orElse(Patch.Result.PASS);
    }
}

