/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.events;

import dev.xkmc.modulargolems.content.config.GolemMaterial;
import dev.xkmc.modulargolems.content.config.GolemMaterialConfig;
import dev.xkmc.modulargolems.content.core.GolemType;
import dev.xkmc.modulargolems.content.core.IGolemPart;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.item.golem.GolemFacade;
import dev.xkmc.modulargolems.content.item.golem.GolemHolder;
import dev.xkmc.modulargolems.content.item.golem.GolemPart;
import dev.xkmc.modulargolems.content.item.upgrade.IUpgradeItem;
import dev.xkmc.modulargolems.content.item.upgrade.UpgradeItem;
import dev.xkmc.modulargolems.content.modifier.base.GolemModifier;
import dev.xkmc.modulargolems.content.modifier.base.ModifierInstance;
import dev.xkmc.modulargolems.init.advancement.GolemTriggers;
import dev.xkmc.modulargolems.init.data.MGTagGen;
import dev.xkmc.modulargolems.init.registrate.GolemItems;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.GrindstoneEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="modulargolems", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CraftEventListeners {
    @SubscribeEvent
    public static void onAnvilCraft(AnvilUpdateEvent event) {
        Item new_stack;
        Object mat;
        ItemStack stack = event.getLeft();
        ItemStack block = event.getRight();
        Item item = stack.m_41720_();
        if (item instanceof GolemPart) {
            GolemPart part = (GolemPart)item;
            if (part.count > block.m_41613_() || block.m_204117_(MGTagGen.SPECIAL_CRAFT)) {
                return;
            }
            mat = GolemMaterial.getMaterial(block);
            if (((Optional)mat).isEmpty()) {
                return;
            }
            new_stack = stack.m_41777_();
            GolemPart.setMaterial((ItemStack)new_stack, (ResourceLocation)((Optional)mat).get());
            event.setOutput((ItemStack)new_stack);
            event.setMaterialCost(part.count);
            event.setCost(1);
        }
        if ((mat = stack.m_41720_()) instanceof GolemHolder) {
            GolemHolder holder = (GolemHolder)((Object)mat);
            new_stack = block.m_41720_();
            if (new_stack instanceof UpgradeItem) {
                UpgradeItem upgrade = (UpgradeItem)new_stack;
                CraftEventListeners.appendUpgrade(event, holder, upgrade);
            } else {
                CraftEventListeners.fixGolem(event, holder, stack);
            }
        }
        if (stack.m_150930_((Item)GolemItems.EMPTY_UPGRADE.get())) {
            Optional<ResourceLocation> mat2 = GolemMaterial.getRepairMaterial(block);
            if (mat2.isEmpty()) {
                return;
            }
            ItemStack ans = GolemFacade.setMaterial(GolemItems.FACADE.asStack(), mat2.get());
            ans.m_41764_(stack.m_41613_());
            int consume = Math.min(stack.m_41613_(), block.m_41613_());
            event.setOutput(ans);
            event.setMaterialCost(consume);
            event.setCost(stack.m_41613_() - consume + 1);
        }
    }

    @SubscribeEvent
    public static void onAnvilFinish(AnvilRepairEvent event) {
        Object mat;
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        ItemStack stack = event.getLeft();
        ItemStack block = event.getRight();
        Item item = stack.m_41720_();
        if (item instanceof GolemPart) {
            GolemPart part = (GolemPart)item;
            if (part.count <= block.m_41613_()) {
                mat = GolemMaterial.getMaterial(block);
                ((Optional)mat).ifPresent(rl -> GolemTriggers.PART_CRAFT.trigger((ServerPlayer)event.getEntity(), (ResourceLocation)rl));
            }
        }
        if ((mat = stack.m_41720_()) instanceof GolemHolder) {
            GolemHolder holder = (GolemHolder)((Object)mat);
            if (block.m_41720_() instanceof UpgradeItem) {
                ItemStack result = event.getOutput();
                ArrayList<GolemMaterial> mats = GolemHolder.getMaterial(result);
                ArrayList<IUpgradeItem> upgrades = GolemHolder.getUpgrades(result);
                int remaining = holder.getRemaining(mats, upgrades);
                int total = upgrades.size();
                GolemTriggers.UPGRADE_APPLY.trigger((ServerPlayer)event.getEntity(), block, remaining, total);
            } else {
                ArrayList<GolemMaterial> mats = GolemHolder.getMaterial(stack);
                GolemType type = holder.getEntityType();
                Object part = type.getBodyPart();
                if (mats.size() <= part.ordinal()) {
                    return;
                }
                GolemMaterial mat2 = mats.get(part.ordinal());
                Ingredient ing = GolemMaterialConfig.get().getRepairIngredient(mat2.id());
                if (!ing.test(block)) {
                    return;
                }
                GolemTriggers.ANVIL_FIX.trigger((ServerPlayer)event.getEntity(), mat2.id());
            }
        }
    }

    @SubscribeEvent
    public static void onGrindStone(GrindstoneEvent.OnPlaceItem event) {
        ItemStack copy;
        if (event.getTopItem().m_41720_() instanceof GolemHolder && !GolemHolder.getUpgrades(copy = event.getTopItem().m_41777_()).isEmpty()) {
            copy.m_41784_().m_128473_("golem_upgrades");
            event.setOutput(copy);
            event.setXp(0);
        }
    }

    private static <T extends AbstractGolemEntity<T, P>, P extends IGolemPart<P>> void fixGolem(AnvilUpdateEvent event, GolemHolder<T, P> holder, ItemStack stack) {
        if (stack.m_41783_() == null || !stack.m_41783_().m_128441_("golem_entity")) {
            return;
        }
        Ingredient ing = GolemHolder.getHealingMaterial(stack);
        if (ing.m_43947_()) {
            return;
        }
        ItemStack repairStack = event.getRight();
        if (!ing.test(repairStack)) {
            return;
        }
        int reforge = GolemHolder.getReforge(stack);
        if (reforge > 0) {
            if (repairStack.m_41613_() <= reforge) {
                ItemStack result = stack.m_41777_();
                GolemHolder.setReforge(result, reforge - repairStack.m_41613_());
                event.setMaterialCost(repairStack.m_41613_());
                event.setCost(1);
                event.setOutput(result);
            } else {
                ItemStack result = stack.m_41777_();
                GolemHolder.setReforge(result, 0);
                float max = GolemHolder.getMaxHealth(result);
                float health = GolemHolder.getHealth(stack);
                int maxFix = Math.min(repairStack.m_41613_() - reforge, (int)Math.ceil((max - health) / max * 4.0f));
                event.setMaterialCost(maxFix + reforge);
                event.setCost(reforge + maxFix);
                GolemHolder.setHealth(result, Math.min(max, health + max / 4.0f * (float)maxFix));
                event.setOutput(result);
            }
        } else {
            float max = GolemHolder.getMaxHealth(stack);
            float health = GolemHolder.getHealth(stack);
            if (health >= max) {
                return;
            }
            int maxFix = Math.min(repairStack.m_41613_(), (int)Math.ceil((max - health) / max * 4.0f));
            event.setMaterialCost(maxFix);
            event.setCost(maxFix);
            ItemStack result = stack.m_41777_();
            GolemHolder.setHealth(result, Math.min(max, health + max / 4.0f * (float)maxFix));
            event.setOutput(result);
        }
    }

    private static <T extends AbstractGolemEntity<T, P>, P extends IGolemPart<P>> void appendUpgrade(AnvilUpdateEvent event, GolemHolder<T, P> holder, UpgradeItem upgrade) {
        ItemStack stack = event.getLeft();
        ArrayList<IUpgradeItem> upgrades = GolemHolder.getUpgrades(stack);
        ItemStack result = CraftEventListeners.appendUpgrade(stack, holder, upgrade);
        if (result.m_41619_()) {
            return;
        }
        event.setOutput(result);
        event.setCost(Math.min(39, 4 * (1 + upgrades.size())));
        event.setMaterialCost(1);
    }

    public static <T extends AbstractGolemEntity<T, P>, P extends IGolemPart<P>> ItemStack appendUpgrade(ItemStack stack, GolemHolder<T, P> holder, UpgradeItem upgrade) {
        if (!upgrade.fitsOn(holder.getEntityType())) {
            return ItemStack.f_41583_;
        }
        ArrayList<GolemMaterial> mats = GolemHolder.getMaterial(stack);
        ArrayList<IUpgradeItem> upgrades = GolemHolder.getUpgrades(stack);
        ArrayList<IUpgradeItem> copy = new ArrayList<IUpgradeItem>(upgrades);
        copy.add(upgrade);
        int remaining = holder.getRemaining(mats, copy);
        if (remaining < 0) {
            return ItemStack.f_41583_;
        }
        HashMap<GolemModifier, Integer> map = GolemMaterial.collectModifiers(GolemHolder.getMaterial(stack), upgrades);
        for (ModifierInstance e : upgrade.get()) {
            if (map.getOrDefault((Object)e.mod(), 0) < e.mod().maxLevel) continue;
            return ItemStack.f_41583_;
        }
        ItemStack result = stack.m_41777_();
        GolemHolder.addUpgrade(result, upgrade);
        return result;
    }
}

