/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.content.entity.metalgolem;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.xkmc.modulargolems.content.entity.metalgolem.MetalGolemEntity;
import dev.xkmc.modulargolems.content.item.equipments.MetalGolemBeaconItem;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.DyeColor;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class BeaconRenderer {
    private static final ResourceLocation BEACON_LOCATION = new ResourceLocation("modulargolems", "textures/equipments/beacon.png");
    private static final ResourceLocation BEAM_LOCATION = new ResourceLocation("textures/entity/beacon_beam.png");

    public static void renderGolemBeacon(MetalGolemEntity entity, PoseStack pose, MultiBufferSource source, float pTick) {
        if (entity.isAddedToWorld() && entity.m_6844_(EquipmentSlot.FEET).m_41720_() instanceof MetalGolemBeaconItem) {
            float[] color = DyeColor.values()[entity.getConfigColor()].m_41068_();
            pose.m_85836_();
            BeaconRenderer.renderBeacon(pose, source, (float)entity.f_19797_ + pTick);
            BeaconRenderer.renderBeam(pose, source, (float)entity.f_19797_ + pTick, 1.0f, entity.m_20206_(), color);
            pose.m_85849_();
        }
    }

    protected static void renderBeacon(PoseStack pose, MultiBufferSource source, float pTick) {
        float w = 1.5f;
        float h = 0.5f;
        pose.m_85836_();
        float accurateTick = pTick % 360.0f;
        pose.m_252781_(Axis.f_252436_.m_252977_(accurateTick - 45.0f));
        pose.m_252880_(0.0f, -0.49f, 0.0f);
        VertexConsumer buffer = source.m_6299_(RenderType.m_110431_((ResourceLocation)BEACON_LOCATION));
        PoseStack.Pose posestack$pose = pose.m_85850_();
        Matrix4f matrix4f = posestack$pose.m_252922_();
        Matrix3f matrix3f = posestack$pose.m_252943_();
        BeaconRenderer.addVertex(matrix4f, matrix3f, buffer, 1.0f, 1.0f, 1.0f, 1.0f, h, -w, -w, 0.0f, 0.0f);
        BeaconRenderer.addVertex(matrix4f, matrix3f, buffer, 1.0f, 1.0f, 1.0f, 1.0f, h, -w, w, 0.0f, 1.0f);
        BeaconRenderer.addVertex(matrix4f, matrix3f, buffer, 1.0f, 1.0f, 1.0f, 1.0f, h, w, w, 1.0f, 1.0f);
        BeaconRenderer.addVertex(matrix4f, matrix3f, buffer, 1.0f, 1.0f, 1.0f, 1.0f, h, w, -w, 1.0f, 0.0f);
        BeaconRenderer.addVertex(matrix4f, matrix3f, buffer, 1.0f, 1.0f, 1.0f, 1.0f, -h, -w, -w, 0.0f, 0.0f);
        BeaconRenderer.addVertex(matrix4f, matrix3f, buffer, 1.0f, 1.0f, 1.0f, 1.0f, -h, -w, w, 0.0f, 1.0f);
        BeaconRenderer.addVertex(matrix4f, matrix3f, buffer, 1.0f, 1.0f, 1.0f, 1.0f, -h, w, w, 1.0f, 1.0f);
        BeaconRenderer.addVertex(matrix4f, matrix3f, buffer, 1.0f, 1.0f, 1.0f, 1.0f, -h, w, -w, 1.0f, 0.0f);
        BeaconRenderer.addVertex(matrix4f, matrix3f, buffer, 1.0f, 1.0f, 1.0f, 1.0f, -h, w, -w, 0.0f, 0.0f);
        BeaconRenderer.addVertex(matrix4f, matrix3f, buffer, 1.0f, 1.0f, 1.0f, 1.0f, h, w, -w, 0.0f, 0.33333334f);
        BeaconRenderer.addVertex(matrix4f, matrix3f, buffer, 1.0f, 1.0f, 1.0f, 1.0f, h, w, w, 1.0f, 0.33333334f);
        BeaconRenderer.addVertex(matrix4f, matrix3f, buffer, 1.0f, 1.0f, 1.0f, 1.0f, -h, w, w, 1.0f, 0.0f);
        BeaconRenderer.addVertex(matrix4f, matrix3f, buffer, 1.0f, 1.0f, 1.0f, 1.0f, -h, -w, -w, 0.0f, 0.0f);
        BeaconRenderer.addVertex(matrix4f, matrix3f, buffer, 1.0f, 1.0f, 1.0f, 1.0f, h, -w, -w, 0.0f, 0.33333334f);
        BeaconRenderer.addVertex(matrix4f, matrix3f, buffer, 1.0f, 1.0f, 1.0f, 1.0f, h, -w, w, 1.0f, 0.33333334f);
        BeaconRenderer.addVertex(matrix4f, matrix3f, buffer, 1.0f, 1.0f, 1.0f, 1.0f, -h, -w, w, 1.0f, 0.0f);
        BeaconRenderer.addVertex(matrix4f, matrix3f, buffer, 1.0f, 1.0f, 1.0f, 1.0f, -h, -w, w, 0.0f, 0.0f);
        BeaconRenderer.addVertex(matrix4f, matrix3f, buffer, 1.0f, 1.0f, 1.0f, 1.0f, h, -w, w, 0.0f, 0.33333334f);
        BeaconRenderer.addVertex(matrix4f, matrix3f, buffer, 1.0f, 1.0f, 1.0f, 1.0f, h, w, w, 1.0f, 0.33333334f);
        BeaconRenderer.addVertex(matrix4f, matrix3f, buffer, 1.0f, 1.0f, 1.0f, 1.0f, -h, w, w, 1.0f, 0.0f);
        BeaconRenderer.addVertex(matrix4f, matrix3f, buffer, 1.0f, 1.0f, 1.0f, 1.0f, -h, -w, -w, 0.0f, 0.0f);
        BeaconRenderer.addVertex(matrix4f, matrix3f, buffer, 1.0f, 1.0f, 1.0f, 1.0f, h, -w, -w, 0.0f, 0.33333334f);
        BeaconRenderer.addVertex(matrix4f, matrix3f, buffer, 1.0f, 1.0f, 1.0f, 1.0f, h, w, -w, 1.0f, 0.33333334f);
        BeaconRenderer.addVertex(matrix4f, matrix3f, buffer, 1.0f, 1.0f, 1.0f, 1.0f, -h, w, -w, 1.0f, 0.0f);
        pose.m_85849_();
    }

    protected static void renderBeam(PoseStack pose, MultiBufferSource source, float pTick, float scale, float height, float[] color) {
        float width1 = 0.2f;
        float width2 = 0.25f;
        int length = 1024;
        float accurateTick = pTick % 40.0f;
        float f2 = Mth.m_14187_((float)(accurateTick * 0.2f - (float)Mth.m_14143_((float)(accurateTick * 0.1f))));
        float colorR = color[0];
        float colorG = color[1];
        float colorB = color[2];
        pose.m_85836_();
        pose.m_252781_(Axis.f_252436_.m_252977_(accurateTick * 2.25f - 45.0f));
        float v1 = -1.0f + f2;
        float v2 = (float)length * scale * (0.5f / width1) + v1;
        BeaconRenderer.renderPart(pose, source.m_6299_(RenderType.m_110460_((ResourceLocation)BEAM_LOCATION, (boolean)false)), colorR, colorG, colorB, 1.0f, 0, length, 0.0f, width1, width1, 0.0f, -width1, 0.0f, 0.0f, -width1, 0.0f, 1.0f, v2, v1);
        pose.m_85849_();
        v1 = -1.0f + f2;
        v2 = (float)length * scale + v1;
        BeaconRenderer.renderPart(pose, source.m_6299_(RenderType.m_110460_((ResourceLocation)BEAM_LOCATION, (boolean)true)), colorR, colorG, colorB, 0.125f, 0, length, -width2, -width2, width2, -width2, -width2, width2, width2, width2, 0.0f, 1.0f, v2, v1);
    }

    private static void renderPart(PoseStack pose, VertexConsumer buffer, float r, float g, float b, float a, int start, int end, float p_112164_, float p_112165_, float p_112166_, float p_112167_, float p_112168_, float p_112169_, float p_112170_, float p_112171_, float u1, float u2, float v1, float v2) {
        PoseStack.Pose posestack$pose = pose.m_85850_();
        Matrix4f matrix4f = posestack$pose.m_252922_();
        Matrix3f matrix3f = posestack$pose.m_252943_();
        BeaconRenderer.renderQuad(matrix4f, matrix3f, buffer, r, g, b, a, start, end, p_112164_, p_112165_, p_112166_, p_112167_, u1, u2, v1, v2);
        BeaconRenderer.renderQuad(matrix4f, matrix3f, buffer, r, g, b, a, start, end, p_112170_, p_112171_, p_112168_, p_112169_, u1, u2, v1, v2);
        BeaconRenderer.renderQuad(matrix4f, matrix3f, buffer, r, g, b, a, start, end, p_112166_, p_112167_, p_112170_, p_112171_, u1, u2, v1, v2);
        BeaconRenderer.renderQuad(matrix4f, matrix3f, buffer, r, g, b, a, start, end, p_112168_, p_112169_, p_112164_, p_112165_, u1, u2, v1, v2);
    }

    private static void renderQuad(Matrix4f pose, Matrix3f normal, VertexConsumer buffer, float r, float g, float b, float a, int y1, int y2, float x1, float z1, float x2, float z2, float u1, float u2, float v1, float v2) {
        BeaconRenderer.addVertex(pose, normal, buffer, r, g, b, a, y2, x1, z1, u2, v1);
        BeaconRenderer.addVertex(pose, normal, buffer, r, g, b, a, y1, x1, z1, u2, v2);
        BeaconRenderer.addVertex(pose, normal, buffer, r, g, b, a, y1, x2, z2, u1, v2);
        BeaconRenderer.addVertex(pose, normal, buffer, r, g, b, a, y2, x2, z2, u1, v1);
    }

    private static void addVertex(Matrix4f pose, Matrix3f normal, VertexConsumer buffer, float r, float g, float b, float a, float y, float x, float z, float u, float v) {
        buffer.m_252986_(pose, x, y, z).m_85950_(r, g, b, a).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

