/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.modulargolems.compat.materials.tinker.modifier;

import dev.xkmc.l2library.base.effects.EffectUtil;
import dev.xkmc.modulargolems.compat.materials.tinker.TCCompatRegistry;
import dev.xkmc.modulargolems.compat.materials.tinker.effect.HepatizonDefenseEffect;
import dev.xkmc.modulargolems.content.core.StatFilterType;
import dev.xkmc.modulargolems.content.entity.common.AbstractGolemEntity;
import dev.xkmc.modulargolems.content.modifier.base.GolemModifier;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class HepatizonDefenseModifier
extends GolemModifier {
    public HepatizonDefenseModifier() {
        super(StatFilterType.HEALTH, 5);
    }

    @Override
    public void onHurt(AbstractGolemEntity<?, ?> entity, LivingHurtEvent event, int level) {
        if (event.getSource().m_269533_(DamageTypeTags.f_268437_) || event.getSource().m_269533_(DamageTypeTags.f_268738_)) {
            return;
        }
        HepatizonDefenseEffect eff = (HepatizonDefenseEffect)TCCompatRegistry.EFF_HEPATIZON.get();
        MobEffectInstance ins = entity.m_21124_((MobEffect)eff);
        if (ins == null) {
            return;
        }
        int reduction = (ins.m_19564_() + 1) * 2;
        event.setAmount(Math.max(0.0f, event.getAmount() - (float)reduction));
    }

    @Override
    public void onDamaged(AbstractGolemEntity<?, ?> entity, LivingDamageEvent event, int level) {
        HepatizonDefenseEffect eff = (HepatizonDefenseEffect)TCCompatRegistry.EFF_HEPATIZON.get();
        int dur = 100;
        int amp = Math.min(level * 2, (int)(event.getAmount() / 4.0f)) - 1;
        if (amp < 0) {
            return;
        }
        MobEffectInstance ins = new MobEffectInstance((MobEffect)eff, dur, amp - 1);
        EffectUtil.addEffect(entity, (MobEffectInstance)ins, (EffectUtil.AddReason)EffectUtil.AddReason.SELF, entity);
    }
}

