/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.world;

import eu.ha3.presencefootsteps.world.Lookup;
import eu.ha3.presencefootsteps.world.SoundsKey;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

abstract class AbstractSubstrateLookup<T>
implements Lookup<T> {
    private final Map<String, Map<ResourceLocation, SoundsKey>> substrates = new Object2ObjectLinkedOpenHashMap();

    AbstractSubstrateLookup() {
    }

    protected abstract ResourceLocation getId(T var1);

    @Override
    public SoundsKey getAssociation(@Nullable T key, String substrate) {
        if (key == null) {
            return SoundsKey.UNASSIGNED;
        }
        ResourceLocation id = this.getId(key);
        return this.getSubstrateMap(id, substrate).getOrDefault(id, SoundsKey.UNASSIGNED);
    }

    @Nullable
    protected Map<ResourceLocation, SoundsKey> getSubstrateMap(ResourceLocation id, String substrate) {
        Map<ResourceLocation, SoundsKey> primitives = this.substrates.get(substrate);
        if (primitives != null) {
            return primitives;
        }
        primitives = this.substrates.get("break_" + id.m_135815_());
        if (primitives != null) {
            return primitives;
        }
        return this.substrates.getOrDefault("", Map.of());
    }

    @Override
    public Set<String> getSubstrates() {
        return this.substrates.keySet();
    }

    @Override
    public void add(String key, String value) {
        String[] split = key.trim().split("@");
        String primitive = split[0];
        String substrate = split.length > 1 ? split[1] : "";
        this.substrates.computeIfAbsent(substrate, s -> new Object2ObjectLinkedOpenHashMap()).put(new ResourceLocation(primitive), SoundsKey.of(value));
    }

    @Override
    public boolean contains(T key) {
        ResourceLocation primitive = this.getId(key);
        for (Map<ResourceLocation, SoundsKey> primitives : this.substrates.values()) {
            if (!primitives.containsKey(primitive)) continue;
            return true;
        }
        return false;
    }
}

