/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound.player;

import eu.ha3.presencefootsteps.sound.Options;
import eu.ha3.presencefootsteps.sound.SoundEngine;
import eu.ha3.presencefootsteps.sound.player.SoundPlayer;
import eu.ha3.presencefootsteps.util.PlayerUtil;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public final class ImmediateSoundPlayer
implements SoundPlayer {
    private final Random random = new Random();
    private final SoundEngine engine;

    public ImmediateSoundPlayer(SoundEngine engine) {
        this.engine = engine;
    }

    @Override
    public Random getRNG() {
        return this.random;
    }

    @Override
    public void playSound(LivingEntity location, String soundName, float volume, float pitch, Options options) {
        volume *= options.getOrDefault("volume_percentage", 1.0f);
        pitch *= options.getOrDefault("pitch_percentage", 1.0f);
        Minecraft mc = Minecraft.m_91087_();
        double distance = mc.f_91063_.m_109153_().m_90583_().m_82557_(location.m_20182_());
        UncappedSoundInstance sound = new UncappedSoundInstance(soundName, volume *= this.engine.getVolumeForSource(location), pitch /= (PlayerUtil.getScale(location) - 1.0f) * 0.6f + 1.0f, (Entity)location);
        if (distance > 100.0) {
            mc.m_91106_().m_120369_((SoundInstance)sound, (int)Math.floor(Math.sqrt(distance) / 2.0));
        } else {
            mc.m_91106_().m_120367_((SoundInstance)sound);
        }
    }

    public static class UncappedSoundInstance
    extends SimpleSoundInstance {
        public UncappedSoundInstance(String soundName, float volume, float pitch, Entity entity) {
            super(UncappedSoundInstance.getSoundId(soundName, entity), entity.m_5720_(), volume, pitch, SoundInstance.m_235150_(), false, 0, SoundInstance.Attenuation.LINEAR, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), false);
        }

        public float getMaxVolume() {
            return 3.0f;
        }

        private static ResourceLocation getSoundId(String name, Entity location) {
            if (name.indexOf(58) >= 0) {
                return new ResourceLocation(name);
            }
            Object domain = "presencefootsteps";
            if (!PlayerUtil.isClientPlayer(location)) {
                domain = (String)domain + "mono";
            }
            return new ResourceLocation((String)domain, name);
        }
    }
}

