/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound.acoustics;

import com.google.gson.JsonElement;
import eu.ha3.presencefootsteps.sound.Options;
import eu.ha3.presencefootsteps.sound.State;
import eu.ha3.presencefootsteps.sound.acoustics.Acoustic;
import eu.ha3.presencefootsteps.sound.acoustics.AcousticsFile;
import eu.ha3.presencefootsteps.sound.acoustics.VaryingAcoustic;
import eu.ha3.presencefootsteps.sound.player.SoundPlayer;
import eu.ha3.presencefootsteps.util.JsonObjectWriter;
import eu.ha3.presencefootsteps.util.Period;
import java.io.IOException;
import net.minecraft.world.entity.LivingEntity;

record DelayedAcoustic(Acoustic acoustic, Period delay) implements Acoustic
{
    static final Acoustic.Serializer FACTORY = Acoustic.Serializer.ofJsObject((json, context) -> new DelayedAcoustic(json.has("name") ? VaryingAcoustic.FACTORY.create((JsonElement)json, (AcousticsFile)context) : Acoustic.read(context, json.get("acoustic")), Period.fromJson(json, "delay")));

    @Override
    public void playSound(SoundPlayer player, LivingEntity location, State event, Options inputOptions) {
        this.acoustic.playSound(player, location, event, inputOptions.and(this.delay));
    }

    @Override
    public void write(AcousticsFile context, JsonObjectWriter writer) throws IOException {
        writer.object(() -> {
            writer.field("type", "delayed");
            writer.field("delay", () -> this.delay.write(writer));
            writer.field("acoustic", () -> this.acoustic.write(context, writer));
        });
    }
}

