/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.antique_atlas.gui;

import folk.sisby.antique_atlas.MarkerTexture;
import folk.sisby.antique_atlas.gui.AtlasScreen;
import folk.sisby.antique_atlas.gui.BookmarkButton;
import folk.sisby.antique_atlas.gui.MarkerPreviewButton;
import folk.sisby.antique_atlas.gui.TexturePreviewButton;
import folk.sisby.antique_atlas.gui.core.Component;
import folk.sisby.antique_atlas.gui.core.ScrollBoxComponent;
import folk.sisby.antique_atlas.gui.core.ToggleButtonRadioGroup;
import folk.sisby.antique_atlas.reloader.MarkerTextures;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;

public class MarkerModal
extends Component {
    private Level world;
    private int markerX;
    private int markerZ;
    MarkerTexture selectedTexture = MarkerTexture.DEFAULT;
    DyeColor selectedColor = DyeColor.WHITE;
    private static final int BUTTON_WIDTH = 80;
    private static final int BUTTON_SPACING = 8;
    private static final int TYPE_SPACING = 1;
    private Button btnDone;
    private Button btnCancel;
    private EditBox textField;
    private ScrollBoxComponent textureScrollBox;
    private ToggleButtonRadioGroup<TexturePreviewButton<MarkerTexture>> textureRadioGroup;
    private ScrollBoxComponent colorScrollBox;
    private ToggleButtonRadioGroup<TexturePreviewButton<DyeColor>> colorRadioGroup;
    private final List<IMarkerTypeSelectListener> markerListeners = new ArrayList<IMarkerTypeSelectListener>();

    MarkerModal() {
    }

    void setMarkerData(Level world, int markerX, int markerZ) {
        this.world = world;
        this.markerX = markerX;
        this.markerZ = markerZ;
    }

    void addMarkerListener(IMarkerTypeSelectListener listener) {
        this.markerListeners.add(listener);
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.btnDone = Button.m_253074_((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.m_237115_((String)"gui.done"), button -> {
            ((AtlasScreen)Minecraft.m_91087_().f_91080_).getworldAtlasData().placeCustomMarker(this.world, this.selectedTexture, this.selectedColor, net.minecraft.network.chat.Component.m_237113_((String)this.textField.m_94155_()), new BlockPos(this.markerX, 0, this.markerZ));
            ((AtlasScreen)Minecraft.m_91087_().f_91080_).updateBookmarkerList();
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            this.world.m_5594_((Player)player, player.m_20183_(), SoundEvents.f_12565_, SoundSource.AMBIENT, 1.0f, 1.0f);
            this.closeChild();
        }).m_252987_(this.f_96543_ / 2 - 80 - 4, this.f_96544_ / 2 + 70, 80, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.btnDone);
        this.btnCancel = Button.m_253074_((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.m_237115_((String)"gui.cancel"), button -> this.closeChild()).m_252987_(this.f_96543_ / 2 + 4, this.f_96544_ / 2 + 70, 80, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.btnCancel);
        this.textField = new EditBox(Minecraft.m_91087_().f_91062_, (this.f_96543_ - 200) / 2, this.f_96544_ / 2 - 65, 200, 20, (net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.m_237115_((String)"gui.antique_atlas.marker.label"));
        this.textField.m_94186_(true);
        this.textField.m_94190_(true);
        this.textField.m_93692_(true);
        this.textField.m_257771_((net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.m_237115_((String)"gui.antique_atlas.marker.label"));
        this.textureScrollBox = new ScrollBoxComponent(false, 35);
        this.addChild(this.textureScrollBox);
        int typeCount = (int)MarkerTextures.getInstance().asMap().values().stream().filter(t -> t.keyId().m_135815_().startsWith("custom/")).count();
        int typesOnScreen = Math.min(typeCount, 7);
        int typeScrollWidth = typesOnScreen * 35 - 1;
        this.textureScrollBox.getViewport().setSize(typeScrollWidth, 35);
        this.textureScrollBox.setGuiCoords((this.f_96543_ - typeScrollWidth) / 2, this.f_96544_ / 2 - 35);
        this.textureRadioGroup = new ToggleButtonRadioGroup();
        this.textureRadioGroup.addListener(button -> {
            this.selectedTexture = (MarkerTexture)button.getValue();
            for (IMarkerTypeSelectListener listener : this.markerListeners) {
                listener.onSelectMarkerType((MarkerTexture)button.getValue());
            }
        });
        int contentX = 0;
        for (MarkerTexture texture : MarkerTextures.getInstance().asMap().values()) {
            if (!texture.keyId().m_135815_().startsWith("custom/")) continue;
            if (this.selectedTexture == MarkerTexture.DEFAULT) {
                this.selectedTexture = texture;
            }
            MarkerPreviewButton markerGui = new MarkerPreviewButton(texture, this.selectedColor.m_41068_());
            this.textureRadioGroup.addButton(markerGui);
            if (this.selectedTexture.equals(texture)) {
                this.textureRadioGroup.setSelectedButton(markerGui);
            }
            this.textureScrollBox.getViewport().addContent(markerGui).setRelativeX(contentX);
            contentX += 35;
        }
        this.colorScrollBox = new ScrollBoxComponent(false, 35);
        this.addChild(this.colorScrollBox);
        int colorsOnScreen = Math.min(DyeColor.values().length, 7);
        int colorScrollWidth = colorsOnScreen * 35 - 1;
        this.colorScrollBox.getViewport().setSize(colorScrollWidth, 35);
        this.colorScrollBox.setGuiCoords((this.f_96543_ - colorScrollWidth) / 2, this.f_96544_ / 2 + 10);
        this.colorRadioGroup = new ToggleButtonRadioGroup();
        this.colorRadioGroup.addListener(button -> {
            this.selectedColor = (DyeColor)button.getValue();
            for (TexturePreviewButton<MarkerTexture> preview : this.textureRadioGroup) {
                preview.reTint(this.selectedColor.m_41068_());
            }
        });
        int colorContentX = 0;
        for (DyeColor color : DyeColor.values()) {
            TexturePreviewButton<DyeColor> colorGui = new TexturePreviewButton<DyeColor>(color, BookmarkButton.TEXTURE_LEFT, 24, 18, 18, color.m_41068_());
            this.colorRadioGroup.addButton(colorGui);
            if (this.selectedColor.equals((Object)color)) {
                this.colorRadioGroup.setSelectedButton(colorGui);
            }
            this.colorScrollBox.getViewport().addContent(colorGui).setRelativeX(colorContentX);
            colorContentX += 35;
        }
    }

    @Override
    public void closeChild() {
        super.closeChild();
        if (this.textureScrollBox != null) {
            this.textureScrollBox.closeChild();
        }
        if (this.colorScrollBox != null) {
            this.colorScrollBox.closeChild();
        }
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return super.m_6375_(mouseX, mouseY, button) || this.textField.m_6375_(mouseX, mouseY, button);
    }

    @Override
    public boolean m_7933_(int aa, int bb, int cc) {
        return super.m_7933_(aa, bb, cc) || this.textField.m_7933_(aa, bb, cc);
    }

    @Override
    public boolean m_5534_(char aa, int bb) {
        return super.m_5534_(aa, bb) || this.textField.m_5534_(aa, bb);
    }

    @Override
    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(context);
        this.drawCentered(context, (net.minecraft.network.chat.Component)net.minecraft.network.chat.Component.m_237115_((String)"gui.antique_atlas.marker.label"), this.f_96544_ / 2 - 80, 0xDDDDDD, true);
        this.textField.m_88315_(context, mouseX, mouseY, partialTick);
        context.m_280024_(this.textureScrollBox.getGuiX() + 1, this.textureScrollBox.getGuiY() + 1, this.textureScrollBox.getGuiX() + this.textureScrollBox.getWidth(), this.textureScrollBox.getGuiY() + this.textureScrollBox.getHeight(), -2012213232, -1727000560);
        context.m_280024_(this.colorScrollBox.getGuiX() + 1, this.colorScrollBox.getGuiY() + 1, this.colorScrollBox.getGuiX() + this.colorScrollBox.getWidth(), this.colorScrollBox.getGuiY() + this.colorScrollBox.getHeight(), -2012213232, -1727000560);
        super.m_88315_(context, mouseX, mouseY, partialTick);
    }

    static interface IMarkerTypeSelectListener {
        public void onSelectMarkerType(MarkerTexture var1);
    }
}

