/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.antique_atlas;

import folk.sisby.antique_atlas.AntiqueAtlas;
import folk.sisby.antique_atlas.TileElevation;
import folk.sisby.antique_atlas.TileTexture;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import org.jetbrains.annotations.Nullable;

public record TerrainTileProvider(ResourceLocation id, Map<TileElevation, List<TileTexture>> textures) {
    public static final TerrainTileProvider DEFAULT = new TerrainTileProvider(AntiqueAtlas.id("test"), List.of(TileTexture.DEFAULT));

    public TerrainTileProvider(ResourceLocation id, List<TileTexture> textures) {
        this(id, Arrays.stream(TileElevation.values()).collect(Collectors.toMap(e -> e, e -> textures)));
    }

    public TileTexture getTexture(ChunkPos pos, @Nullable TileElevation elevation) {
        int variation = (int)(Mth.m_14130_((int)pos.f_45578_, (int)pos.f_45579_, (int)(pos.f_45578_ * pos.f_45579_)) & Integer.MAX_VALUE);
        TileElevation usedElevation = elevation == null ? TileElevation.VALLEY : elevation;
        return this.textures.get((Object)usedElevation).get(variation % this.textures.get((Object)usedElevation).size());
    }
}

