/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.antique_atlas;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import folk.sisby.antique_atlas.AntiqueAtlas;
import folk.sisby.antique_atlas.util.DrawBatcher;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import org.joml.Vector2d;

public record MarkerTexture(ResourceLocation id, ResourceLocation accentId, int offsetX, int offsetY, int textureWidth, int textureHeight, int mipLevels, int nearClip, int farClip) {
    public static final MarkerTexture DEFAULT = MarkerTexture.centered(AntiqueAtlas.id("custom/point"), 32, 32, 0, 1, Integer.MAX_VALUE, true);

    private static ResourceLocation idToTexture(ResourceLocation id) {
        return id.m_246208_("textures/atlas/marker/").m_266382_(".png");
    }

    public static MarkerTexture ofId(ResourceLocation id, int offsetX, int offsetY, int width, int height, int mipLevels, int nearClip, int farClip, boolean accent) {
        return new MarkerTexture(MarkerTexture.idToTexture(id), accent ? MarkerTexture.idToTexture(id.m_266382_("_accent")) : null, offsetX, offsetY, width, height, mipLevels, nearClip, farClip);
    }

    public static MarkerTexture centered(ResourceLocation id, int width, int height, int mipLevels, int nearClip, int farClip, boolean accent) {
        return MarkerTexture.ofId(id, -width / 2, -height / 2, width, height, mipLevels, nearClip, farClip, accent);
    }

    public ResourceLocation keyId() {
        return new ResourceLocation(this.id.m_135827_(), this.id.m_135815_().substring("textures/atlas/marker/".length(), this.id.m_135815_().length() - 4));
    }

    public String displayId() {
        return this.id.m_135827_().equals("antique_atlas") ? this.keyId().m_135815_() : this.keyId().toString();
    }

    public int fullTextureWidth() {
        int width = this.textureWidth;
        for (int i = 0; i < this.mipLevels; ++i) {
            width += this.textureWidth >> i + 1;
        }
        return width;
    }

    public int getU(int mipLevel) {
        int u = 0;
        for (int currentMipLevel = mipLevel - 1; currentMipLevel >= 0; --currentMipLevel) {
            u += this.textureWidth / (1 << currentMipLevel);
        }
        return u;
    }

    public Vector2d getCenter(int tileChunks) {
        int mipLevel = Mth.m_14045_((int)Mth.m_14163_((int)tileChunks), (int)0, (int)this.mipLevels);
        return new Vector2d(((double)this.offsetX + (double)this.textureWidth / 2.0) / (double)(1 << mipLevel), ((double)this.offsetY + (double)this.textureHeight / 2.0) / (double)(1 << mipLevel));
    }

    public double getSquaredSize(int tileChunks) {
        int mipLevel = Mth.m_14045_((int)Mth.m_14163_((int)tileChunks), (int)0, (int)this.mipLevels);
        return (double)(this.textureWidth * this.textureHeight) / (double)(1 << mipLevel);
    }

    public void drawIcon(GuiGraphics context, int x, int y, float[] accent) {
        context.m_280163_(this.id, x, y, 0.0f, 0.0f, this.textureWidth, this.textureHeight, this.fullTextureWidth(), this.textureHeight);
        if (this.accentId != null && accent != null) {
            RenderSystem.setShaderColor((float)accent[0], (float)accent[1], (float)accent[2], (float)1.0f);
            context.m_280163_(this.accentId, x, y, 0.0f, 0.0f, this.textureWidth, this.textureHeight, this.fullTextureWidth(), this.textureHeight);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void draw(GuiGraphics context, double markerX, double markerY, float markerScale, int tileChunks, float[] accent, float tint, float alpha) {
        if (alpha == 0.0f) {
            return;
        }
        context.m_280168_().m_85836_();
        context.m_280168_().m_85837_(markerX, markerY, 0.0);
        context.m_280168_().m_85841_(markerScale, markerScale, 1.0f);
        RenderSystem.setShaderColor((float)tint, (float)tint, (float)tint, (float)alpha);
        if (tileChunks > 1 && this.mipLevels > 0) {
            int mipLevel = Mth.m_14045_((int)Mth.m_14163_((int)tileChunks), (int)0, (int)this.mipLevels);
            context.m_280163_(this.id, this.offsetX / (1 << mipLevel), this.offsetY / (1 << mipLevel), (float)this.getU(mipLevel), 0.0f, this.textureWidth / (1 << mipLevel), this.textureHeight / (1 << mipLevel), this.fullTextureWidth(), this.textureHeight);
            if (this.accentId != null && accent != null) {
                RenderSystem.setShaderColor((float)(tint * accent[0]), (float)(tint * accent[1]), (float)(tint * accent[2]), (float)alpha);
                context.m_280163_(this.accentId, this.offsetX / (1 << mipLevel), this.offsetY / (1 << mipLevel), (float)this.getU(mipLevel), 0.0f, this.textureWidth / (1 << mipLevel), this.textureHeight / (1 << mipLevel), this.fullTextureWidth(), this.textureHeight);
            }
        } else {
            context.m_280163_(this.id, this.offsetX, this.offsetY, 0.0f, 0.0f, this.textureWidth, this.textureHeight, this.fullTextureWidth(), this.textureHeight);
            if (this.accentId != null && accent != null) {
                RenderSystem.setShaderColor((float)(tint * accent[0]), (float)(tint * accent[1]), (float)(tint * accent[2]), (float)alpha);
                context.m_280163_(this.accentId, this.offsetX, this.offsetY, 0.0f, 0.0f, this.textureWidth, this.textureHeight, this.fullTextureWidth(), this.textureHeight);
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        context.m_280168_().m_85849_();
    }

    public void draw(PoseStack matrices, MultiBufferSource vertexConsumers, double markerX, double markerY, float z, float markerScale, int tileChunks, float[] accent, float tint, float alpha, int light) {
        int accentArgb;
        if (alpha == 0.0f) {
            return;
        }
        if (AntiqueAtlas.CONFIG.shaderCompat) {
            alpha = 1.0f;
        }
        matrices.m_85836_();
        matrices.m_85837_(markerX, markerY, 0.0);
        matrices.m_85841_(markerScale, markerScale, 1.0f);
        int mainArgb = FastColor.ARGB32.m_13660_((int)((int)(alpha * 255.0f)), (int)((int)(tint * 255.0f)), (int)((int)(tint * 255.0f)), (int)((int)(tint * 255.0f)));
        int n = accentArgb = accent != null ? FastColor.ARGB32.m_13660_((int)((int)(alpha * 255.0f)), (int)((int)(tint * accent[0] * 255.0f)), (int)((int)(tint * accent[1] * 255.0f)), (int)((int)(tint * accent[2] * 255.0f))) : 0;
        if (tileChunks > 1 && this.mipLevels > 0) {
            int mipLevel = Mth.m_14045_((int)Mth.m_14163_((int)tileChunks), (int)0, (int)this.mipLevels);
            try (DrawBatcher batcher = new DrawBatcher(matrices, vertexConsumers, this.id, this.fullTextureWidth(), this.textureHeight, light);){
                batcher.add(this.offsetX / (1 << mipLevel), this.offsetY / (1 << mipLevel), z, this.textureWidth / (1 << mipLevel), this.textureHeight / (1 << mipLevel), this.getU(mipLevel), 0, this.textureWidth / (1 << mipLevel), this.textureHeight / (1 << mipLevel), mainArgb);
            }
            if (this.accentId != null && accent != null) {
                batcher = new DrawBatcher(matrices, vertexConsumers, this.accentId, this.fullTextureWidth(), this.textureHeight, light);
                try {
                    batcher.add(this.offsetX / (1 << mipLevel), this.offsetY / (1 << mipLevel), z, this.textureWidth / (1 << mipLevel), this.textureHeight / (1 << mipLevel), this.getU(mipLevel), 0, this.textureWidth / (1 << mipLevel), this.textureHeight / (1 << mipLevel), accentArgb);
                }
                finally {
                    batcher.close();
                }
            }
        } else {
            try (DrawBatcher batcher = new DrawBatcher(matrices, vertexConsumers, this.id, this.fullTextureWidth(), this.textureHeight, light);){
                batcher.add(this.offsetX, this.offsetY, z, this.textureWidth, this.textureHeight, 0, 0, this.textureWidth, this.textureHeight, mainArgb);
            }
            if (this.accentId != null && accent != null) {
                batcher = new DrawBatcher(matrices, vertexConsumers, this.accentId, this.fullTextureWidth(), this.textureHeight, light);
                try {
                    batcher.add(this.offsetX, this.offsetY, z, this.textureWidth, this.textureHeight, 0, 0, this.textureWidth, this.textureHeight, accentArgb);
                }
                finally {
                    batcher.close();
                }
            }
        }
        matrices.m_85849_();
    }
}

