/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.util;

import folk.sisby.surveyor.Surveyor;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;

public class ChunkUtil {
    public static Integer airCount(ChunkAccess chunk) {
        return Arrays.stream(chunk.m_7103_()).mapToInt(s -> 4096 - s.f_62969_).sum();
    }

    public static File[] getRegionFiles(File folder, String prefix) {
        return folder.listFiles((file, name) -> {
            String[] split = name.split("\\.");
            if (split.length == 4 && split[0].equals(prefix) && split[3].equals("dat")) {
                try {
                    Integer.parseInt(split[1]);
                    Integer.parseInt(split[2]);
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return false;
        });
    }

    public static Map<ChunkPos, CompoundTag> getRegionNbt(File folder, String prefix) {
        File[] regionFiles = ChunkUtil.getRegionFiles(folder, prefix);
        HashMap<ChunkPos, CompoundTag> regions = new HashMap<ChunkPos, CompoundTag>();
        if (regionFiles != null) {
            for (File regionFile : regionFiles) {
                ChunkPos regionPos = new ChunkPos(Integer.parseInt(regionFile.getName().split("\\.")[1]), Integer.parseInt(regionFile.getName().split("\\.")[2]));
                CompoundTag regionCompound = null;
                try {
                    regionCompound = NbtIo.m_128937_((File)regionFile);
                }
                catch (IOException e) {
                    Surveyor.LOGGER.error("[Surveyor] Error loading region nbt file {}.", (Object)regionFile.getName(), (Object)e);
                }
                if (regionCompound == null) continue;
                regions.put(regionPos, regionCompound);
            }
        }
        return regions;
    }
}

