/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.packet;

import folk.sisby.surveyor.ServerSummary;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.config.NetworkMode;
import folk.sisby.surveyor.packet.SurveyorPacket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public interface S2CPacket
extends SurveyorPacket {
    default public void send(Collection<ServerPlayer> players) {
        Collection<FriendlyByteBuf> bufs = null;
        for (ServerPlayer player : players) {
            if (!ServerPlayNetworking.canSend((ServerPlayer)player, (ResourceLocation)this.getId()) || player.m_20194_().m_7779_(player.m_36316_())) continue;
            if (bufs == null) {
                bufs = this.toBufs();
            }
            bufs.forEach(buf -> ServerPlayNetworking.send((ServerPlayer)player, (ResourceLocation)this.getId(), (FriendlyByteBuf)buf));
        }
    }

    default public void send(ServerPlayer player) {
        this.send(List.of(player));
    }

    default public void send(ServerLevel world) {
        this.send(world.m_6907_());
    }

    default public void send(ServerPlayer sender, ServerLevel world) {
        ArrayList<ServerPlayer> players = new ArrayList<ServerPlayer>(world.m_6907_());
        players.remove(sender);
        this.send(players);
    }

    default public void send(ServerPlayer sender, ServerLevel world, NetworkMode mode) {
        if (mode.atMost(NetworkMode.SOLO)) {
            return;
        }
        ArrayList<ServerPlayer> players = new ArrayList<ServerPlayer>(world.m_6907_());
        players.remove(sender);
        if (sender != null && mode.atMost(NetworkMode.GROUP)) {
            ServerSummary.of(world.m_7654_()).groupOtherServerPlayers(Surveyor.getUuid(sender), world.m_7654_()).forEach(players::remove);
        }
        this.send(players);
    }

    default public void send(MinecraftServer server) {
        this.send(server.m_6846_().m_11314_());
    }

    default public void send(ServerPlayer sender, MinecraftServer server) {
        ArrayList<ServerPlayer> players = new ArrayList<ServerPlayer>(server.m_6846_().m_11314_());
        players.remove(sender);
        this.send(players);
    }
}

