/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.client;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import folk.sisby.surveyor.PlayerSummary;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.SurveyorExploration;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.client.SurveyorClient;
import folk.sisby.surveyor.config.SystemMode;
import folk.sisby.surveyor.landmark.Landmark;
import folk.sisby.surveyor.landmark.LandmarkType;
import folk.sisby.surveyor.landmark.Landmarks;
import folk.sisby.surveyor.landmark.SimplePointLandmark;
import folk.sisby.surveyor.landmark.WorldLandmarks;
import folk.sisby.surveyor.util.TextUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.ChatFormatting;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.WorldCoordinates;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;

public class SurveyorClientCommands {
    private static void informGroup(Map<UUID, PlayerSummary> group, Consumer<Component> feedback) {
        feedback.accept((Component)Component.m_237113_((String)"You're sharing your map with ").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)"%d".formatted(group.size() - 1)).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)(" other" + (group.size() - 1 > 1 ? " players:" : " player:"))).m_130940_(ChatFormatting.GOLD)));
        feedback.accept((Component)TextUtil.highlightStrings(group.entrySet().stream().filter(e -> !((UUID)e.getKey()).equals(SurveyorClient.getClientUuid())).map(e -> ((PlayerSummary)e.getValue()).username()).toList(), s -> ChatFormatting.WHITE).m_130940_(ChatFormatting.GOLD));
    }

    private static int info(WorldSummary summary, SurveyorExploration exploration, SurveyorExploration groupExploration, Consumer<Component> feedback) {
        HashSet landmarks = new HashSet();
        HashSet waypoints = new HashSet();
        HashSet groupLandmarks = new HashSet();
        HashSet groupWaypoints = new HashSet();
        Map<UUID, PlayerSummary> group = SurveyorClient.getFriends();
        WorldLandmarks worldLandmarks = summary.landmarks();
        if (worldLandmarks != null) {
            worldLandmarks.asMap(exploration).forEach((type, inner) -> inner.forEach((pos, landmark) -> (landmark.owner() == null ? landmarks : waypoints).add(landmark)));
            worldLandmarks.asMap(groupExploration).forEach((type, inner) -> inner.forEach((pos, landmark) -> (landmark.owner() == null ? groupLandmarks : groupWaypoints).add(landmark)));
        }
        feedback.accept((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"---Map Exploration Summary---").m_130940_(ChatFormatting.GRAY)));
        feedback.accept((Component)Component.m_237113_((String)"You've explored ").m_130940_(ChatFormatting.AQUA).m_7220_((Component)Component.m_237113_((String)"%d".formatted(exploration.chunkCount())).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)" total chunks!").m_130940_(ChatFormatting.AQUA)).m_7220_((Component)(group.size() <= 1 ? Component.m_237119_() : Component.m_237113_((String)" (").m_130940_(ChatFormatting.AQUA).m_7220_((Component)Component.m_237113_((String)"%d".formatted(groupExploration.chunkCount())).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)" with friends)").m_130940_(ChatFormatting.AQUA)))));
        feedback.accept((Component)Component.m_237113_((String)"You've explored ").m_130940_(ChatFormatting.LIGHT_PURPLE).m_7220_((Component)Component.m_237113_((String)"%d".formatted(exploration.structureCount())).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)" structures!").m_130940_(ChatFormatting.LIGHT_PURPLE)).m_7220_((Component)(group.size() <= 1 ? Component.m_237119_() : Component.m_237113_((String)" (").m_130940_(ChatFormatting.LIGHT_PURPLE).m_7220_((Component)Component.m_237113_((String)"%d".formatted(groupExploration.structureCount())).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)" with friends)").m_130940_(ChatFormatting.LIGHT_PURPLE)))));
        feedback.accept((Component)Component.m_237113_((String)"You've explored ").m_130940_(ChatFormatting.GREEN).m_7220_((Component)Component.m_237113_((String)"%d".formatted(landmarks.size())).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)" landmarks here!").m_130940_(ChatFormatting.GREEN)).m_7220_((Component)(group.size() <= 1 ? Component.m_237119_() : Component.m_237113_((String)" (").m_130940_(ChatFormatting.GREEN).m_7220_((Component)Component.m_237113_((String)"%d".formatted(groupLandmarks.size())).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)" with friends)").m_130940_(ChatFormatting.GREEN)))));
        feedback.accept((Component)Component.m_237113_((String)"...and created ").m_130940_(ChatFormatting.GREEN).m_7220_((Component)Component.m_237113_((String)"%d".formatted(waypoints.size())).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)" waypoints!").m_130940_(ChatFormatting.GREEN)).m_7220_((Component)(group.size() <= 1 ? Component.m_237119_() : Component.m_237113_((String)" (").m_130940_(ChatFormatting.GREEN).m_7220_((Component)Component.m_237113_((String)"%d".formatted(groupWaypoints.size())).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)" with friends)").m_130940_(ChatFormatting.GREEN)))));
        if (group.size() > 1) {
            SurveyorClientCommands.informGroup(SurveyorClient.getFriends(), feedback);
        }
        feedback.accept((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"-------End Summary-------").m_130940_(ChatFormatting.GRAY)));
        return 1;
    }

    private static int landmarkInfo(WorldSummary summary, SurveyorExploration exploration, SurveyorExploration groupExploration, Consumer<Component> feedback) {
        Collection<PlayerSummary> group = SurveyorClient.getFriends().values();
        feedback.accept((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"---World Landmark Types---").m_130940_(ChatFormatting.GRAY)));
        HashSet<LandmarkType> waypoints = new HashSet<LandmarkType>();
        HashMultimap keys = HashMultimap.create();
        HashMultimap groupKeys = HashMultimap.create();
        HashMultimap personalKeys = HashMultimap.create();
        WorldLandmarks worldLandmarks = summary.landmarks();
        if (worldLandmarks != null) {
            waypoints.addAll(worldLandmarks.asMap(null).values().stream().flatMap(e -> e.values().stream().filter(l -> l.owner() != null)).map(Landmark::type).toList());
            keys.putAll(worldLandmarks.keySet(null));
            groupKeys.putAll(worldLandmarks.keySet(groupExploration));
            personalKeys.putAll(worldLandmarks.keySet(exploration));
        }
        keys.asMap().forEach((arg_0, arg_1) -> SurveyorClientCommands.lambda$landmarkInfo$9(feedback, waypoints, (Multimap)personalKeys, group, (Multimap)groupKeys, (Multimap)keys, arg_0, arg_1));
        feedback.accept((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"-------End Landmarks-------").m_130940_(ChatFormatting.GRAY)));
        return 1;
    }

    private static int getLandmarks(WorldSummary summary, Consumer<Component> feedback, ResourceLocation type) {
        if (summary.landmarks() == null) {
            feedback.accept((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"The landmark system is dynamically disabled!").m_130940_(ChatFormatting.YELLOW)));
            return 0;
        }
        Map<BlockPos, ?> landmarks = summary.landmarks().asMap(Landmarks.getType(type), null);
        if (landmarks.isEmpty()) {
            feedback.accept((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"There are no landmarks of that type in this world!").m_130940_(ChatFormatting.YELLOW)));
            return 0;
        }
        feedback.accept((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"---World %s Landmarks---".formatted(type)).m_130940_(ChatFormatting.GRAY)));
        for (Landmark landmark : landmarks.values()) {
            feedback.accept((Component)Component.m_237113_((String)"[").m_130940_(ChatFormatting.AQUA).m_7220_((Component)Component.m_237113_((String)landmark.pos().m_123344_()).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)"]").m_130940_(ChatFormatting.AQUA)).m_7220_((Component)Component.m_237113_((String)" - ").m_130940_(landmark.owner() != null ? ChatFormatting.GREEN : ChatFormatting.RED)).m_7220_((Component)Component.m_237113_((String)"\"").m_130940_(ChatFormatting.GOLD)).m_7220_((Component)(landmark.name() == null ? Component.m_130674_((String)"") : landmark.name().m_6881_().m_130938_(s -> s.m_178520_(landmark.color() != null ? landmark.color().m_41070_() : ChatFormatting.WHITE.m_126665_().intValue())))).m_7220_((Component)Component.m_237113_((String)"\"").m_130940_(ChatFormatting.GOLD)));
        }
        feedback.accept((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"---End %s Landmarks---".formatted(type)).m_130940_(ChatFormatting.GRAY)));
        return landmarks.size();
    }

    private static int removeLandmark(WorldSummary summary, ClientLevel world, Consumer<Component> feedback, ResourceLocation type, BlockPos pos) {
        if (summary.landmarks() == null) {
            feedback.accept((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"The landmark system is dynamically disabled!").m_130940_(ChatFormatting.YELLOW)));
            return 0;
        }
        if (!summary.landmarks().contains(Landmarks.getType(type), pos)) {
            feedback.accept((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"No landmark exists of that type and position!").m_130940_(ChatFormatting.YELLOW)));
            return 0;
        }
        Landmark<?> landmark = summary.landmarks().get(Landmarks.getType(type), pos);
        summary.landmarks().remove((Level)world, Landmarks.getType(type), pos);
        feedback.accept((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"%s removed successfully!".formatted(landmark.owner() == null ? "Landmark" : "Waypoint")).m_130940_(ChatFormatting.GREEN)));
        return 1;
    }

    private static int addLandmark(WorldSummary summary, ClientLevel world, Consumer<Component> feedback, ResourceLocation type, BlockPos pos, DyeColor color, String name, boolean global) {
        if (summary.landmarks() == null) {
            feedback.accept((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"The landmark system is dynamically disabled!").m_130940_(ChatFormatting.YELLOW)));
            return 0;
        }
        if (!SimplePointLandmark.TYPE.id().equals((Object)type)) {
            feedback.accept((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"You can't create a landmark of that type!").m_130940_(ChatFormatting.YELLOW)));
            return 0;
        }
        if (summary.landmarks().contains(Landmarks.getType(type), pos)) {
            feedback.accept((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"A landmark exists of that type and position!").m_130940_(ChatFormatting.YELLOW)));
            return 0;
        }
        summary.landmarks().put((Level)world, new SimplePointLandmark(pos, global ? null : SurveyorClient.getClientUuid(), color, Component.m_130674_((String)(name.contains("\\n") ? name.substring(0, name.indexOf("\\n")) : name)), name.contains("\\n") ? Component.m_130674_((String)name.substring(name.indexOf("\\n") + 2)) : null, null));
        feedback.accept((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"%s added successfully!".formatted(global ? "Landmark" : "Waypoint")).m_130940_(ChatFormatting.GREEN)));
        return 1;
    }

    public static int execute(CommandContext<FabricClientCommandSource> context, SurveyorCommandExecutor<Integer> executor) {
        LocalPlayer player = ((FabricClientCommandSource)context.getSource()).getPlayer();
        SurveyorExploration exploration = SurveyorClient.getPersonalExploration();
        SurveyorClient.ClientExploration groupExploration = SurveyorClient.getSharedExploration();
        try {
            return executor.execute(WorldSummary.of((Level)((FabricClientCommandSource)context.getSource()).getWorld()), player, ((FabricClientCommandSource)context.getSource()).getWorld(), exploration, groupExploration, t -> ((FabricClientCommandSource)context.getSource()).sendFeedback(t));
        }
        catch (Exception e) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((Component)Component.m_237113_((String)"Command failed! Check log for details.").m_130940_(ChatFormatting.RED));
            Surveyor.LOGGER.error("[Surveyor] Error while executing command: {}", (Object)context.getInput(), (Object)e);
            return 0;
        }
    }

    private static CommandSourceStack sourceForPos(FabricClientCommandSource source) {
        return new CommandSourceStack(null, source.getPosition(), source.getRotation(), null, 0, null, null, null, source.getEntity());
    }

    public static void registerCommands(CommandDispatcher<FabricClientCommandSource> dispatcher, CommandBuildContext registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"surveyorc").executes(c -> SurveyorClientCommands.execute((CommandContext<FabricClientCommandSource>)c, (s, p, w, e, g, f) -> SurveyorClientCommands.info(s, e, g, f)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"landmarks").requires(c -> Surveyor.CONFIG.landmarks != SystemMode.DISABLED)).executes(c -> SurveyorClientCommands.execute((CommandContext<FabricClientCommandSource>)c, (s, p, w, e, g, f) -> SurveyorClientCommands.landmarkInfo(s, e, g, f)))).then(ClientCommandManager.literal((String)"get").then(ClientCommandManager.argument((String)"type", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((c, b) -> SharedSuggestionProvider.m_82926_(Landmarks.keySet(), (SuggestionsBuilder)b)).executes(c -> SurveyorClientCommands.execute((CommandContext<FabricClientCommandSource>)c, (s, p, w, e, g, f) -> SurveyorClientCommands.getLandmarks(s, f, (ResourceLocation)c.getArgument("type", ResourceLocation.class))))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"remove").requires(c -> Surveyor.CONFIG.landmarks != SystemMode.FROZEN)).then(ClientCommandManager.argument((String)"type", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((c, b) -> SharedSuggestionProvider.m_82926_(Landmarks.keySet(), (SuggestionsBuilder)b)).then(ClientCommandManager.argument((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(c -> SurveyorClientCommands.execute((CommandContext<FabricClientCommandSource>)c, (s, p, w, e, g, f) -> SurveyorClientCommands.removeLandmark(s, w, f, (ResourceLocation)c.getArgument("type", ResourceLocation.class), ((WorldCoordinates)c.getArgument("pos", WorldCoordinates.class)).m_119568_(SurveyorClientCommands.sourceForPos((FabricClientCommandSource)c.getSource()))))))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"add").requires(c -> Surveyor.CONFIG.landmarks != SystemMode.FROZEN)).then(ClientCommandManager.argument((String)"type", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((c, b) -> SharedSuggestionProvider.m_82926_(List.of(SimplePointLandmark.TYPE.id()), (SuggestionsBuilder)b)).then(ClientCommandManager.argument((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).then(ClientCommandManager.argument((String)"color", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> SharedSuggestionProvider.m_82981_(Arrays.stream(DyeColor.values()).map(DyeColor::m_41065_), (SuggestionsBuilder)b)).then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(c -> SurveyorClientCommands.execute((CommandContext<FabricClientCommandSource>)c, (s, p, w, e, g, f) -> SurveyorClientCommands.addLandmark(s, w, f, (ResourceLocation)c.getArgument("type", ResourceLocation.class), ((WorldCoordinates)c.getArgument("pos", WorldCoordinates.class)).m_119568_(SurveyorClientCommands.sourceForPos((FabricClientCommandSource)c.getSource())), DyeColor.m_41057_((String)((String)c.getArgument("color", String.class)), (DyeColor)DyeColor.WHITE), (String)c.getArgument("name", String.class), false))))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"global").requires(c -> Surveyor.CONFIG.landmarks != SystemMode.FROZEN)).requires(c -> c.getPlayer() == null || c.getPlayer().m_20310_(2))).then(ClientCommandManager.argument((String)"type", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((c, b) -> SharedSuggestionProvider.m_82926_(List.of(SimplePointLandmark.TYPE.id()), (SuggestionsBuilder)b)).then(ClientCommandManager.argument((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).then(ClientCommandManager.argument((String)"color", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> SharedSuggestionProvider.m_82981_(Arrays.stream(DyeColor.values()).map(DyeColor::m_41065_), (SuggestionsBuilder)b)).then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(c -> SurveyorClientCommands.execute((CommandContext<FabricClientCommandSource>)c, (s, p, w, e, g, f) -> SurveyorClientCommands.addLandmark(s, w, f, (ResourceLocation)c.getArgument("type", ResourceLocation.class), ((WorldCoordinates)c.getArgument("pos", WorldCoordinates.class)).m_119568_(SurveyorClientCommands.sourceForPos((FabricClientCommandSource)c.getSource())), DyeColor.m_41057_((String)((String)c.getArgument("color", String.class)), (DyeColor)DyeColor.WHITE), (String)c.getArgument("name", String.class), true))))))))));
    }

    private static /* synthetic */ void lambda$landmarkInfo$9(Consumer feedback, Set waypoints, Multimap personalKeys, Collection group, Multimap groupKeys, Multimap keys, LandmarkType type, Collection list) {
        feedback.accept(Component.m_237113_((String)"%s".formatted(type.id())).m_130940_(ChatFormatting.WHITE).m_7220_((Component)Component.m_237113_((String)(waypoints.contains(type) ? ": created " : ": explored ")).m_130940_(ChatFormatting.AQUA)).m_7220_((Component)Component.m_237113_((String)"%d".formatted(personalKeys.get((Object)type).size())).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)(group.size() <= 1 ? Component.m_237119_() : Component.m_237113_((String)" (").m_130940_(ChatFormatting.LIGHT_PURPLE).m_7220_((Component)Component.m_237113_((String)"%d".formatted(groupKeys.get((Object)type).size())).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)" shared)").m_130940_(ChatFormatting.LIGHT_PURPLE)))).m_7220_((Component)Component.m_237113_((String)" {of ").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)"%d".formatted(keys.get((Object)type).size())).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)"}").m_130940_(ChatFormatting.GOLD))));
    }

    public static interface SurveyorCommandExecutor<T> {
        public T execute(WorldSummary var1, LocalPlayer var2, ClientLevel var3, SurveyorExploration var4, SurveyorExploration var5, Consumer<Component> var6);
    }
}

