/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import folk.sisby.surveyor.PlayerSummary;
import folk.sisby.surveyor.ServerSummary;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.SurveyorExploration;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.config.SystemMode;
import folk.sisby.surveyor.landmark.Landmark;
import folk.sisby.surveyor.landmark.LandmarkType;
import folk.sisby.surveyor.landmark.Landmarks;
import folk.sisby.surveyor.landmark.SimplePointLandmark;
import folk.sisby.surveyor.landmark.WorldLandmarks;
import folk.sisby.surveyor.util.TextUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.WorldCoordinates;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;

public class SurveyorCommands {
    private static final Multimap<UUID, UUID> requests = HashMultimap.create();

    private static void informGroup(ServerPlayer player, Set<PlayerSummary> group, Consumer<Component> feedback) {
        feedback.accept((Component)Component.m_237113_((String)"You're sharing your map with ").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)"%d".formatted(group.size() - 1)).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)(" other" + (group.size() - 1 > 1 ? " players:" : " player:"))).m_130940_(ChatFormatting.GOLD)));
        feedback.accept((Component)TextUtil.highlightStrings(group.stream().map(PlayerSummary::username).filter(u -> !u.equals(player.m_36316_().getName())).toList(), s -> ChatFormatting.WHITE).m_130940_(ChatFormatting.GOLD));
    }

    private static int informGlobal(ServerSummary serverSummary, ServerPlayer player, Consumer<Component> feedback) {
        feedback.accept((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"The server has global sharing enabled!").m_130940_(ChatFormatting.YELLOW)));
        feedback.accept((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"You can't leave or modify the global sharing group!").m_130940_(ChatFormatting.YELLOW)));
        SurveyorCommands.informGroup(player, serverSummary.groupPlayers(Surveyor.getUuid(player), player.m_20194_()), feedback);
        return 0;
    }

    private static int info(ServerSummary serverSummary, ServerPlayer player, SurveyorExploration exploration, Consumer<Component> feedback) {
        Set<PlayerSummary> group = serverSummary.groupPlayers(Surveyor.getUuid(player), player.m_20194_());
        SurveyorExploration groupExploration = SurveyorExploration.ofShared(player);
        HashSet landmarks = new HashSet();
        HashSet waypoints = new HashSet();
        HashSet groupLandmarks = new HashSet();
        HashSet groupWaypoints = new HashSet();
        for (ServerLevel world : player.m_20194_().m_129785_()) {
            WorldLandmarks summary = WorldSummary.of((Level)world).landmarks();
            if (summary == null) continue;
            summary.asMap(exploration).forEach((type, inner) -> inner.forEach((pos, landmark) -> (landmark.owner() == null ? landmarks : waypoints).add(landmark)));
            summary.asMap(groupExploration).forEach((type, inner) -> inner.forEach((pos, landmark) -> (landmark.owner() == null ? groupLandmarks : groupWaypoints).add(landmark)));
        }
        feedback.accept((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"---Map Exploration Summary---").m_130940_(ChatFormatting.GRAY)));
        feedback.accept((Component)Component.m_237113_((String)"You've explored ").m_130940_(ChatFormatting.AQUA).m_7220_((Component)Component.m_237113_((String)"%d".formatted(exploration.chunkCount())).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)" total chunks!").m_130940_(ChatFormatting.AQUA)).m_7220_((Component)(group.size() <= 1 ? Component.m_237119_() : Component.m_237113_((String)" (").m_130940_(ChatFormatting.AQUA).m_7220_((Component)Component.m_237113_((String)"%d".formatted(groupExploration.chunkCount())).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)" with friends)").m_130940_(ChatFormatting.AQUA)))));
        feedback.accept((Component)Component.m_237113_((String)"You've explored ").m_130940_(ChatFormatting.LIGHT_PURPLE).m_7220_((Component)Component.m_237113_((String)"%d".formatted(exploration.structureCount())).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)" structures!").m_130940_(ChatFormatting.LIGHT_PURPLE)).m_7220_((Component)(group.size() <= 1 ? Component.m_237119_() : Component.m_237113_((String)" (").m_130940_(ChatFormatting.LIGHT_PURPLE).m_7220_((Component)Component.m_237113_((String)"%d".formatted(groupExploration.structureCount())).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)" with friends)").m_130940_(ChatFormatting.LIGHT_PURPLE)))));
        feedback.accept((Component)Component.m_237113_((String)"You've explored ").m_130940_(ChatFormatting.GREEN).m_7220_((Component)Component.m_237113_((String)"%d".formatted(landmarks.size())).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)" landmarks!").m_130940_(ChatFormatting.GREEN)).m_7220_((Component)(group.size() <= 1 ? Component.m_237119_() : Component.m_237113_((String)" (").m_130940_(ChatFormatting.GREEN).m_7220_((Component)Component.m_237113_((String)"%d".formatted(groupLandmarks.size())).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)" with friends)").m_130940_(ChatFormatting.GREEN)))));
        feedback.accept((Component)Component.m_237113_((String)"...and created ").m_130940_(ChatFormatting.GREEN).m_7220_((Component)Component.m_237113_((String)"%d".formatted(waypoints.size())).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)" waypoints!").m_130940_(ChatFormatting.GREEN)).m_7220_((Component)(group.size() <= 1 ? Component.m_237119_() : Component.m_237113_((String)" (").m_130940_(ChatFormatting.GREEN).m_7220_((Component)Component.m_237113_((String)"%d".formatted(groupWaypoints.size())).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)" with friends)").m_130940_(ChatFormatting.GREEN)))));
        if (group.size() > 1) {
            SurveyorCommands.informGroup(player, group, feedback);
        }
        feedback.accept((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"-------End Summary-------").m_130940_(ChatFormatting.GRAY)));
        return 1;
    }

    private static int landmarkInfo(ServerSummary serverSummary, ServerPlayer player, SurveyorExploration exploration, Consumer<Component> feedback) {
        Set<PlayerSummary> group = serverSummary.groupPlayers(Surveyor.getUuid(player), player.m_20194_());
        SurveyorExploration groupExploration = SurveyorExploration.ofShared(player);
        feedback.accept((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"---Landmark Types---").m_130940_(ChatFormatting.GRAY)));
        HashSet<LandmarkType> waypoints = new HashSet<LandmarkType>();
        HashMultimap keys = HashMultimap.create();
        HashMultimap groupKeys = HashMultimap.create();
        HashMultimap personalKeys = HashMultimap.create();
        for (ServerLevel world : player.m_20194_().m_129785_()) {
            WorldLandmarks summary = WorldSummary.of((Level)world).landmarks();
            if (summary == null) continue;
            waypoints.addAll(summary.asMap(null).values().stream().flatMap(e -> e.values().stream().filter(l -> l.owner() != null)).map(Landmark::type).toList());
            keys.putAll(summary.keySet(null));
            groupKeys.putAll(summary.keySet(groupExploration));
            personalKeys.putAll(summary.keySet(exploration));
        }
        keys.asMap().forEach((arg_0, arg_1) -> SurveyorCommands.lambda$landmarkInfo$8(feedback, waypoints, (Multimap)personalKeys, group, (Multimap)groupKeys, player, (Multimap)keys, arg_0, arg_1));
        feedback.accept((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"-------End Landmarks-------").m_130940_(ChatFormatting.GRAY)));
        return 1;
    }

    private static int share(ServerSummary serverSummary, ServerPlayer player, Consumer<Component> feedback, String username) {
        ServerPlayer sharePlayer = player.m_20194_().m_6846_().m_11255_(username);
        if (sharePlayer == null) {
            feedback.accept((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"Can't find an online player named ").m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)username).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)".").m_130940_(ChatFormatting.YELLOW)));
            return 0;
        }
        if (sharePlayer == player) {
            feedback.accept((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"You can't share map exploration with yourself!").m_130940_(ChatFormatting.YELLOW)));
            return 0;
        }
        if (requests.containsEntry((Object)Surveyor.getUuid(player), (Object)Surveyor.getUuid(sharePlayer))) {
            if (serverSummary.groupSize(Surveyor.getUuid(player)) > 1 && serverSummary.groupSize(Surveyor.getUuid(sharePlayer)) > 1) {
                feedback.accept((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"You're in a group! leave your group first with:").m_130940_(ChatFormatting.YELLOW)));
                feedback.accept((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"/surveyor unshare").m_130940_(ChatFormatting.GOLD)));
                return 0;
            }
            requests.removeAll((Object)Surveyor.getUuid(player));
            ServerSummary.of(player.m_20194_()).joinGroup(Surveyor.getUuid(player), Surveyor.getUuid(sharePlayer), player.m_20194_());
            feedback.accept((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"You're now sharing map exploration with ").m_130940_(ChatFormatting.GREEN)).m_7220_((Component)Component.m_237113_((String)"%d".formatted(serverSummary.groupSize(Surveyor.getUuid(player)) - 1)).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)(serverSummary.groupSize(Surveyor.getUuid(player)) - 1 > 1 ? " players:" : " player:")).m_130940_(ChatFormatting.GREEN)));
            feedback.accept((Component)TextUtil.highlightStrings(serverSummary.groupPlayers(Surveyor.getUuid(player), player.m_20194_()).stream().map(PlayerSummary::username).filter(u -> !u.equals(player.m_36316_().getName())).toList(), s -> ChatFormatting.WHITE).m_130940_(ChatFormatting.GREEN));
            for (ServerPlayer friend : serverSummary.groupOtherServerPlayers(Surveyor.getUuid(player), player.m_20194_())) {
                friend.m_213846_((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)player.m_5446_().m_6881_().m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)" is now sharing their map with you.").m_130940_(ChatFormatting.AQUA)));
                friend.m_213846_((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"You're now sharing map exploration with ").m_130940_(ChatFormatting.AQUA)).m_7220_((Component)Component.m_237113_((String)"%d".formatted(serverSummary.groupSize(Surveyor.getUuid(player)) - 1)).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)(serverSummary.groupSize(Surveyor.getUuid(player)) - 1 > 1 ? " players:" : " player:")).m_130940_(ChatFormatting.AQUA)));
                friend.m_213846_((Component)TextUtil.highlightStrings(serverSummary.groupPlayers(Surveyor.getUuid(player), player.m_20194_()).stream().map(PlayerSummary::username).filter(u -> !u.equals(friend.m_36316_().getName())).toList(), s -> ChatFormatting.WHITE).m_130940_(ChatFormatting.AQUA));
            }
            return 1;
        }
        if (!requests.containsEntry((Object)Surveyor.getUuid(sharePlayer), (Object)Surveyor.getUuid(player))) {
            requests.put((Object)Surveyor.getUuid(sharePlayer), (Object)Surveyor.getUuid(player));
            feedback.accept((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"Share request sent to ").m_130940_(ChatFormatting.GREEN)).m_7220_((Component)sharePlayer.m_5446_().m_6881_().m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)".").m_130940_(ChatFormatting.GREEN)));
            sharePlayer.m_213846_((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)player.m_5446_().m_6881_().m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)" wants to share map exploration!").m_130940_(ChatFormatting.AQUA)));
            if (serverSummary.groupSize(Surveyor.getUuid(player)) <= 1 && serverSummary.groupSize(Surveyor.getUuid(sharePlayer)) <= 1) {
                feedback.accept((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"If accepted, you'll share your map exploration.").m_130940_(ChatFormatting.GREEN)));
                sharePlayer.m_213846_((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"To share your explored map area, enter:").m_130940_(ChatFormatting.AQUA)));
            } else if (serverSummary.groupSize(Surveyor.getUuid(player)) <= 1) {
                feedback.accept((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"If accepted, you'll share with their group of ").m_130940_(ChatFormatting.GREEN)).m_7220_((Component)Component.m_237113_((String)"%d".formatted(serverSummary.groupSize(Surveyor.getUuid(sharePlayer)))).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)".").m_130940_(ChatFormatting.GREEN)));
                sharePlayer.m_213846_((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"To share your group of ").m_7220_((Component)Component.m_237113_((String)"%d".formatted(serverSummary.groupSize(Surveyor.getUuid(sharePlayer)))).m_130940_(ChatFormatting.WHITE)).m_130940_(ChatFormatting.AQUA)).m_7220_((Component)Component.m_237113_((String)", enter:").m_130940_(ChatFormatting.AQUA)));
            } else {
                feedback.accept((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"If accepted, they'll share with your group of ").m_130940_(ChatFormatting.GREEN)).m_7220_((Component)Component.m_237113_((String)"%d".formatted(serverSummary.groupSize(Surveyor.getUuid(player)))).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)".").m_130940_(ChatFormatting.GREEN)));
                sharePlayer.m_213846_((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"To share with their group of ").m_7220_((Component)Component.m_237113_((String)"%d".formatted(serverSummary.groupSize(Surveyor.getUuid(player)))).m_130940_(ChatFormatting.WHITE)).m_130940_(ChatFormatting.AQUA)).m_7220_((Component)Component.m_237113_((String)", enter:").m_130940_(ChatFormatting.AQUA)));
            }
            sharePlayer.m_213846_((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"/surveyor share %s".formatted(player.m_36316_().getName())).m_130940_(ChatFormatting.GOLD)));
            return 1;
        }
        feedback.accept((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"You've already sent this player a share request!").m_130940_(ChatFormatting.YELLOW)));
        return 0;
    }

    private static int unshare(ServerSummary serverSummary, ServerPlayer player, Consumer<Component> feedback) {
        int shareNumber = serverSummary.groupSize(Surveyor.getUuid(player)) - 1;
        if (shareNumber == 0) {
            feedback.accept((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"You're not sharing map exploration with anyone!").m_130940_(ChatFormatting.YELLOW)));
            return 0;
        }
        Set<ServerPlayer> friends = serverSummary.groupOtherServerPlayers(Surveyor.getUuid(player), player.m_20194_());
        ServerSummary.of(player.m_20194_()).leaveGroup(Surveyor.getUuid(player), player.m_20194_());
        feedback.accept((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"Stopped sharing map exploration with ").m_130940_(ChatFormatting.GREEN)).m_7220_((Component)Component.m_237113_((String)"%d".formatted(shareNumber)).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)(shareNumber > 1 ? " players." : " player.")).m_130940_(ChatFormatting.GREEN)));
        for (ServerPlayer friend : friends) {
            int groupSize = serverSummary.groupSize(Surveyor.getUuid(friend)) - 1;
            friend.m_213846_((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)player.m_5446_().m_6881_().m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)" is no longer sharing with you.").m_130940_(ChatFormatting.AQUA)));
            friend.m_213846_((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"You're now sharing map exploration with ").m_130940_(ChatFormatting.AQUA)).m_7220_((Component)Component.m_237113_((String)"%d".formatted(groupSize)).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)(groupSize == 0 ? " players." : (groupSize > 1 ? " players:" : " player:"))).m_130940_(ChatFormatting.AQUA)));
            if (groupSize <= 0) continue;
            friend.m_213846_((Component)TextUtil.highlightStrings(serverSummary.groupPlayers(Surveyor.getUuid(friend), friend.m_20194_()).stream().map(PlayerSummary::username).filter(u -> !u.equals(friend.m_36316_().getName())).toList(), s -> ChatFormatting.WHITE).m_130940_(ChatFormatting.AQUA));
        }
        return 1;
    }

    private static int getLandmarks(WorldSummary summary, ServerPlayer player, SurveyorExploration exploration, Consumer<Component> feedback, ResourceLocation type) {
        if (summary.landmarks() == null) {
            feedback.accept((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"The landmark system is dynamically disabled!").m_130940_(ChatFormatting.YELLOW)));
            return 0;
        }
        Map<BlockPos, ?> landmarks = summary.landmarks().asMap(Landmarks.getType(type), player.m_20310_(2) ? null : exploration);
        if (landmarks.isEmpty()) {
            feedback.accept((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"There are no landmarks of that type in this world!").m_130940_(ChatFormatting.YELLOW)));
            return 0;
        }
        feedback.accept((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"---World %s Landmarks---".formatted(type)).m_130940_(ChatFormatting.GRAY)));
        for (Landmark landmark : landmarks.values()) {
            feedback.accept((Component)Component.m_237113_((String)"[").m_130940_(ChatFormatting.AQUA).m_7220_((Component)Component.m_237113_((String)landmark.pos().m_123344_()).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)"]").m_130940_(ChatFormatting.AQUA)).m_7220_((Component)Component.m_237113_((String)" - ").m_130940_(landmark.owner() != null ? ChatFormatting.GREEN : ChatFormatting.RED)).m_7220_((Component)Component.m_237113_((String)"\"").m_130940_(ChatFormatting.GOLD)).m_7220_((Component)(landmark.name() == null ? Component.m_130674_((String)"") : landmark.name().m_6881_().m_130938_(s -> s.m_178520_(landmark.color() != null ? landmark.color().m_41070_() : ChatFormatting.WHITE.m_126665_().intValue())))).m_7220_((Component)Component.m_237113_((String)"\"").m_130940_(ChatFormatting.GOLD)));
        }
        feedback.accept((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"---End %s Landmarks---".formatted(type)).m_130940_(ChatFormatting.GRAY)));
        return landmarks.size();
    }

    private static int removeLandmark(WorldSummary summary, ServerPlayer player, ServerLevel world, Consumer<Component> feedback, ResourceLocation type, BlockPos pos) {
        if (summary.landmarks() == null) {
            feedback.accept((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"The landmark system is dynamically disabled!").m_130940_(ChatFormatting.YELLOW)));
            return 0;
        }
        if (!summary.landmarks().contains(Landmarks.getType(type), pos)) {
            feedback.accept((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"No landmark exists of that type and position!").m_130940_(ChatFormatting.YELLOW)));
            return 0;
        }
        Landmark<?> landmark = summary.landmarks().get(Landmarks.getType(type), pos);
        if (!(landmark.owner() != null && landmark.owner() == Surveyor.getUuid(player) || player.m_20310_(2))) {
            feedback.accept((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"You don't have permission to delete that landmark!").m_130940_(ChatFormatting.YELLOW)));
            return 0;
        }
        summary.landmarks().remove((Level)world, Landmarks.getType(type), pos);
        feedback.accept((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"%s removed successfully!".formatted(landmark.owner() == null ? "Landmark" : "Waypoint")).m_130940_(ChatFormatting.GREEN)));
        return 1;
    }

    private static int addLandmark(WorldSummary summary, ServerPlayer player, ServerLevel world, Consumer<Component> feedback, ResourceLocation type, BlockPos pos, DyeColor color, String name, boolean global) {
        if (summary.landmarks() == null) {
            feedback.accept((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"The landmark system is dynamically disabled!").m_130940_(ChatFormatting.YELLOW)));
            return 0;
        }
        if (!SimplePointLandmark.TYPE.id().equals((Object)type)) {
            feedback.accept((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"You can't create a landmark of that type!").m_130940_(ChatFormatting.YELLOW)));
            return 0;
        }
        if (global && !player.m_20310_(2)) {
            feedback.accept((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"You don't have permission to add that landmark!").m_130940_(ChatFormatting.YELLOW)));
            return 0;
        }
        if (summary.landmarks().contains(Landmarks.getType(type), pos)) {
            feedback.accept((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"A landmark exists of that type and position!").m_130940_(ChatFormatting.YELLOW)));
            return 0;
        }
        summary.landmarks().put((Level)world, new SimplePointLandmark(pos, global ? null : Surveyor.getUuid(player), color, Component.m_130674_((String)(name.contains("\\n") ? name.substring(0, name.indexOf("\\n")) : name)), name.contains("\\n") ? Component.m_130674_((String)name.substring(name.indexOf("\\n") + 2)) : null, null));
        feedback.accept((Component)Component.m_237113_((String)"[Surveyor] ").m_130940_(ChatFormatting.DARK_RED).m_7220_((Component)Component.m_237113_((String)"%s added successfully!".formatted(global ? "Landmark" : "Waypoint")).m_130940_(ChatFormatting.GREEN)));
        return 1;
    }

    public static int execute(CommandContext<CommandSourceStack> context, SurveyorCommandExecutor<Integer> executor) {
        ServerPlayer player;
        try {
            player = ((CommandSourceStack)context.getSource()).m_81375_();
        }
        catch (CommandSyntaxException e) {
            Surveyor.LOGGER.error("[Surveyor] Commands cannot be invoked by a non-player");
            return 0;
        }
        SurveyorExploration exploration = SurveyorExploration.of(player);
        try {
            return executor.execute(ServerSummary.of(player.m_20194_()), WorldSummary.of((Level)((CommandSourceStack)context.getSource()).m_81372_()), player, ((CommandSourceStack)context.getSource()).m_81372_(), exploration, t -> ((CommandSourceStack)context.getSource()).m_288197_(() -> t, false));
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Command failed! Check log for details.").m_130940_(ChatFormatting.RED), false);
            Surveyor.LOGGER.error("[Surveyor] Error while executing command: {}", (Object)context.getInput(), (Object)e);
            return 0;
        }
    }

    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext registryAccess, Commands.CommandSelection environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"surveyor").executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, (s, w, p, sw, e, f) -> SurveyorCommands.info(s, p, e, f)))).then(Surveyor.CONFIG.networking.globalSharing ? Commands.m_82127_((String)"share").executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, (s, w, p, sw, e, f) -> SurveyorCommands.informGlobal(s, p, f))) : Commands.m_82127_((String)"share").then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> SharedSuggestionProvider.m_82981_(((CommandSourceStack)c.getSource()).m_81377_().m_6846_().m_11314_().stream().filter(p -> ((CommandSourceStack)c.getSource()).m_230896_() != p).map(p -> p.m_36316_().getName()), (SuggestionsBuilder)b)).executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, (s, w, p, sw, e, f) -> SurveyorCommands.share(s, p, f, (String)c.getArgument("player", String.class))))))).then(Surveyor.CONFIG.networking.globalSharing ? Commands.m_82127_((String)"unshare").executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, (s, w, p, sw, e, f) -> SurveyorCommands.informGlobal(s, p, f))) : Commands.m_82127_((String)"unshare").executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, (s, w, p, sw, e, f) -> SurveyorCommands.unshare(s, p, f))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"landmarks").requires(c -> Surveyor.CONFIG.landmarks != SystemMode.DISABLED)).executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, (s, w, p, sw, e, f) -> SurveyorCommands.landmarkInfo(s, p, e, f)))).then(Commands.m_82127_((String)"get").then(Commands.m_82129_((String)"type", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((c, b) -> SharedSuggestionProvider.m_82926_(Landmarks.keySet(), (SuggestionsBuilder)b)).executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, (s, w, p, sw, e, f) -> SurveyorCommands.getLandmarks(w, p, e, f, (ResourceLocation)c.getArgument("type", ResourceLocation.class))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"remove").requires(c -> Surveyor.CONFIG.landmarks != SystemMode.FROZEN)).then(Commands.m_82129_((String)"type", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((c, b) -> SharedSuggestionProvider.m_82926_(Landmarks.keySet(), (SuggestionsBuilder)b)).then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, (s, w, p, sw, e, f) -> SurveyorCommands.removeLandmark(w, p, sw, f, (ResourceLocation)c.getArgument("type", ResourceLocation.class), ((WorldCoordinates)c.getArgument("pos", WorldCoordinates.class)).m_119568_((CommandSourceStack)c.getSource())))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"add").requires(c -> Surveyor.CONFIG.landmarks != SystemMode.FROZEN)).then(Commands.m_82129_((String)"type", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((c, b) -> SharedSuggestionProvider.m_82926_(List.of(SimplePointLandmark.TYPE.id()), (SuggestionsBuilder)b)).then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"color", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> SharedSuggestionProvider.m_82981_(Arrays.stream(DyeColor.values()).map(DyeColor::m_41065_), (SuggestionsBuilder)b)).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, (s, w, p, sw, e, f) -> SurveyorCommands.addLandmark(w, p, sw, f, (ResourceLocation)c.getArgument("type", ResourceLocation.class), ((WorldCoordinates)c.getArgument("pos", WorldCoordinates.class)).m_119568_((CommandSourceStack)c.getSource()), DyeColor.m_41057_((String)((String)c.getArgument("color", String.class)), (DyeColor)DyeColor.WHITE), (String)c.getArgument("name", String.class), false))))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"global").requires(c -> Surveyor.CONFIG.landmarks != SystemMode.FROZEN)).requires(c -> c.m_230896_() == null || c.m_230896_().m_20310_(2))).then(Commands.m_82129_((String)"type", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((c, b) -> SharedSuggestionProvider.m_82926_(List.of(SimplePointLandmark.TYPE.id()), (SuggestionsBuilder)b)).then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"color", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> SharedSuggestionProvider.m_82981_(Arrays.stream(DyeColor.values()).map(DyeColor::m_41065_), (SuggestionsBuilder)b)).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(c -> SurveyorCommands.execute((CommandContext<CommandSourceStack>)c, (s, w, p, sw, e, f) -> SurveyorCommands.addLandmark(w, p, sw, f, (ResourceLocation)c.getArgument("type", ResourceLocation.class), ((WorldCoordinates)c.getArgument("pos", WorldCoordinates.class)).m_119568_((CommandSourceStack)c.getSource()), DyeColor.m_41057_((String)((String)c.getArgument("color", String.class)), (DyeColor)DyeColor.WHITE), (String)c.getArgument("name", String.class), true))))))))));
    }

    private static /* synthetic */ void lambda$landmarkInfo$8(Consumer feedback, Set waypoints, Multimap personalKeys, Set group, Multimap groupKeys, ServerPlayer player, Multimap keys, LandmarkType type, Collection list) {
        feedback.accept(Component.m_237113_((String)"%s".formatted(type.id())).m_130940_(ChatFormatting.WHITE).m_7220_((Component)Component.m_237113_((String)(waypoints.contains(type) ? ": created " : ": explored ")).m_130940_(ChatFormatting.AQUA)).m_7220_((Component)Component.m_237113_((String)"%d".formatted(personalKeys.get((Object)type).size())).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)(group.size() <= 1 ? Component.m_237119_() : Component.m_237113_((String)" (").m_130940_(ChatFormatting.LIGHT_PURPLE).m_7220_((Component)Component.m_237113_((String)"%d".formatted(groupKeys.get((Object)type).size())).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)" shared)").m_130940_(ChatFormatting.LIGHT_PURPLE)))).m_7220_((Component)(!player.m_20310_(2) ? Component.m_237119_() : Component.m_237113_((String)" {of ").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)"%d".formatted(keys.get((Object)type).size())).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)"}").m_130940_(ChatFormatting.GOLD)))));
    }

    public static interface SurveyorCommandExecutor<T> {
        public T execute(ServerSummary var1, WorldSummary var2, ServerPlayer var3, ServerLevel var4, SurveyorExploration var5, Consumer<Component> var6);
    }
}

